/*
 * Decompiled with CFR 0.152.
 */
package com.github.junrar.io;

import com.github.junrar.io.IReadOnlyAccess;
import java.io.EOFException;
import java.io.IOException;

public class ReadOnlyAccessByteArray
implements IReadOnlyAccess {
    private int positionInFile;
    private byte[] file;

    public ReadOnlyAccessByteArray(byte[] file) {
        if (file == null) {
            throw new NullPointerException("file must not be null!!");
        }
        this.file = file;
        this.positionInFile = 0;
    }

    @Override
    public long getPosition() throws IOException {
        return this.positionInFile;
    }

    @Override
    public void setPosition(long pos) throws IOException {
        if (pos >= (long)this.file.length || pos < 0L) {
            throw new EOFException();
        }
        this.positionInFile = (int)pos;
    }

    @Override
    public int read() throws IOException {
        return this.file[this.positionInFile++];
    }

    @Override
    public int read(byte[] buffer, int off, int count) throws IOException {
        int read = Math.min(count, this.file.length - this.positionInFile);
        System.arraycopy(this.file, this.positionInFile, buffer, off, read);
        this.positionInFile += read;
        return read;
    }

    @Override
    public int readFully(byte[] buffer, int count) throws IOException {
        if (buffer == null) {
            throw new NullPointerException("buffer must not be null");
        }
        if (count == 0) {
            throw new IllegalArgumentException("cannot read 0 bytes ;-)");
        }
        int read = Math.min(count, this.file.length - this.positionInFile - 1);
        System.arraycopy(this.file, this.positionInFile, buffer, 0, read);
        this.positionInFile += read;
        return read;
    }

    @Override
    public void close() throws IOException {
    }
}

