package Locales::DB::Territory::tr;

use strict;
use warnings;

# Auto generated from CLDR
use if $Locales::_UNICODE_STRINGS, 'utf8';

$Locales::DB::Territory::tr::VERSION = '0.09';

$Locales::DB::Territory::tr::cldr_version = '2.0';

%Locales::DB::Territory::tr::code_to_name = (
    '001' => 'Dünya',
    '002' => 'Afrika',
    '003' => "Kuzey\ Amerika",
    '005' => "Güney\ Amerika",
    '009' => 'Okyanusya',
    '011' => "Batı\ Afrika",
    '013' => "Orta\ Amerika",
    '014' => "Doğu\ Afrika",
    '015' => "Kuzey\ Afrika",
    '017' => "Orta\ Afrika",
    '018' => "Afrika\'nın\ Güneyi",
    '019' => 'Amerika',
    '021' => "Amerika\'nın\ Kuzeyi",
    '029' => 'Karayipler',
    '030' => "Doğu\ Asya",
    '034' => "Güney\ Asya",
    '035' => "Güney\ Doğu\ Asya",
    '039' => "Güney\ Avrupa",
    '053' => "Avustralya\ ve\ Yeni\ Zelanda",
    '054' => 'Melanezya',
    '057' => 'Mikronezya',
    '061' => 'Polinezya',
    '062' => "Güney\ Orta\ Asya",
    142   => 'Asya',
    143   => "Orta\ Asya",
    145   => "Batı\ Asya",
    150   => 'Avrupa',
    151   => "Doğu\ Avrupa",
    154   => "Kuzey\ Avrupa",
    155   => "Batı\ Avrupa",
    172   => "Bağımsız\ Devletler\ Topluluğu",
    200   => 'Czechoslovakia',
    419   => "Latin\ Amerika",
    830   => "Kanal\ Adaları",
    'ac'  => "Ascension\ Adası",
    'ad'  => 'Andorra',
    'ae'  => "Birleşik\ Arap\ Emirlikleri",
    'af'  => 'Afganistan',
    'ag'  => "Antigua\ ve\ Barbuda",
    'ai'  => 'Anguilla',
    'al'  => 'Arnavutluk',
    'am'  => 'Ermenistan',
    'an'  => "Hollanda\ Antilleri",
    'ao'  => 'Angola',
    'aq'  => 'Antarktika',
    'ar'  => 'Arjantin',
    'as'  => "Amerikan\ Samoası",
    'at'  => 'Avusturya',
    'au'  => 'Avustralya',
    'aw'  => 'Aruba',
    'ax'  => "Aland\ Adaları",
    'az'  => 'Azerbaycan',
    'ba'  => "Bosna\ Hersek",
    'bb'  => 'Barbados',
    'bd'  => 'Bangladeş',
    'be'  => 'Belçika',
    'bf'  => "Burkina\ Faso",
    'bg'  => 'Bulgaristan',
    'bh'  => 'Bahreyn',
    'bi'  => 'Burundi',
    'bj'  => 'Benin',
    'bl'  => "Saint\ Barthelemy",
    'bm'  => 'Bermuda',
    'bn'  => 'Brunei',
    'bo'  => 'Bolivya',
    'bq'  => "British\ Antarctic\ Territory",
    'br'  => 'Brezilya',
    'bs'  => 'Bahamalar',
    'bt'  => 'Butan',
    'bv'  => "Bouvet\ Adası",
    'bw'  => 'Botsvana',
    'by'  => "Beyaz\ Rusya",
    'bz'  => 'Belize',
    'ca'  => 'Kanada',
    'cc'  => "Cocos\ Adaları",
    'cd'  => "Demokratik\ Kongo\ Cumhuriyeti",
    'cf'  => "Orta\ Afrika\ Cumhuriyeti",
    'cg'  => "Kongo\ Cumhuriyeti",
    'ch'  => 'İsviçre',
    'ci'  => "Fildişi\ Sahili",
    'ck'  => "Cook\ Adaları",
    'cl'  => 'Şili',
    'cm'  => 'Kamerun',
    'cn'  => 'Çin',
    'co'  => 'Kolombiya',
    'cp'  => "Clipperton\ Adası",
    'cr'  => "Kosta\ Rika",
    'cs'  => "Sırbistan\-Karadağ",
    'ct'  => "Canton\ and\ Enderbury\ Islands",
    'cu'  => 'Küba',
    'cv'  => "Cape\ Verde",
    'cx'  => "Christmas\ Adası",
    'cy'  => "Güney\ Kıbrıs\ Rum\ Kesimi",
    'cz'  => "Çek\ Cumhuriyeti",
    'dd'  => "East\ Germany",
    'de'  => 'Almanya',
    'dg'  => "Diego\ Garcia",
    'dj'  => 'Cibuti',
    'dk'  => 'Danimarka',
    'dm'  => 'Dominika',
    'do'  => "Dominik\ Cumhuriyeti",
    'dz'  => 'Cezayir',
    'ea'  => "Ceuta\ ve\ Melilla",
    'ec'  => 'Ekvador',
    'ee'  => 'Estonya',
    'eg'  => 'Mısır',
    'eh'  => "Batı\ Sahara",
    'er'  => 'Eritre',
    'es'  => 'İspanya',
    'et'  => 'Etiyopya',
    'eu'  => "Avrupa\ Birliği",
    'fi'  => 'Finlandiya',
    'fj'  => 'Fiji',
    'fk'  => "Falkland\ Adaları\ \[Malvinas\ Adaları\]",
    'fm'  => "Mikronezya\ Federal\ Eyaletleri",
    'fo'  => "Faroe\ Adaları",
    'fq'  => "French\ Southern\ and\ Antarctic\ Territories",
    'fr'  => 'Fransa',
    'fx'  => "Fransa\,\ Metropolitan",
    'ga'  => 'Gabon',
    'gb'  => "Birleşik\ Krallık",
    'gd'  => 'Grenada',
    'ge'  => 'Gürcistan',
    'gf'  => "Fransız\ Guyanası",
    'gg'  => 'Guernsey',
    'gh'  => 'Gana',
    'gi'  => 'Cebelitarık',
    'gl'  => 'Grönland',
    'gm'  => 'Gambiya',
    'gn'  => 'Gine',
    'gp'  => 'Guadalupe',
    'gq'  => "Ekvator\ Ginesi",
    'gr'  => 'Yunanistan',
    'gs'  => "Güney\ Georgia\ ve\ Güney\ Sandwich\ Adaları",
    'gt'  => 'Guatemala',
    'gu'  => 'Guam',
    'gw'  => "Gine\-Bissau",
    'gy'  => 'Guyana',
    'hk'  => "Hong\ Kong",
    'hm'  => "Heard\ Adası\ ve\ McDonald\ Adaları",
    'hn'  => 'Honduras',
    'hr'  => 'Hırvatistan',
    'ht'  => 'Haiti',
    'hu'  => 'Macaristan',
    'ic'  => "Kanarya\ Adaları",
    'id'  => 'Endonezya',
    'ie'  => 'İrlanda',
    'il'  => 'İsrail',
    'im'  => "Man\ Adası",
    'in'  => 'Hindistan',
    'io'  => "İngiliz\ Hint\ Okyanusu\ Bölgesi",
    'iq'  => 'Irak',
    'ir'  => 'İran',
    'is'  => 'İzlanda',
    'it'  => 'İtalya',
    'je'  => 'Jersey',
    'jm'  => 'Jamaika',
    'jo'  => 'Ürdün',
    'jp'  => 'Japonya',
    'jt'  => "Johnston\ Island",
    'ke'  => 'Kenya',
    'kg'  => 'Kırgızistan',
    'kh'  => 'Kamboçya',
    'ki'  => 'Kiribati',
    'km'  => 'Komorlar',
    'kn'  => "Saint\ Kitts\ ve\ Nevis",
    'kp'  => "Kuzey\ Kore",
    'kr'  => "Güney\ Kore",
    'kw'  => 'Kuveyt',
    'ky'  => "Cayman\ Adaları",
    'kz'  => 'Kazakistan',
    'la'  => 'Laos',
    'lb'  => 'Lübnan',
    'lc'  => "Saint\ Lucia",
    'li'  => 'Liechtenstein',
    'lk'  => "Sri\ Lanka",
    'lr'  => 'Liberya',
    'ls'  => 'Lesoto',
    'lt'  => 'Litvanya',
    'lu'  => 'Lüksemburg',
    'lv'  => 'Letonya',
    'ly'  => 'Libya',
    'ma'  => 'Fas',
    'mc'  => 'Monako',
    'md'  => 'Moldova',
    'me'  => 'Karadağ',
    'mf'  => "Saint\ Martin",
    'mg'  => 'Madagaskar',
    'mh'  => "Marshall\ Adaları",
    'mi'  => "Midway\ Islands",
    'mk'  => "Makedonya\ \[EYMC\]",
    'ml'  => 'Mali',
    'mm'  => 'Myanmar',
    'mn'  => 'Moğolistan',
    'mo'  => 'Makao',
    'mp'  => "Kuzey\ Mariana\ Adaları",
    'mq'  => 'Martinik',
    'mr'  => 'Moritanya',
    'ms'  => 'Montserrat',
    'mt'  => 'Malta',
    'mu'  => 'Mauritius',
    'mv'  => 'Maldivler',
    'mw'  => 'Malavi',
    'mx'  => 'Meksika',
    'my'  => 'Malezya',
    'mz'  => 'Mozambik',
    'na'  => 'Namibya',
    'nc'  => "Yeni\ Kaledonya",
    'ne'  => 'Nijer',
    'nf'  => "Norfolk\ Adası",
    'ng'  => 'Nijerya',
    'ni'  => 'Nikaragua',
    'nl'  => 'Hollanda',
    'no'  => 'Norveç',
    'np'  => 'Nepal',
    'nq'  => "Dronning\ Maud\ Land",
    'nr'  => 'Nauru',
    'nt'  => "Neutral\ Zone",
    'nu'  => 'Niue',
    'nz'  => "Yeni\ Zelanda",
    'om'  => 'Umman',
    'pa'  => 'Panama',
    'pc'  => "Pacific\ Islands\ Trust\ Territory",
    'pe'  => 'Peru',
    'pf'  => "Fransız\ Polinezyası",
    'pg'  => "Papua\ Yeni\ Gine",
    'ph'  => 'Filipinler',
    'pk'  => 'Pakistan',
    'pl'  => 'Polonya',
    'pm'  => "Saint\ Pierre\ ve\ Miquelon",
    'pn'  => 'Pitcairn',
    'pr'  => "Porto\ Riko",
    'ps'  => "Filistin\ Bölgesi",
    'pt'  => 'Portekiz',
    'pu'  => "U\.S\.\ Miscellaneous\ Pacific\ Islands",
    'pw'  => 'Palau',
    'py'  => 'Paraguay',
    'pz'  => "Panama\ Canal\ Zone",
    'qa'  => 'Katar',
    'qo'  => "Uzak\ Okyanusya",
    're'  => 'Reunion',
    'ro'  => 'Romanya',
    'rs'  => 'Sırbistan',
    'ru'  => 'Rusya',
    'rw'  => 'Ruanda',
    'sa'  => "Suudi\ Arabistan",
    'sb'  => "Solomon\ Adaları",
    'sc'  => 'Seyşeller',
    'sd'  => 'Sudan',
    'se'  => 'İsveç',
    'sg'  => 'Singapur',
    'sh'  => "Saint\ Helena",
    'si'  => 'Slovenya',
    'sj'  => "Svalbard\ ve\ Jan\ Mayen\ Adaları",
    'sk'  => 'Slovakya',
    'sl'  => "Sierra\ Leone",
    'sm'  => "San\ Marino",
    'sn'  => 'Senegal',
    'so'  => 'Somali',
    'sr'  => 'Surinam',
    'st'  => "Sao\ Tome\ ve\ Principe",
    'su'  => "Union\ of\ Soviet\ Socialist\ Republics",
    'sv'  => "El\ Salvador",
    'sy'  => 'Suriye',
    'sz'  => 'Svaziland',
    'ta'  => "Tristan\ da\ Cunha",
    'tc'  => "Turks\ ve\ Caicos\ Adaları",
    'td'  => 'Çad',
    'tf'  => "Fransız\ Güney\ Bölgeleri",
    'tg'  => 'Togo',
    'th'  => 'Tayland',
    'tj'  => 'Tacikistan',
    'tk'  => 'Tokelau',
    'tl'  => "Doğu\ Timor",
    'tm'  => 'Türkmenistan',
    'tn'  => 'Tunus',
    'to'  => 'Tonga',
    'tr'  => 'Türkiye',
    'tt'  => "Trinidad\ ve\ Tobago",
    'tv'  => 'Tuvalu',
    'tw'  => 'Tayvan',
    'tz'  => 'Tanzanya',
    'ua'  => 'Ukrayna',
    'ug'  => 'Uganda',
    'um'  => "Amerika\ Birleşik\ Devletleri\ Küçük\ Dış\ Adaları",
    'us'  => "Amerika\ Birleşik\ Devletleri",
    'uy'  => 'Uruguay',
    'uz'  => 'Özbekistan',
    'va'  => 'Vatikan',
    'vc'  => "Saint\ Vincent\ ve\ Grenadinler",
    'vd'  => "North\ Vietnam",
    've'  => 'Venezuela',
    'vg'  => "İngiliz\ Virgin\ Adaları",
    'vi'  => "ABD\ Virgin\ Adaları",
    'vn'  => 'Vietnam',
    'vu'  => 'Vanuatu',
    'wf'  => "Wallis\ ve\ Futuna\ Adaları",
    'wk'  => "Wake\ Island",
    'ws'  => 'Samoa',
    'yd'  => "People\â\\s\ Democratic\ Republic\ of\ Yemen",
    'ye'  => 'Yemen',
    'yt'  => 'Mayotte',
    'za'  => "Güney\ Afrika",
    'zm'  => 'Zambiya',
    'zw'  => 'Zimbabve',
    'zz'  => "Bilinmeyen\ Bölge",
);

%Locales::DB::Territory::tr::name_to_code = (
    'abdvirginadaları'                               => 'vi',
    'afganistan'                                      => 'af',
    'afrika'                                          => '002',
    'afrikanıngüneyi'                               => '018',
    'alandadaları'                                   => 'ax',
    'almanya'                                         => 'de',
    'amerika'                                         => '019',
    'amerikabirleşikdevletleri'                      => 'us',
    'amerikabirleşikdevletleriküçükdışadaları' => 'um',
    'amerikansamoası'                                => 'as',
    'amerikanınkuzeyi'                               => '021',
    'andorra'                                         => 'ad',
    'angola'                                          => 'ao',
    'anguilla'                                        => 'ai',
    'antarktika'                                      => 'aq',
    'antiguavebarbuda'                                => 'ag',
    'arjantin'                                        => 'ar',
    'arnavutluk'                                      => 'al',
    'aruba'                                           => 'aw',
    'ascensionadası'                                 => 'ac',
    'asya'                                            => 142,
    'avrupa'                                          => 150,
    'avrupabirliği'                                  => 'eu',
    'avustralya'                                      => 'au',
    'avustralyaveyenizelanda'                         => '053',
    'avusturya'                                       => 'at',
    'azerbaycan'                                      => 'az',
    'bahamalar'                                       => 'bs',
    'bahreyn'                                         => 'bh',
    'bangladeş'                                      => 'bd',
    'barbados'                                        => 'bb',
    'batıafrika'                                     => '011',
    'batıasya'                                       => 145,
    'batıavrupa'                                     => 155,
    'batısahara'                                     => 'eh',
    'bağımsızdevletlertopluluğu'                  => 172,
    'belize'                                          => 'bz',
    'belçika'                                        => 'be',
    'benin'                                           => 'bj',
    'bermuda'                                         => 'bm',
    'beyazrusya'                                      => 'by',
    'bilinmeyenbölge'                                => 'zz',
    'birleşikarapemirlikleri'                        => 'ae',
    'birleşikkrallık'                               => 'gb',
    'bolivya'                                         => 'bo',
    'bosnahersek'                                     => 'ba',
    'botsvana'                                        => 'bw',
    'bouvetadası'                                    => 'bv',
    'brezilya'                                        => 'br',
    'britishantarcticterritory'                       => 'bq',
    'brunei'                                          => 'bn',
    'bulgaristan'                                     => 'bg',
    'burkinafaso'                                     => 'bf',
    'burundi'                                         => 'bi',
    'butan'                                           => 'bt',
    'cantonandenderburyislands'                       => 'ct',
    'capeverde'                                       => 'cv',
    'caymanadaları'                                  => 'ky',
    'cebelitarık'                                    => 'gi',
    'ceutavemelilla'                                  => 'ea',
    'cezayir'                                         => 'dz',
    'christmasadası'                                 => 'cx',
    'cibuti'                                          => 'dj',
    'clippertonadası'                                => 'cp',
    'cocosadaları'                                   => 'cc',
    'cookadaları'                                    => 'ck',
    'czechoslovakia'                                  => 200,
    'danimarka'                                       => 'dk',
    'demokratikkongocumhuriyeti'                      => 'cd',
    'diegogarcia'                                     => 'dg',
    'dominika'                                        => 'dm',
    'dominikcumhuriyeti'                              => 'do',
    'doğuafrika'                                     => '014',
    'doğuasya'                                       => '030',
    'doğuavrupa'                                     => 151,
    'doğutimor'                                      => 'tl',
    'dronningmaudland'                                => 'nq',
    'dünya'                                          => '001',
    'eastgermany'                                     => 'dd',
    'ekvador'                                         => 'ec',
    'ekvatorginesi'                                   => 'gq',
    'elsalvador'                                      => 'sv',
    'endonezya'                                       => 'id',
    'eritre'                                          => 'er',
    'ermenistan'                                      => 'am',
    'estonya'                                         => 'ee',
    'etiyopya'                                        => 'et',
    'falklandadalarımalvinasadaları'                => 'fk',
    'faroeadaları'                                   => 'fo',
    'fas'                                             => 'ma',
    'fiji'                                            => 'fj',
    'fildişisahili'                                  => 'ci',
    'filipinler'                                      => 'ph',
    'filistinbölgesi'                                => 'ps',
    'finlandiya'                                      => 'fi',
    'fransa'                                          => 'fr',
    "fransa\,metropolitan"                            => 'fx',
    'fransızguyanası'                               => 'gf',
    'fransızgüneybölgeleri'                        => 'tf',
    'fransızpolinezyası'                            => 'pf',
    'frenchsouthernandantarcticterritories'           => 'fq',
    'gabon'                                           => 'ga',
    'gambiya'                                         => 'gm',
    'gana'                                            => 'gh',
    'gine'                                            => 'gn',
    'ginebissau'                                      => 'gw',
    'grenada'                                         => 'gd',
    'grönland'                                       => 'gl',
    'guadalupe'                                       => 'gp',
    'guam'                                            => 'gu',
    'guatemala'                                       => 'gt',
    'guernsey'                                        => 'gg',
    'guyana'                                          => 'gy',
    'güneyafrika'                                    => 'za',
    'güneyamerika'                                   => '005',
    'güneyasya'                                      => '034',
    'güneyavrupa'                                    => '039',
    'güneydoğuasya'                                 => '035',
    'güneygeorgiavegüneysandwichadaları'           => 'gs',
    'güneykore'                                      => 'kr',
    'güneykıbrısrumkesimi'                         => 'cy',
    'güneyortaasya'                                  => '062',
    'gürcistan'                                      => 'ge',
    'haiti'                                           => 'ht',
    'heardadasıvemcdonaldadaları'                   => 'hm',
    'hindistan'                                       => 'in',
    'hollanda'                                        => 'nl',
    'hollandaantilleri'                               => 'an',
    'honduras'                                        => 'hn',
    'hongkong'                                        => 'hk',
    'hırvatistan'                                    => 'hr',
    'irak'                                            => 'iq',
    'jamaika'                                         => 'jm',
    'japonya'                                         => 'jp',
    'jersey'                                          => 'je',
    'johnstonisland'                                  => 'jt',
    'kamboçya'                                       => 'kh',
    'kamerun'                                         => 'cm',
    'kanada'                                          => 'ca',
    'kanaladaları'                                   => 830,
    'kanaryaadaları'                                 => 'ic',
    'karadağ'                                        => 'me',
    'karayipler'                                      => '029',
    'katar'                                           => 'qa',
    'kazakistan'                                      => 'kz',
    'kenya'                                           => 'ke',
    'kiribati'                                        => 'ki',
    'kolombiya'                                       => 'co',
    'komorlar'                                        => 'km',
    'kongocumhuriyeti'                                => 'cg',
    'kostarika'                                       => 'cr',
    'kuveyt'                                          => 'kw',
    'kuzeyafrika'                                     => '015',
    'kuzeyamerika'                                    => '003',
    'kuzeyavrupa'                                     => 154,
    'kuzeykore'                                       => 'kp',
    'kuzeymarianaadaları'                            => 'mp',
    'küba'                                           => 'cu',
    'kırgızistan'                                   => 'kg',
    'laos'                                            => 'la',
    'latinamerika'                                    => 419,
    'lesoto'                                          => 'ls',
    'letonya'                                         => 'lv',
    'liberya'                                         => 'lr',
    'libya'                                           => 'ly',
    'liechtenstein'                                   => 'li',
    'litvanya'                                        => 'lt',
    'lübnan'                                         => 'lb',
    'lüksemburg'                                     => 'lu',
    'macaristan'                                      => 'hu',
    'madagaskar'                                      => 'mg',
    'makao'                                           => 'mo',
    'makedonyaeymc'                                   => 'mk',
    'malavi'                                          => 'mw',
    'maldivler'                                       => 'mv',
    'malezya'                                         => 'my',
    'mali'                                            => 'ml',
    'malta'                                           => 'mt',
    'manadası'                                       => 'im',
    'marshalladaları'                                => 'mh',
    'martinik'                                        => 'mq',
    'mauritius'                                       => 'mu',
    'mayotte'                                         => 'yt',
    'meksika'                                         => 'mx',
    'melanezya'                                       => '054',
    'midwayislands'                                   => 'mi',
    'mikronezya'                                      => '057',
    'mikronezyafederaleyaletleri'                     => 'fm',
    'moldova'                                         => 'md',
    'monako'                                          => 'mc',
    'montserrat'                                      => 'ms',
    'moritanya'                                       => 'mr',
    'mozambik'                                        => 'mz',
    'moğolistan'                                     => 'mn',
    'myanmar'                                         => 'mm',
    'mısır'                                         => 'eg',
    'namibya'                                         => 'na',
    'nauru'                                           => 'nr',
    'nepal'                                           => 'np',
    'neutralzone'                                     => 'nt',
    'nijer'                                           => 'ne',
    'nijerya'                                         => 'ng',
    'nikaragua'                                       => 'ni',
    'niue'                                            => 'nu',
    'norfolkadası'                                   => 'nf',
    'northvietnam'                                    => 'vd',
    'norveç'                                         => 'no',
    'okyanusya'                                       => '009',
    'ortaafrika'                                      => '017',
    'ortaafrikacumhuriyeti'                           => 'cf',
    'ortaamerika'                                     => '013',
    'ortaasya'                                        => 143,
    'pacificislandstrustterritory'                    => 'pc',
    'pakistan'                                        => 'pk',
    'palau'                                           => 'pw',
    'panama'                                          => 'pa',
    'panamacanalzone'                                 => 'pz',
    'papuayenigine'                                   => 'pg',
    'paraguay'                                        => 'py',
    "people\â\\sdemocraticrepublicofyemen"       => 'yd',
    'peru'                                            => 'pe',
    'pitcairn'                                        => 'pn',
    'polinezya'                                       => '061',
    'polonya'                                         => 'pl',
    'portekiz'                                        => 'pt',
    'portoriko'                                       => 'pr',
    'reunion'                                         => 're',
    'romanya'                                         => 'ro',
    'ruanda'                                          => 'rw',
    'rusya'                                           => 'ru',
    'saintbarthelemy'                                 => 'bl',
    'sainthelena'                                     => 'sh',
    'saintkittsvenevis'                               => 'kn',
    'saintlucia'                                      => 'lc',
    'saintmartin'                                     => 'mf',
    'saintpierrevemiquelon'                           => 'pm',
    'saintvincentvegrenadinler'                       => 'vc',
    'samoa'                                           => 'ws',
    'sanmarino'                                       => 'sm',
    'saotomeveprincipe'                               => 'st',
    'senegal'                                         => 'sn',
    'seyşeller'                                      => 'sc',
    'sierraleone'                                     => 'sl',
    'singapur'                                        => 'sg',
    'slovakya'                                        => 'sk',
    'slovenya'                                        => 'si',
    'solomonadaları'                                 => 'sb',
    'somali'                                          => 'so',
    'srilanka'                                        => 'lk',
    'sudan'                                           => 'sd',
    'surinam'                                         => 'sr',
    'suriye'                                          => 'sy',
    'suudiarabistan'                                  => 'sa',
    'svalbardvejanmayenadaları'                      => 'sj',
    'svaziland'                                       => 'sz',
    'sırbistan'                                      => 'rs',
    'sırbistankaradağ'                              => 'cs',
    'tacikistan'                                      => 'tj',
    'tanzanya'                                        => 'tz',
    'tayland'                                         => 'th',
    'tayvan'                                          => 'tw',
    'togo'                                            => 'tg',
    'tokelau'                                         => 'tk',
    'tonga'                                           => 'to',
    'trinidadvetobago'                                => 'tt',
    'tristandacunha'                                  => 'ta',
    'tunus'                                           => 'tn',
    'turksvecaicosadaları'                           => 'tc',
    'tuvalu'                                          => 'tv',
    'türkiye'                                        => 'tr',
    'türkmenistan'                                   => 'tm',
    "u\.s\.miscellaneouspacificislands"               => 'pu',
    'uganda'                                          => 'ug',
    'ukrayna'                                         => 'ua',
    'umman'                                           => 'om',
    'unionofsovietsocialistrepublics'                 => 'su',
    'uruguay'                                         => 'uy',
    'uzakokyanusya'                                   => 'qo',
    'vanuatu'                                         => 'vu',
    'vatikan'                                         => 'va',
    'venezuela'                                       => 've',
    'vietnam'                                         => 'vn',
    'wakeisland'                                      => 'wk',
    'wallisvefutunaadaları'                          => 'wf',
    'yemen'                                           => 'ye',
    'yenikaledonya'                                   => 'nc',
    'yenizelanda'                                     => 'nz',
    'yunanistan'                                      => 'gr',
    'zambiya'                                         => 'zm',
    'zimbabve'                                        => 'zw',
    'Çad'                                            => 'td',
    'Çekcumhuriyeti'                                 => 'cz',
    'Çin'                                            => 'cn',
    'Özbekistan'                                     => 'uz',
    'Ürdün'                                         => 'jo',
    'İngilizhintokyanusubölgesi'                    => 'io',
    'İngilizvirginadaları'                          => 'vg',
    'İran'                                           => 'ir',
    'İrlanda'                                        => 'ie',
    'İspanya'                                        => 'es',
    'İsrail'                                         => 'il',
    'İsveç'                                         => 'se',
    'İsviçre'                                       => 'ch',
    'İtalya'                                         => 'it',
    'İzlanda'                                        => 'is',
    'Şili'                                           => 'cl',
);

1;

