#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <math.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <netdb.h>

#define RINGLENGTH 720
#define HIGH_NN 35.0      // 35m over NN

int main(int argc, char **argv)
{
    struct sockaddr_in client1, server1;
    struct servent *serviceInfo;
    struct hostent *hostinfo;
    int s; // socket
    int i,j;
    int count=0;
    int count1=0;
    int res;
    char *buf;
    float erg,h;
    char zahl[6];
    char *hostname;
    double delta_p;
    if(argc==2){
	hostname=argv[1];
	}	
    else{
	fprintf(stderr,"usage mysocket with hostname\n");
	exit(1);
    }
    delta_p=pow((1.0-(6.5*HIGH_NN)/288000.0),5.255);
    fprintf(stderr,"%lf\n",delta_p);
    // socket
    if(serviceInfo = getservbyname("socktest","tcp"))
	client1.sin_port = serviceInfo->s_port;
    client1.sin_family = AF_INET;
    if(hostinfo = gethostbyname(hostname))
	memcpy((char*)&client1.sin_addr,hostinfo->h_addr,hostinfo->h_length);
    s = socket(AF_INET,SOCK_STREAM,0);
    if(s<0){
	fprintf(stderr,"Error in socket\n");
	exit(1);
    }
    if(connect(s,(struct sockaddr*)&client1,sizeof(client1))<0){
	fprintf(stderr,"Error in connect\n");
	exit(2);
    }
    // read buffer
    if((buf=malloc(RINGLENGTH*5))==NULL){
	fprintf(stderr,"error (sendpressure): no space on device\n");
	exit(1);
    }
    if((count=read(s,buf,5*RINGLENGTH))<0){
	fprintf(stderr,"error (read): %d\n",count);
	exit(1);
    }
    while(count<RINGLENGTH*5){
	if((count1=read(s,&buf[count],5*RINGLENGTH))<0){
	    fprintf(stderr,"error (read): %d\n",count1);
	    exit(1);
	}
	count+=count1;
    }
    fprintf(stderr,"count=%d\n",count);	
    count=0;
    // convert
    for(j=0; j<RINGLENGTH; j++){
        for(i=0; i<5; i++){
	    zahl[i]=buf[j*5+i];
        }
	zahl[5]='\0';
	res=atoi(zahl);
	if(res>0){
	   erg=(float)(res/10.0);
	   h=(float)(count/30.0);
	   printf("%f %6.1f\n",h,erg/delta_p);
           count++;
           }
	res=0;
    }
    close(s);
}
