/*
 * Copyright (C) 2025 Samuel Weinig <sam@webkit.org>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#include <WebCore/CSSValueConcepts.h>
#include <WebCore/CompositeOperation.h>
#include <WebCore/FontSizeAdjust.h>
#include <WebCore/GraphicsTypes.h>
#include <WebCore/PositionTryOrder.h>
#include <WebCore/RenderStyleConstants.h>
#include <WebCore/ScrollAxis.h>
#include <WebCore/ScrollTypes.h>
#include <WebCore/StyleAppearance.h>
#include <WebCore/TextFlags.h>
#include <WebCore/TextSpacing.h>
#include <WebCore/ThemeTypes.h>
#include <WebCore/UnicodeBidi.h>
#include <WebCore/WindRule.h>

#if HAVE(CORE_MATERIAL)
#include <WebCore/AppleVisualEffect.h>
#endif

// FIXME: Add specializations of ValueRepresentation for all enums listed in this file.

// Helper to define an enum that still needs a value representation conformance.
#define DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(t) \
    template<> inline constexpr auto EnumHasValueRepresentation<t> = false;

namespace WebCore {

DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(BorderStyle)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(BoxOrient)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(BreakBetween)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(CSSBoxType)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(CursorType)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(CompositeOperator)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(DisplayType)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(FillAttachment)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(FillBox)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(FillRepeat)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(FlexWrap)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(FontOpticalSizing)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(FontSizeAdjust::Metric)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(FontSmoothingMode)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(FontVariantCaps)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(FontVariantPosition)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(ImageRendering)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(Kerning)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(NinePieceImageRule)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(Overflow)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(PositionType)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(RubyPosition)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(ScrollSnapAxis)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(ScrollSnapAxisAlignType)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(ShapeRendering)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(StyleWritingMode)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(StyleAppearance)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(TextCombine)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(TextDirection)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(TextEmphasisMark)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(TextJustify)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(TextRenderingMode)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(TextWrapMode)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(TransformStyle3D)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(UnicodeBidi)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(UserSelect)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(WindRule)

#if HAVE(CORE_MATERIAL)
DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE(AppleVisualEffect)
#endif

} // namespace WebCore

#undef DEFINE_ENUM_NEEDS_VALUE_REPRESENTATION_CONFORMANCE
