# 2023-08-08 Triage Log

Overall a very positive week, primarily due to an [upgrade to LLVM
17](https://github.com/rust-lang/rust/pull/114048) and some changes to [lint
execution](https://github.com/rust-lang/rust/pull/113734). Memory usage is down
[4-7%](https://perf.rust-lang.org/?start=828bdc2c26f5c95773c4ecf72870919f16417b66&end=443c3161dd04f4c1b656a626f9079921bee9c326&absolute=false&stat=max-rss&kind=percentfromfirst)
over the last week and wall times are down
[3-5%](https://perf.rust-lang.org/?start=828bdc2c26f5c95773c4ecf72870919f16417b66&end=443c3161dd04f4c1b656a626f9079921bee9c326&absolute=false&stat=wall-time&kind=percentfromfirst).

Triage done by **@simulacrum**.
Revision range: [828bdc2c26f5c95773c4ecf72870919f16417b66..443c3161dd04f4c1b656a626f9079921bee9c326](https://perf.rust-lang.org/?start=828bdc2c26f5c95773c4ecf72870919f16417b66&end=443c3161dd04f4c1b656a626f9079921bee9c326&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -               | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -               | 0     |
| Improvements ✅ <br /> (primary)   | -3.1% | [-7.1%, -1.2%]  | 253   |
| Improvements ✅ <br /> (secondary) | -4.1% | [-28.4%, -0.3%] | 233   |
| All ❌✅ (primary)                 | -3.1% | [-7.1%, -1.2%]  | 253   |


2 Regressions, 7 Improvements, 2 Mixed; 2 of them in rollups
64 artifact comparisons made in total

#### Regressions

Rollup of 9 pull requests [#114481](https://github.com/rust-lang/rust/pull/114481) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=fe896efa974ea759b10b9754234ae61e9cab28b3&end=e4c14468460b22ac7a289a422fb7fee606e12a0b&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.8% | [0.4%, 1.5%] | 80    |
| Regressions ❌ <br /> (secondary)  | 0.7% | [0.2%, 1.2%] | 25    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.8% | [0.4%, 1.5%] | 80    |

Unclear what is causing this regression. It's entirely limited to the
incr-patched and incr-unchanged scenarios, and digging into one of the
benchmarks (bitmaps-3.1.0 check incr-unchanged) seems to show a mix of noise
and, in aggregate, significant improvements over the last several days. Not
clear which PR in this rollup could have caused this change in behavior.

See [these comments](https://github.com/rust-lang/rust/pull/114481#issuecomment-1666438972) for some more details.

Re-enable atomic loads and stores for all RISC-V targets [#98333](https://github.com/rust-lang/rust/pull/98333) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e173a8e6634d787a1529ff6ec5dc63273425ca34&end=90f0b24ad3e7fc0dc0e419c9da30d74629cd5736&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.8% | [0.4%, 1.3%] | 18    |
| Regressions ❌ <br /> (secondary)  | 0.6% | [0.2%, 0.9%] | 12    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.8% | [0.4%, 1.3%] | 18    |

This PR has a very similar regression profile to the previous rollup in this list (#114481).

#### Improvements

Remove `constness` from `TraitPredicate` [#114202](https://github.com/rust-lang/rust/pull/114202) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=7637653b9fdd2b2f2dc3b378891eb5cf6aea9f5d&end=20747af8940cf683970e76ec9a433305940c05f3&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.7% | [-0.9%, -0.4%] | 16    |
| Improvements ✅ <br /> (secondary) | -0.6% | [-1.2%, -0.3%] | 13    |
| All ❌✅ (primary)                 | -0.7% | [-0.9%, -0.4%] | 16    |

cg_llvm: stop identifying ADTs in LLVM IR [#114350](https://github.com/rust-lang/rust/pull/114350) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=098c1db7e55e7229a520a2ec8e460e1e300e109b&end=73dc6f03a2a8c0e8b8b25fb97d7f4805995ce0b9&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.8% | [-1.2%, -0.6%] | 5     |
| Improvements ✅ <br /> (secondary) | -1.1% | [-1.5%, -0.6%] | 6     |
| All ❌✅ (primary)                 | -0.8% | [-1.2%, -0.6%] | 5     |

Convert builtin "global" late lints to run per module [#113734](https://github.com/rust-lang/rust/pull/113734) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=fca59ab5f0e7df7d816bed77a32abc0045ebe80b&end=67626b8e89ff57269f1d67cb9bc037088c058b42&stat=instructions:u)

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -               | 0     |
| Regressions ❌ <br /> (secondary)  | 0.5%  | [0.4%, 0.8%]    | 3     |
| Improvements ✅ <br /> (primary)   | -1.7% | [-3.4%, -0.2%]  | 88    |
| Improvements ✅ <br /> (secondary) | -4.2% | [-26.5%, -0.2%] | 85    |
| All ❌✅ (primary)                 | -1.7% | [-3.4%, -0.2%]  | 88    |

parent_module_from_def_id does not need to be a query. [#114516](https://github.com/rust-lang/rust/pull/114516) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e59540968e0c6fc3c37d92a639b83fc8fcee5e81&end=5973bfbd38fcefb63090a588733931e933498dfd&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.2%, 0.4%]   | 2     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -1.4% | [-2.0%, -1.1%] | 17    |
| Improvements ✅ <br /> (secondary) | -1.2% | [-1.5%, -0.3%] | 11    |
| All ❌✅ (primary)                 | -1.2% | [-2.0%, 0.4%]  | 19    |

Steal MIR for CTFE when possible. [#114502](https://github.com/rust-lang/rust/pull/114502) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=85fbb571497d13cfb828de9b0d3e78656b9203c1&end=f3623871cfa0763c95ebd6ceafaa6dc2e44ca68f&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.6% | [-0.6%, -0.6%] | 1     |
| Improvements ✅ <br /> (secondary) | -1.5% | [-2.6%, -0.5%] | 19    |
| All ❌✅ (primary)                 | -0.6% | [-0.6%, -0.6%] | 1     |

Update to LLVM 17 [#114048](https://github.com/rust-lang/rust/pull/114048) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=03a119b0b0e310d22d94399b24ed030056050f13&end=443c3161dd04f4c1b656a626f9079921bee9c326&stat=instructions:u)

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -               | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -               | 0     |
| Improvements ✅ <br /> (primary)   | -2.2% | [-5.6%, -0.8%]  | 173   |
| Improvements ✅ <br /> (secondary) | -2.2% | [-12.9%, -0.5%] | 199   |
| All ❌✅ (primary)                 | -2.2% | [-5.6%, -0.8%]  | 173   |

This represents a large win across multiple benchmarks. Unfortunately it also
regresses artifact sizes for libLLVM.so by 50MB. Investigation into why is
[ongoing](https://github.com/rust-lang/rust/pull/114048#issuecomment-1669252031).

Do not run ConstProp on mir_for_ctfe. [#114459](https://github.com/rust-lang/rust/pull/114459) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=67626b8e89ff57269f1d67cb9bc037088c058b42&end=1cabb8ed2301faf193132e71ca5b10f82913e48a&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.2%, 0.2%]   | 1     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.8% | [-1.2%, -0.5%] | 8     |
| Improvements ✅ <br /> (secondary) | -1.7% | [-3.0%, -1.1%] | 7     |
| All ❌✅ (primary)                 | -0.7% | [-1.2%, 0.2%]  | 9     |

The one regression is actually within noise floor for the relevant benchmark.

#### Mixed

Optimize `Iterator` implementation for `&mut impl Iterator + Sized` [#111200](https://github.com/rust-lang/rust/pull/111200) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=9565b68b741fd0466b3af075139e819e7d73ee38&end=eb088b8b9d98f1af1b0e61bbdcd8686e1b0db7b6&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.3%, 0.5%]   | 6     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.7% | [-0.9%, -0.5%] | 2     |
| All ❌✅ (primary)                 | 0.4%  | [0.3%, 0.5%]   | 6     |

Rollup of 7 pull requests [#114604](https://github.com/rust-lang/rust/pull/114604) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=443c3161dd04f4c1b656a626f9079921bee9c326&end=8e7fd551311d424e4e63fa45906a2a928fce96a7&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.4%  | [0.4%, 2.0%]   | 3     |
| Regressions ❌ <br /> (secondary)  | 1.2%  | [1.1%, 1.3%]   | 6     |
| Improvements ✅ <br /> (primary)   | -0.7% | [-0.9%, -0.4%] | 2     |
| Improvements ✅ <br /> (secondary) | -1.0% | [-1.5%, -0.5%] | 2     |
| All ❌✅ (primary)                 | 0.5%  | [-0.9%, 2.0%]  | 5     |

Investigation into cause is [ongoing](https://github.com/rust-lang/rust/pull/114604#issuecomment-1669350724).
