/*
 * NetHSM
 *
 * All endpoints expect exactly the specified JSON. Additional properties will cause a Bad Request Error (400). All HTTP errors contain a JSON structure with an explanation of type string. All [base64](https://tools.ietf.org/html/rfc4648#section-4) encoded values are Big Endian.
 *
 * The version of the OpenAPI document: v1
 * Contact: Nitrokey <info@nitrokey.com>
 * Generated by: https://openapi-generator.tech
 */

#[derive(Clone, Debug, PartialEq, Serialize, Deserialize)]
#[non_exhaustive]
pub struct SystemInfo {
    #[serde(rename = "softwareVersion")]
    pub software_version: String,
    #[serde(rename = "softwareBuild")]
    pub software_build: String,
    #[serde(rename = "firmwareVersion")]
    pub firmware_version: String,
    #[serde(rename = "hardwareVersion")]
    pub hardware_version: String,
    #[serde(rename = "deviceId")]
    pub device_id: String,
    #[serde(rename = "akPub")]
    pub ak_pub: Box<crate::models::AkPub>,
    #[serde(rename = "pcr")]
    pub pcr: Box<crate::models::Pcr>,
}

impl SystemInfo {
    pub fn new(
        software_version: String,
        software_build: String,
        firmware_version: String,
        hardware_version: String,
        device_id: String,
        ak_pub: crate::models::AkPub,
        pcr: crate::models::Pcr,
    ) -> SystemInfo {
        SystemInfo {
            software_version,
            software_build,
            firmware_version,
            hardware_version,
            device_id,
            ak_pub: Box::new(ak_pub),
            pcr: Box::new(pcr),
        }
    }
}
