use super::Isotope;

#[cfg(feature = "ranges")]
/// Range from the minimum to the maximum mass number across all isotopes
///
/// Convenience constant to avoid writing the code below when this range is needed:
///
/// ```
/// use mendeleev::{Isotope, ISOTOPE_MASS_NUMBER_RANGE};
/// let all_values = Isotope::iter().map(|e| e.mass_number());
/// let min = all_values.clone().min().unwrap();
/// let max = all_values.max().unwrap();
/// assert_eq!(min..=max, ISOTOPE_MASS_NUMBER_RANGE);
/// ```
pub const ISOTOPE_MASS_NUMBER_RANGE: core::ops::RangeInclusive<u32> = 1..=295;

impl Isotope {
    /// Returns the isotope's mass number, i.e., the sum
    /// of the number of protons and neutrons in its nucleus
    ///
    /// ```
    /// use mendeleev::Isotope;
    /// assert_eq!(Isotope::H1.mass_number(), 1);
    /// assert_eq!(Isotope::Og295.mass_number(), 295);
    /// ```
    pub const fn mass_number(&self) -> u32 {
        match self {
            Isotope::H1 => 1,
            Isotope::H2 => 2,
            Isotope::H3 => 3,
            Isotope::H4 => 4,
            Isotope::H5 => 5,
            Isotope::H6 => 6,
            Isotope::H7 => 7,
            Isotope::He3 => 3,
            Isotope::He4 => 4,
            Isotope::He5 => 5,
            Isotope::He6 => 6,
            Isotope::He7 => 7,
            Isotope::He8 => 8,
            Isotope::He9 => 9,
            Isotope::He10 => 10,
            Isotope::Li3 => 3,
            Isotope::Li4 => 4,
            Isotope::Li5 => 5,
            Isotope::Li6 => 6,
            Isotope::Li7 => 7,
            Isotope::Li8 => 8,
            Isotope::Li9 => 9,
            Isotope::Li10 => 10,
            Isotope::Li11 => 11,
            Isotope::Li12 => 12,
            Isotope::Li13 => 13,
            Isotope::Be5 => 5,
            Isotope::Be6 => 6,
            Isotope::Be7 => 7,
            Isotope::Be8 => 8,
            Isotope::Be9 => 9,
            Isotope::Be10 => 10,
            Isotope::Be11 => 11,
            Isotope::Be12 => 12,
            Isotope::Be13 => 13,
            Isotope::Be14 => 14,
            Isotope::Be15 => 15,
            Isotope::Be16 => 16,
            Isotope::B6 => 6,
            Isotope::B7 => 7,
            Isotope::B8 => 8,
            Isotope::B9 => 9,
            Isotope::B10 => 10,
            Isotope::B11 => 11,
            Isotope::B12 => 12,
            Isotope::B13 => 13,
            Isotope::B14 => 14,
            Isotope::B15 => 15,
            Isotope::B16 => 16,
            Isotope::B17 => 17,
            Isotope::B18 => 18,
            Isotope::B19 => 19,
            Isotope::B20 => 20,
            Isotope::B21 => 21,
            Isotope::C8 => 8,
            Isotope::C9 => 9,
            Isotope::C10 => 10,
            Isotope::C11 => 11,
            Isotope::C12 => 12,
            Isotope::C13 => 13,
            Isotope::C14 => 14,
            Isotope::C15 => 15,
            Isotope::C16 => 16,
            Isotope::C17 => 17,
            Isotope::C18 => 18,
            Isotope::C19 => 19,
            Isotope::C20 => 20,
            Isotope::C21 => 21,
            Isotope::C22 => 22,
            Isotope::C23 => 23,
            Isotope::N10 => 10,
            Isotope::N11 => 11,
            Isotope::N12 => 12,
            Isotope::N13 => 13,
            Isotope::N14 => 14,
            Isotope::N15 => 15,
            Isotope::N16 => 16,
            Isotope::N17 => 17,
            Isotope::N18 => 18,
            Isotope::N19 => 19,
            Isotope::N20 => 20,
            Isotope::N21 => 21,
            Isotope::N22 => 22,
            Isotope::N23 => 23,
            Isotope::N24 => 24,
            Isotope::N25 => 25,
            Isotope::O11 => 11,
            Isotope::O12 => 12,
            Isotope::O13 => 13,
            Isotope::O14 => 14,
            Isotope::O15 => 15,
            Isotope::O16 => 16,
            Isotope::O17 => 17,
            Isotope::O18 => 18,
            Isotope::O19 => 19,
            Isotope::O20 => 20,
            Isotope::O21 => 21,
            Isotope::O22 => 22,
            Isotope::O23 => 23,
            Isotope::O24 => 24,
            Isotope::O25 => 25,
            Isotope::O26 => 26,
            Isotope::O27 => 27,
            Isotope::O28 => 28,
            Isotope::F13 => 13,
            Isotope::F14 => 14,
            Isotope::F15 => 15,
            Isotope::F16 => 16,
            Isotope::F17 => 17,
            Isotope::F18 => 18,
            Isotope::F19 => 19,
            Isotope::F20 => 20,
            Isotope::F21 => 21,
            Isotope::F22 => 22,
            Isotope::F23 => 23,
            Isotope::F24 => 24,
            Isotope::F25 => 25,
            Isotope::F26 => 26,
            Isotope::F27 => 27,
            Isotope::F28 => 28,
            Isotope::F29 => 29,
            Isotope::F30 => 30,
            Isotope::F31 => 31,
            Isotope::Ne15 => 15,
            Isotope::Ne16 => 16,
            Isotope::Ne17 => 17,
            Isotope::Ne18 => 18,
            Isotope::Ne19 => 19,
            Isotope::Ne20 => 20,
            Isotope::Ne21 => 21,
            Isotope::Ne22 => 22,
            Isotope::Ne23 => 23,
            Isotope::Ne24 => 24,
            Isotope::Ne25 => 25,
            Isotope::Ne26 => 26,
            Isotope::Ne27 => 27,
            Isotope::Ne28 => 28,
            Isotope::Ne29 => 29,
            Isotope::Ne30 => 30,
            Isotope::Ne31 => 31,
            Isotope::Ne32 => 32,
            Isotope::Ne33 => 33,
            Isotope::Ne34 => 34,
            Isotope::Na17 => 17,
            Isotope::Na18 => 18,
            Isotope::Na19 => 19,
            Isotope::Na20 => 20,
            Isotope::Na21 => 21,
            Isotope::Na22 => 22,
            Isotope::Na23 => 23,
            Isotope::Na24 => 24,
            Isotope::Na25 => 25,
            Isotope::Na26 => 26,
            Isotope::Na27 => 27,
            Isotope::Na28 => 28,
            Isotope::Na29 => 29,
            Isotope::Na30 => 30,
            Isotope::Na31 => 31,
            Isotope::Na32 => 32,
            Isotope::Na33 => 33,
            Isotope::Na34 => 34,
            Isotope::Na35 => 35,
            Isotope::Na36 => 36,
            Isotope::Na37 => 37,
            Isotope::Na38 => 38,
            Isotope::Na39 => 39,
            Isotope::Mg19 => 19,
            Isotope::Mg20 => 20,
            Isotope::Mg21 => 21,
            Isotope::Mg22 => 22,
            Isotope::Mg23 => 23,
            Isotope::Mg24 => 24,
            Isotope::Mg25 => 25,
            Isotope::Mg26 => 26,
            Isotope::Mg27 => 27,
            Isotope::Mg28 => 28,
            Isotope::Mg29 => 29,
            Isotope::Mg30 => 30,
            Isotope::Mg31 => 31,
            Isotope::Mg32 => 32,
            Isotope::Mg33 => 33,
            Isotope::Mg34 => 34,
            Isotope::Mg35 => 35,
            Isotope::Mg36 => 36,
            Isotope::Mg37 => 37,
            Isotope::Mg38 => 38,
            Isotope::Mg39 => 39,
            Isotope::Mg40 => 40,
            Isotope::Mg41 => 41,
            Isotope::Al21 => 21,
            Isotope::Al22 => 22,
            Isotope::Al23 => 23,
            Isotope::Al24 => 24,
            Isotope::Al25 => 25,
            Isotope::Al26 => 26,
            Isotope::Al27 => 27,
            Isotope::Al28 => 28,
            Isotope::Al29 => 29,
            Isotope::Al30 => 30,
            Isotope::Al31 => 31,
            Isotope::Al32 => 32,
            Isotope::Al33 => 33,
            Isotope::Al34 => 34,
            Isotope::Al35 => 35,
            Isotope::Al36 => 36,
            Isotope::Al37 => 37,
            Isotope::Al38 => 38,
            Isotope::Al39 => 39,
            Isotope::Al40 => 40,
            Isotope::Al41 => 41,
            Isotope::Al42 => 42,
            Isotope::Al43 => 43,
            Isotope::Si22 => 22,
            Isotope::Si23 => 23,
            Isotope::Si24 => 24,
            Isotope::Si25 => 25,
            Isotope::Si26 => 26,
            Isotope::Si27 => 27,
            Isotope::Si28 => 28,
            Isotope::Si29 => 29,
            Isotope::Si30 => 30,
            Isotope::Si31 => 31,
            Isotope::Si32 => 32,
            Isotope::Si33 => 33,
            Isotope::Si34 => 34,
            Isotope::Si35 => 35,
            Isotope::Si36 => 36,
            Isotope::Si37 => 37,
            Isotope::Si38 => 38,
            Isotope::Si39 => 39,
            Isotope::Si40 => 40,
            Isotope::Si41 => 41,
            Isotope::Si42 => 42,
            Isotope::Si43 => 43,
            Isotope::Si44 => 44,
            Isotope::Si45 => 45,
            Isotope::P24 => 24,
            Isotope::P25 => 25,
            Isotope::P26 => 26,
            Isotope::P27 => 27,
            Isotope::P28 => 28,
            Isotope::P29 => 29,
            Isotope::P30 => 30,
            Isotope::P31 => 31,
            Isotope::P32 => 32,
            Isotope::P33 => 33,
            Isotope::P34 => 34,
            Isotope::P35 => 35,
            Isotope::P36 => 36,
            Isotope::P37 => 37,
            Isotope::P38 => 38,
            Isotope::P39 => 39,
            Isotope::P40 => 40,
            Isotope::P41 => 41,
            Isotope::P42 => 42,
            Isotope::P43 => 43,
            Isotope::P44 => 44,
            Isotope::P45 => 45,
            Isotope::P46 => 46,
            Isotope::P47 => 47,
            Isotope::S26 => 26,
            Isotope::S27 => 27,
            Isotope::S28 => 28,
            Isotope::S29 => 29,
            Isotope::S30 => 30,
            Isotope::S31 => 31,
            Isotope::S32 => 32,
            Isotope::S33 => 33,
            Isotope::S34 => 34,
            Isotope::S35 => 35,
            Isotope::S36 => 36,
            Isotope::S37 => 37,
            Isotope::S38 => 38,
            Isotope::S39 => 39,
            Isotope::S40 => 40,
            Isotope::S41 => 41,
            Isotope::S42 => 42,
            Isotope::S43 => 43,
            Isotope::S44 => 44,
            Isotope::S45 => 45,
            Isotope::S46 => 46,
            Isotope::S47 => 47,
            Isotope::S48 => 48,
            Isotope::S49 => 49,
            Isotope::Cl28 => 28,
            Isotope::Cl29 => 29,
            Isotope::Cl30 => 30,
            Isotope::Cl31 => 31,
            Isotope::Cl32 => 32,
            Isotope::Cl33 => 33,
            Isotope::Cl34 => 34,
            Isotope::Cl35 => 35,
            Isotope::Cl36 => 36,
            Isotope::Cl37 => 37,
            Isotope::Cl38 => 38,
            Isotope::Cl39 => 39,
            Isotope::Cl40 => 40,
            Isotope::Cl41 => 41,
            Isotope::Cl42 => 42,
            Isotope::Cl43 => 43,
            Isotope::Cl44 => 44,
            Isotope::Cl45 => 45,
            Isotope::Cl46 => 46,
            Isotope::Cl47 => 47,
            Isotope::Cl48 => 48,
            Isotope::Cl49 => 49,
            Isotope::Cl50 => 50,
            Isotope::Cl51 => 51,
            Isotope::Cl52 => 52,
            Isotope::Ar29 => 29,
            Isotope::Ar30 => 30,
            Isotope::Ar31 => 31,
            Isotope::Ar32 => 32,
            Isotope::Ar33 => 33,
            Isotope::Ar34 => 34,
            Isotope::Ar35 => 35,
            Isotope::Ar36 => 36,
            Isotope::Ar37 => 37,
            Isotope::Ar38 => 38,
            Isotope::Ar39 => 39,
            Isotope::Ar40 => 40,
            Isotope::Ar41 => 41,
            Isotope::Ar42 => 42,
            Isotope::Ar43 => 43,
            Isotope::Ar44 => 44,
            Isotope::Ar45 => 45,
            Isotope::Ar46 => 46,
            Isotope::Ar47 => 47,
            Isotope::Ar48 => 48,
            Isotope::Ar49 => 49,
            Isotope::Ar50 => 50,
            Isotope::Ar51 => 51,
            Isotope::Ar52 => 52,
            Isotope::Ar53 => 53,
            Isotope::Ar54 => 54,
            Isotope::K31 => 31,
            Isotope::K32 => 32,
            Isotope::K33 => 33,
            Isotope::K34 => 34,
            Isotope::K35 => 35,
            Isotope::K36 => 36,
            Isotope::K37 => 37,
            Isotope::K38 => 38,
            Isotope::K39 => 39,
            Isotope::K40 => 40,
            Isotope::K41 => 41,
            Isotope::K42 => 42,
            Isotope::K43 => 43,
            Isotope::K44 => 44,
            Isotope::K45 => 45,
            Isotope::K46 => 46,
            Isotope::K47 => 47,
            Isotope::K48 => 48,
            Isotope::K49 => 49,
            Isotope::K50 => 50,
            Isotope::K51 => 51,
            Isotope::K52 => 52,
            Isotope::K53 => 53,
            Isotope::K54 => 54,
            Isotope::K55 => 55,
            Isotope::K56 => 56,
            Isotope::K57 => 57,
            Isotope::K58 => 58,
            Isotope::K59 => 59,
            Isotope::Ca33 => 33,
            Isotope::Ca34 => 34,
            Isotope::Ca35 => 35,
            Isotope::Ca36 => 36,
            Isotope::Ca37 => 37,
            Isotope::Ca38 => 38,
            Isotope::Ca39 => 39,
            Isotope::Ca40 => 40,
            Isotope::Ca41 => 41,
            Isotope::Ca42 => 42,
            Isotope::Ca43 => 43,
            Isotope::Ca44 => 44,
            Isotope::Ca45 => 45,
            Isotope::Ca46 => 46,
            Isotope::Ca47 => 47,
            Isotope::Ca48 => 48,
            Isotope::Ca49 => 49,
            Isotope::Ca50 => 50,
            Isotope::Ca51 => 51,
            Isotope::Ca52 => 52,
            Isotope::Ca53 => 53,
            Isotope::Ca54 => 54,
            Isotope::Ca55 => 55,
            Isotope::Ca56 => 56,
            Isotope::Ca57 => 57,
            Isotope::Ca58 => 58,
            Isotope::Ca59 => 59,
            Isotope::Ca60 => 60,
            Isotope::Ca61 => 61,
            Isotope::Sc35 => 35,
            Isotope::Sc36 => 36,
            Isotope::Sc37 => 37,
            Isotope::Sc38 => 38,
            Isotope::Sc39 => 39,
            Isotope::Sc40 => 40,
            Isotope::Sc41 => 41,
            Isotope::Sc42 => 42,
            Isotope::Sc43 => 43,
            Isotope::Sc44 => 44,
            Isotope::Sc45 => 45,
            Isotope::Sc46 => 46,
            Isotope::Sc47 => 47,
            Isotope::Sc48 => 48,
            Isotope::Sc49 => 49,
            Isotope::Sc50 => 50,
            Isotope::Sc51 => 51,
            Isotope::Sc52 => 52,
            Isotope::Sc53 => 53,
            Isotope::Sc54 => 54,
            Isotope::Sc55 => 55,
            Isotope::Sc56 => 56,
            Isotope::Sc57 => 57,
            Isotope::Sc58 => 58,
            Isotope::Sc59 => 59,
            Isotope::Sc60 => 60,
            Isotope::Sc61 => 61,
            Isotope::Sc62 => 62,
            Isotope::Sc63 => 63,
            Isotope::Ti37 => 37,
            Isotope::Ti38 => 38,
            Isotope::Ti39 => 39,
            Isotope::Ti40 => 40,
            Isotope::Ti41 => 41,
            Isotope::Ti42 => 42,
            Isotope::Ti43 => 43,
            Isotope::Ti44 => 44,
            Isotope::Ti45 => 45,
            Isotope::Ti46 => 46,
            Isotope::Ti47 => 47,
            Isotope::Ti48 => 48,
            Isotope::Ti49 => 49,
            Isotope::Ti50 => 50,
            Isotope::Ti51 => 51,
            Isotope::Ti52 => 52,
            Isotope::Ti53 => 53,
            Isotope::Ti54 => 54,
            Isotope::Ti55 => 55,
            Isotope::Ti56 => 56,
            Isotope::Ti57 => 57,
            Isotope::Ti58 => 58,
            Isotope::Ti59 => 59,
            Isotope::Ti60 => 60,
            Isotope::Ti61 => 61,
            Isotope::Ti62 => 62,
            Isotope::Ti63 => 63,
            Isotope::Ti64 => 64,
            Isotope::Ti65 => 65,
            Isotope::V39 => 39,
            Isotope::V40 => 40,
            Isotope::V41 => 41,
            Isotope::V42 => 42,
            Isotope::V43 => 43,
            Isotope::V44 => 44,
            Isotope::V45 => 45,
            Isotope::V46 => 46,
            Isotope::V47 => 47,
            Isotope::V48 => 48,
            Isotope::V49 => 49,
            Isotope::V50 => 50,
            Isotope::V51 => 51,
            Isotope::V52 => 52,
            Isotope::V53 => 53,
            Isotope::V54 => 54,
            Isotope::V55 => 55,
            Isotope::V56 => 56,
            Isotope::V57 => 57,
            Isotope::V58 => 58,
            Isotope::V59 => 59,
            Isotope::V60 => 60,
            Isotope::V61 => 61,
            Isotope::V62 => 62,
            Isotope::V63 => 63,
            Isotope::V64 => 64,
            Isotope::V65 => 65,
            Isotope::V66 => 66,
            Isotope::V67 => 67,
            Isotope::Cr41 => 41,
            Isotope::Cr42 => 42,
            Isotope::Cr43 => 43,
            Isotope::Cr44 => 44,
            Isotope::Cr45 => 45,
            Isotope::Cr46 => 46,
            Isotope::Cr47 => 47,
            Isotope::Cr48 => 48,
            Isotope::Cr49 => 49,
            Isotope::Cr50 => 50,
            Isotope::Cr51 => 51,
            Isotope::Cr52 => 52,
            Isotope::Cr53 => 53,
            Isotope::Cr54 => 54,
            Isotope::Cr55 => 55,
            Isotope::Cr56 => 56,
            Isotope::Cr57 => 57,
            Isotope::Cr58 => 58,
            Isotope::Cr59 => 59,
            Isotope::Cr60 => 60,
            Isotope::Cr61 => 61,
            Isotope::Cr62 => 62,
            Isotope::Cr63 => 63,
            Isotope::Cr64 => 64,
            Isotope::Cr65 => 65,
            Isotope::Cr66 => 66,
            Isotope::Cr67 => 67,
            Isotope::Cr68 => 68,
            Isotope::Cr69 => 69,
            Isotope::Cr70 => 70,
            Isotope::Mn43 => 43,
            Isotope::Mn44 => 44,
            Isotope::Mn45 => 45,
            Isotope::Mn46 => 46,
            Isotope::Mn47 => 47,
            Isotope::Mn48 => 48,
            Isotope::Mn49 => 49,
            Isotope::Mn50 => 50,
            Isotope::Mn51 => 51,
            Isotope::Mn52 => 52,
            Isotope::Mn53 => 53,
            Isotope::Mn54 => 54,
            Isotope::Mn55 => 55,
            Isotope::Mn56 => 56,
            Isotope::Mn57 => 57,
            Isotope::Mn58 => 58,
            Isotope::Mn59 => 59,
            Isotope::Mn60 => 60,
            Isotope::Mn61 => 61,
            Isotope::Mn62 => 62,
            Isotope::Mn63 => 63,
            Isotope::Mn64 => 64,
            Isotope::Mn65 => 65,
            Isotope::Mn66 => 66,
            Isotope::Mn67 => 67,
            Isotope::Mn68 => 68,
            Isotope::Mn69 => 69,
            Isotope::Mn70 => 70,
            Isotope::Mn71 => 71,
            Isotope::Mn72 => 72,
            Isotope::Mn73 => 73,
            Isotope::Fe45 => 45,
            Isotope::Fe46 => 46,
            Isotope::Fe47 => 47,
            Isotope::Fe48 => 48,
            Isotope::Fe49 => 49,
            Isotope::Fe50 => 50,
            Isotope::Fe51 => 51,
            Isotope::Fe52 => 52,
            Isotope::Fe53 => 53,
            Isotope::Fe54 => 54,
            Isotope::Fe55 => 55,
            Isotope::Fe56 => 56,
            Isotope::Fe57 => 57,
            Isotope::Fe58 => 58,
            Isotope::Fe59 => 59,
            Isotope::Fe60 => 60,
            Isotope::Fe61 => 61,
            Isotope::Fe62 => 62,
            Isotope::Fe63 => 63,
            Isotope::Fe64 => 64,
            Isotope::Fe65 => 65,
            Isotope::Fe66 => 66,
            Isotope::Fe67 => 67,
            Isotope::Fe68 => 68,
            Isotope::Fe69 => 69,
            Isotope::Fe70 => 70,
            Isotope::Fe71 => 71,
            Isotope::Fe72 => 72,
            Isotope::Fe73 => 73,
            Isotope::Fe74 => 74,
            Isotope::Fe75 => 75,
            Isotope::Fe76 => 76,
            Isotope::Co47 => 47,
            Isotope::Co48 => 48,
            Isotope::Co49 => 49,
            Isotope::Co50 => 50,
            Isotope::Co51 => 51,
            Isotope::Co52 => 52,
            Isotope::Co53 => 53,
            Isotope::Co54 => 54,
            Isotope::Co55 => 55,
            Isotope::Co56 => 56,
            Isotope::Co57 => 57,
            Isotope::Co58 => 58,
            Isotope::Co59 => 59,
            Isotope::Co60 => 60,
            Isotope::Co61 => 61,
            Isotope::Co62 => 62,
            Isotope::Co63 => 63,
            Isotope::Co64 => 64,
            Isotope::Co65 => 65,
            Isotope::Co66 => 66,
            Isotope::Co67 => 67,
            Isotope::Co68 => 68,
            Isotope::Co69 => 69,
            Isotope::Co70 => 70,
            Isotope::Co71 => 71,
            Isotope::Co72 => 72,
            Isotope::Co73 => 73,
            Isotope::Co74 => 74,
            Isotope::Co75 => 75,
            Isotope::Co76 => 76,
            Isotope::Co77 => 77,
            Isotope::Co78 => 78,
            Isotope::Ni48 => 48,
            Isotope::Ni49 => 49,
            Isotope::Ni50 => 50,
            Isotope::Ni51 => 51,
            Isotope::Ni52 => 52,
            Isotope::Ni53 => 53,
            Isotope::Ni54 => 54,
            Isotope::Ni55 => 55,
            Isotope::Ni56 => 56,
            Isotope::Ni57 => 57,
            Isotope::Ni58 => 58,
            Isotope::Ni59 => 59,
            Isotope::Ni60 => 60,
            Isotope::Ni61 => 61,
            Isotope::Ni62 => 62,
            Isotope::Ni63 => 63,
            Isotope::Ni64 => 64,
            Isotope::Ni65 => 65,
            Isotope::Ni66 => 66,
            Isotope::Ni67 => 67,
            Isotope::Ni68 => 68,
            Isotope::Ni69 => 69,
            Isotope::Ni70 => 70,
            Isotope::Ni71 => 71,
            Isotope::Ni72 => 72,
            Isotope::Ni73 => 73,
            Isotope::Ni74 => 74,
            Isotope::Ni75 => 75,
            Isotope::Ni76 => 76,
            Isotope::Ni77 => 77,
            Isotope::Ni78 => 78,
            Isotope::Ni79 => 79,
            Isotope::Ni80 => 80,
            Isotope::Ni81 => 81,
            Isotope::Ni82 => 82,
            Isotope::Cu52 => 52,
            Isotope::Cu53 => 53,
            Isotope::Cu54 => 54,
            Isotope::Cu55 => 55,
            Isotope::Cu56 => 56,
            Isotope::Cu57 => 57,
            Isotope::Cu58 => 58,
            Isotope::Cu59 => 59,
            Isotope::Cu60 => 60,
            Isotope::Cu61 => 61,
            Isotope::Cu62 => 62,
            Isotope::Cu63 => 63,
            Isotope::Cu64 => 64,
            Isotope::Cu65 => 65,
            Isotope::Cu66 => 66,
            Isotope::Cu67 => 67,
            Isotope::Cu68 => 68,
            Isotope::Cu69 => 69,
            Isotope::Cu70 => 70,
            Isotope::Cu71 => 71,
            Isotope::Cu72 => 72,
            Isotope::Cu73 => 73,
            Isotope::Cu74 => 74,
            Isotope::Cu75 => 75,
            Isotope::Cu76 => 76,
            Isotope::Cu77 => 77,
            Isotope::Cu78 => 78,
            Isotope::Cu79 => 79,
            Isotope::Cu80 => 80,
            Isotope::Cu81 => 81,
            Isotope::Cu82 => 82,
            Isotope::Cu83 => 83,
            Isotope::Cu84 => 84,
            Isotope::Zn54 => 54,
            Isotope::Zn55 => 55,
            Isotope::Zn56 => 56,
            Isotope::Zn57 => 57,
            Isotope::Zn58 => 58,
            Isotope::Zn59 => 59,
            Isotope::Zn60 => 60,
            Isotope::Zn61 => 61,
            Isotope::Zn62 => 62,
            Isotope::Zn63 => 63,
            Isotope::Zn64 => 64,
            Isotope::Zn65 => 65,
            Isotope::Zn66 => 66,
            Isotope::Zn67 => 67,
            Isotope::Zn68 => 68,
            Isotope::Zn69 => 69,
            Isotope::Zn70 => 70,
            Isotope::Zn71 => 71,
            Isotope::Zn72 => 72,
            Isotope::Zn73 => 73,
            Isotope::Zn74 => 74,
            Isotope::Zn75 => 75,
            Isotope::Zn76 => 76,
            Isotope::Zn77 => 77,
            Isotope::Zn78 => 78,
            Isotope::Zn79 => 79,
            Isotope::Zn80 => 80,
            Isotope::Zn81 => 81,
            Isotope::Zn82 => 82,
            Isotope::Zn83 => 83,
            Isotope::Zn84 => 84,
            Isotope::Zn85 => 85,
            Isotope::Zn86 => 86,
            Isotope::Ga56 => 56,
            Isotope::Ga57 => 57,
            Isotope::Ga58 => 58,
            Isotope::Ga59 => 59,
            Isotope::Ga60 => 60,
            Isotope::Ga61 => 61,
            Isotope::Ga62 => 62,
            Isotope::Ga63 => 63,
            Isotope::Ga64 => 64,
            Isotope::Ga65 => 65,
            Isotope::Ga66 => 66,
            Isotope::Ga67 => 67,
            Isotope::Ga68 => 68,
            Isotope::Ga69 => 69,
            Isotope::Ga70 => 70,
            Isotope::Ga71 => 71,
            Isotope::Ga72 => 72,
            Isotope::Ga73 => 73,
            Isotope::Ga74 => 74,
            Isotope::Ga75 => 75,
            Isotope::Ga76 => 76,
            Isotope::Ga77 => 77,
            Isotope::Ga78 => 78,
            Isotope::Ga79 => 79,
            Isotope::Ga80 => 80,
            Isotope::Ga81 => 81,
            Isotope::Ga82 => 82,
            Isotope::Ga83 => 83,
            Isotope::Ga84 => 84,
            Isotope::Ga85 => 85,
            Isotope::Ga86 => 86,
            Isotope::Ga87 => 87,
            Isotope::Ga88 => 88,
            Isotope::Ge58 => 58,
            Isotope::Ge59 => 59,
            Isotope::Ge60 => 60,
            Isotope::Ge61 => 61,
            Isotope::Ge62 => 62,
            Isotope::Ge63 => 63,
            Isotope::Ge64 => 64,
            Isotope::Ge65 => 65,
            Isotope::Ge66 => 66,
            Isotope::Ge67 => 67,
            Isotope::Ge68 => 68,
            Isotope::Ge69 => 69,
            Isotope::Ge70 => 70,
            Isotope::Ge71 => 71,
            Isotope::Ge72 => 72,
            Isotope::Ge73 => 73,
            Isotope::Ge74 => 74,
            Isotope::Ge75 => 75,
            Isotope::Ge76 => 76,
            Isotope::Ge77 => 77,
            Isotope::Ge78 => 78,
            Isotope::Ge79 => 79,
            Isotope::Ge80 => 80,
            Isotope::Ge81 => 81,
            Isotope::Ge82 => 82,
            Isotope::Ge83 => 83,
            Isotope::Ge84 => 84,
            Isotope::Ge85 => 85,
            Isotope::Ge86 => 86,
            Isotope::Ge87 => 87,
            Isotope::Ge88 => 88,
            Isotope::Ge89 => 89,
            Isotope::Ge90 => 90,
            Isotope::As60 => 60,
            Isotope::As61 => 61,
            Isotope::As62 => 62,
            Isotope::As63 => 63,
            Isotope::As64 => 64,
            Isotope::As65 => 65,
            Isotope::As66 => 66,
            Isotope::As67 => 67,
            Isotope::As68 => 68,
            Isotope::As69 => 69,
            Isotope::As70 => 70,
            Isotope::As71 => 71,
            Isotope::As72 => 72,
            Isotope::As73 => 73,
            Isotope::As74 => 74,
            Isotope::As75 => 75,
            Isotope::As76 => 76,
            Isotope::As77 => 77,
            Isotope::As78 => 78,
            Isotope::As79 => 79,
            Isotope::As80 => 80,
            Isotope::As81 => 81,
            Isotope::As82 => 82,
            Isotope::As83 => 83,
            Isotope::As84 => 84,
            Isotope::As85 => 85,
            Isotope::As86 => 86,
            Isotope::As87 => 87,
            Isotope::As88 => 88,
            Isotope::As89 => 89,
            Isotope::As90 => 90,
            Isotope::As91 => 91,
            Isotope::As92 => 92,
            Isotope::Se63 => 63,
            Isotope::Se64 => 64,
            Isotope::Se65 => 65,
            Isotope::Se66 => 66,
            Isotope::Se67 => 67,
            Isotope::Se68 => 68,
            Isotope::Se69 => 69,
            Isotope::Se70 => 70,
            Isotope::Se71 => 71,
            Isotope::Se72 => 72,
            Isotope::Se73 => 73,
            Isotope::Se74 => 74,
            Isotope::Se75 => 75,
            Isotope::Se76 => 76,
            Isotope::Se77 => 77,
            Isotope::Se78 => 78,
            Isotope::Se79 => 79,
            Isotope::Se80 => 80,
            Isotope::Se81 => 81,
            Isotope::Se82 => 82,
            Isotope::Se83 => 83,
            Isotope::Se84 => 84,
            Isotope::Se85 => 85,
            Isotope::Se86 => 86,
            Isotope::Se87 => 87,
            Isotope::Se88 => 88,
            Isotope::Se89 => 89,
            Isotope::Se90 => 90,
            Isotope::Se91 => 91,
            Isotope::Se92 => 92,
            Isotope::Se93 => 93,
            Isotope::Se94 => 94,
            Isotope::Se95 => 95,
            Isotope::Br65 => 65,
            Isotope::Br66 => 66,
            Isotope::Br67 => 67,
            Isotope::Br68 => 68,
            Isotope::Br69 => 69,
            Isotope::Br70 => 70,
            Isotope::Br71 => 71,
            Isotope::Br72 => 72,
            Isotope::Br73 => 73,
            Isotope::Br74 => 74,
            Isotope::Br75 => 75,
            Isotope::Br76 => 76,
            Isotope::Br77 => 77,
            Isotope::Br78 => 78,
            Isotope::Br79 => 79,
            Isotope::Br80 => 80,
            Isotope::Br81 => 81,
            Isotope::Br82 => 82,
            Isotope::Br83 => 83,
            Isotope::Br84 => 84,
            Isotope::Br85 => 85,
            Isotope::Br86 => 86,
            Isotope::Br87 => 87,
            Isotope::Br88 => 88,
            Isotope::Br89 => 89,
            Isotope::Br90 => 90,
            Isotope::Br91 => 91,
            Isotope::Br92 => 92,
            Isotope::Br93 => 93,
            Isotope::Br94 => 94,
            Isotope::Br95 => 95,
            Isotope::Br96 => 96,
            Isotope::Br97 => 97,
            Isotope::Br98 => 98,
            Isotope::Kr67 => 67,
            Isotope::Kr68 => 68,
            Isotope::Kr69 => 69,
            Isotope::Kr70 => 70,
            Isotope::Kr71 => 71,
            Isotope::Kr72 => 72,
            Isotope::Kr73 => 73,
            Isotope::Kr74 => 74,
            Isotope::Kr75 => 75,
            Isotope::Kr76 => 76,
            Isotope::Kr77 => 77,
            Isotope::Kr78 => 78,
            Isotope::Kr79 => 79,
            Isotope::Kr80 => 80,
            Isotope::Kr81 => 81,
            Isotope::Kr82 => 82,
            Isotope::Kr83 => 83,
            Isotope::Kr84 => 84,
            Isotope::Kr85 => 85,
            Isotope::Kr86 => 86,
            Isotope::Kr87 => 87,
            Isotope::Kr88 => 88,
            Isotope::Kr89 => 89,
            Isotope::Kr90 => 90,
            Isotope::Kr91 => 91,
            Isotope::Kr92 => 92,
            Isotope::Kr93 => 93,
            Isotope::Kr94 => 94,
            Isotope::Kr95 => 95,
            Isotope::Kr96 => 96,
            Isotope::Kr97 => 97,
            Isotope::Kr98 => 98,
            Isotope::Kr99 => 99,
            Isotope::Kr100 => 100,
            Isotope::Kr101 => 101,
            Isotope::Rb71 => 71,
            Isotope::Rb72 => 72,
            Isotope::Rb73 => 73,
            Isotope::Rb74 => 74,
            Isotope::Rb75 => 75,
            Isotope::Rb76 => 76,
            Isotope::Rb77 => 77,
            Isotope::Rb78 => 78,
            Isotope::Rb79 => 79,
            Isotope::Rb80 => 80,
            Isotope::Rb81 => 81,
            Isotope::Rb82 => 82,
            Isotope::Rb83 => 83,
            Isotope::Rb84 => 84,
            Isotope::Rb85 => 85,
            Isotope::Rb86 => 86,
            Isotope::Rb87 => 87,
            Isotope::Rb88 => 88,
            Isotope::Rb89 => 89,
            Isotope::Rb90 => 90,
            Isotope::Rb91 => 91,
            Isotope::Rb92 => 92,
            Isotope::Rb93 => 93,
            Isotope::Rb94 => 94,
            Isotope::Rb95 => 95,
            Isotope::Rb96 => 96,
            Isotope::Rb97 => 97,
            Isotope::Rb98 => 98,
            Isotope::Rb99 => 99,
            Isotope::Rb100 => 100,
            Isotope::Rb101 => 101,
            Isotope::Rb102 => 102,
            Isotope::Rb103 => 103,
            Isotope::Rb104 => 104,
            Isotope::Sr73 => 73,
            Isotope::Sr74 => 74,
            Isotope::Sr75 => 75,
            Isotope::Sr76 => 76,
            Isotope::Sr77 => 77,
            Isotope::Sr78 => 78,
            Isotope::Sr79 => 79,
            Isotope::Sr80 => 80,
            Isotope::Sr81 => 81,
            Isotope::Sr82 => 82,
            Isotope::Sr83 => 83,
            Isotope::Sr84 => 84,
            Isotope::Sr85 => 85,
            Isotope::Sr86 => 86,
            Isotope::Sr87 => 87,
            Isotope::Sr88 => 88,
            Isotope::Sr89 => 89,
            Isotope::Sr90 => 90,
            Isotope::Sr91 => 91,
            Isotope::Sr92 => 92,
            Isotope::Sr93 => 93,
            Isotope::Sr94 => 94,
            Isotope::Sr95 => 95,
            Isotope::Sr96 => 96,
            Isotope::Sr97 => 97,
            Isotope::Sr98 => 98,
            Isotope::Sr99 => 99,
            Isotope::Sr100 => 100,
            Isotope::Sr101 => 101,
            Isotope::Sr102 => 102,
            Isotope::Sr103 => 103,
            Isotope::Sr104 => 104,
            Isotope::Sr105 => 105,
            Isotope::Sr106 => 106,
            Isotope::Sr107 => 107,
            Isotope::Y75 => 75,
            Isotope::Y76 => 76,
            Isotope::Y77 => 77,
            Isotope::Y78 => 78,
            Isotope::Y79 => 79,
            Isotope::Y80 => 80,
            Isotope::Y81 => 81,
            Isotope::Y82 => 82,
            Isotope::Y83 => 83,
            Isotope::Y84 => 84,
            Isotope::Y85 => 85,
            Isotope::Y86 => 86,
            Isotope::Y87 => 87,
            Isotope::Y88 => 88,
            Isotope::Y89 => 89,
            Isotope::Y90 => 90,
            Isotope::Y91 => 91,
            Isotope::Y92 => 92,
            Isotope::Y93 => 93,
            Isotope::Y94 => 94,
            Isotope::Y95 => 95,
            Isotope::Y96 => 96,
            Isotope::Y97 => 97,
            Isotope::Y98 => 98,
            Isotope::Y99 => 99,
            Isotope::Y100 => 100,
            Isotope::Y101 => 101,
            Isotope::Y102 => 102,
            Isotope::Y103 => 103,
            Isotope::Y104 => 104,
            Isotope::Y105 => 105,
            Isotope::Y106 => 106,
            Isotope::Y107 => 107,
            Isotope::Y108 => 108,
            Isotope::Y109 => 109,
            Isotope::Zr77 => 77,
            Isotope::Zr78 => 78,
            Isotope::Zr79 => 79,
            Isotope::Zr80 => 80,
            Isotope::Zr81 => 81,
            Isotope::Zr82 => 82,
            Isotope::Zr83 => 83,
            Isotope::Zr84 => 84,
            Isotope::Zr85 => 85,
            Isotope::Zr86 => 86,
            Isotope::Zr87 => 87,
            Isotope::Zr88 => 88,
            Isotope::Zr89 => 89,
            Isotope::Zr90 => 90,
            Isotope::Zr91 => 91,
            Isotope::Zr92 => 92,
            Isotope::Zr93 => 93,
            Isotope::Zr94 => 94,
            Isotope::Zr95 => 95,
            Isotope::Zr96 => 96,
            Isotope::Zr97 => 97,
            Isotope::Zr98 => 98,
            Isotope::Zr99 => 99,
            Isotope::Zr100 => 100,
            Isotope::Zr101 => 101,
            Isotope::Zr102 => 102,
            Isotope::Zr103 => 103,
            Isotope::Zr104 => 104,
            Isotope::Zr105 => 105,
            Isotope::Zr106 => 106,
            Isotope::Zr107 => 107,
            Isotope::Zr108 => 108,
            Isotope::Zr109 => 109,
            Isotope::Zr110 => 110,
            Isotope::Zr111 => 111,
            Isotope::Zr112 => 112,
            Isotope::Zr113 => 113,
            Isotope::Nb79 => 79,
            Isotope::Nb80 => 80,
            Isotope::Nb81 => 81,
            Isotope::Nb82 => 82,
            Isotope::Nb83 => 83,
            Isotope::Nb84 => 84,
            Isotope::Nb85 => 85,
            Isotope::Nb86 => 86,
            Isotope::Nb87 => 87,
            Isotope::Nb88 => 88,
            Isotope::Nb89 => 89,
            Isotope::Nb90 => 90,
            Isotope::Nb91 => 91,
            Isotope::Nb92 => 92,
            Isotope::Nb93 => 93,
            Isotope::Nb94 => 94,
            Isotope::Nb95 => 95,
            Isotope::Nb96 => 96,
            Isotope::Nb97 => 97,
            Isotope::Nb98 => 98,
            Isotope::Nb99 => 99,
            Isotope::Nb100 => 100,
            Isotope::Nb101 => 101,
            Isotope::Nb102 => 102,
            Isotope::Nb103 => 103,
            Isotope::Nb104 => 104,
            Isotope::Nb105 => 105,
            Isotope::Nb106 => 106,
            Isotope::Nb107 => 107,
            Isotope::Nb108 => 108,
            Isotope::Nb109 => 109,
            Isotope::Nb110 => 110,
            Isotope::Nb111 => 111,
            Isotope::Nb112 => 112,
            Isotope::Nb113 => 113,
            Isotope::Nb114 => 114,
            Isotope::Nb115 => 115,
            Isotope::Nb116 => 116,
            Isotope::Mo81 => 81,
            Isotope::Mo82 => 82,
            Isotope::Mo83 => 83,
            Isotope::Mo84 => 84,
            Isotope::Mo85 => 85,
            Isotope::Mo86 => 86,
            Isotope::Mo87 => 87,
            Isotope::Mo88 => 88,
            Isotope::Mo89 => 89,
            Isotope::Mo90 => 90,
            Isotope::Mo91 => 91,
            Isotope::Mo92 => 92,
            Isotope::Mo93 => 93,
            Isotope::Mo94 => 94,
            Isotope::Mo95 => 95,
            Isotope::Mo96 => 96,
            Isotope::Mo97 => 97,
            Isotope::Mo98 => 98,
            Isotope::Mo99 => 99,
            Isotope::Mo100 => 100,
            Isotope::Mo101 => 101,
            Isotope::Mo102 => 102,
            Isotope::Mo103 => 103,
            Isotope::Mo104 => 104,
            Isotope::Mo105 => 105,
            Isotope::Mo106 => 106,
            Isotope::Mo107 => 107,
            Isotope::Mo108 => 108,
            Isotope::Mo109 => 109,
            Isotope::Mo110 => 110,
            Isotope::Mo111 => 111,
            Isotope::Mo112 => 112,
            Isotope::Mo113 => 113,
            Isotope::Mo114 => 114,
            Isotope::Mo115 => 115,
            Isotope::Mo116 => 116,
            Isotope::Mo117 => 117,
            Isotope::Mo118 => 118,
            Isotope::Mo119 => 119,
            Isotope::Tc83 => 83,
            Isotope::Tc84 => 84,
            Isotope::Tc85 => 85,
            Isotope::Tc86 => 86,
            Isotope::Tc87 => 87,
            Isotope::Tc88 => 88,
            Isotope::Tc89 => 89,
            Isotope::Tc90 => 90,
            Isotope::Tc91 => 91,
            Isotope::Tc92 => 92,
            Isotope::Tc93 => 93,
            Isotope::Tc94 => 94,
            Isotope::Tc95 => 95,
            Isotope::Tc96 => 96,
            Isotope::Tc97 => 97,
            Isotope::Tc98 => 98,
            Isotope::Tc99 => 99,
            Isotope::Tc100 => 100,
            Isotope::Tc101 => 101,
            Isotope::Tc102 => 102,
            Isotope::Tc103 => 103,
            Isotope::Tc104 => 104,
            Isotope::Tc105 => 105,
            Isotope::Tc106 => 106,
            Isotope::Tc107 => 107,
            Isotope::Tc108 => 108,
            Isotope::Tc109 => 109,
            Isotope::Tc110 => 110,
            Isotope::Tc111 => 111,
            Isotope::Tc112 => 112,
            Isotope::Tc113 => 113,
            Isotope::Tc114 => 114,
            Isotope::Tc115 => 115,
            Isotope::Tc116 => 116,
            Isotope::Tc117 => 117,
            Isotope::Tc118 => 118,
            Isotope::Tc119 => 119,
            Isotope::Tc120 => 120,
            Isotope::Tc121 => 121,
            Isotope::Tc122 => 122,
            Isotope::Ru85 => 85,
            Isotope::Ru86 => 86,
            Isotope::Ru87 => 87,
            Isotope::Ru88 => 88,
            Isotope::Ru89 => 89,
            Isotope::Ru90 => 90,
            Isotope::Ru91 => 91,
            Isotope::Ru92 => 92,
            Isotope::Ru93 => 93,
            Isotope::Ru94 => 94,
            Isotope::Ru95 => 95,
            Isotope::Ru96 => 96,
            Isotope::Ru97 => 97,
            Isotope::Ru98 => 98,
            Isotope::Ru99 => 99,
            Isotope::Ru100 => 100,
            Isotope::Ru101 => 101,
            Isotope::Ru102 => 102,
            Isotope::Ru103 => 103,
            Isotope::Ru104 => 104,
            Isotope::Ru105 => 105,
            Isotope::Ru106 => 106,
            Isotope::Ru107 => 107,
            Isotope::Ru108 => 108,
            Isotope::Ru109 => 109,
            Isotope::Ru110 => 110,
            Isotope::Ru111 => 111,
            Isotope::Ru112 => 112,
            Isotope::Ru113 => 113,
            Isotope::Ru114 => 114,
            Isotope::Ru115 => 115,
            Isotope::Ru116 => 116,
            Isotope::Ru117 => 117,
            Isotope::Ru118 => 118,
            Isotope::Ru119 => 119,
            Isotope::Ru120 => 120,
            Isotope::Ru121 => 121,
            Isotope::Ru122 => 122,
            Isotope::Ru123 => 123,
            Isotope::Ru124 => 124,
            Isotope::Ru125 => 125,
            Isotope::Rh88 => 88,
            Isotope::Rh89 => 89,
            Isotope::Rh90 => 90,
            Isotope::Rh91 => 91,
            Isotope::Rh92 => 92,
            Isotope::Rh93 => 93,
            Isotope::Rh94 => 94,
            Isotope::Rh95 => 95,
            Isotope::Rh96 => 96,
            Isotope::Rh97 => 97,
            Isotope::Rh98 => 98,
            Isotope::Rh99 => 99,
            Isotope::Rh100 => 100,
            Isotope::Rh101 => 101,
            Isotope::Rh102 => 102,
            Isotope::Rh103 => 103,
            Isotope::Rh104 => 104,
            Isotope::Rh105 => 105,
            Isotope::Rh106 => 106,
            Isotope::Rh107 => 107,
            Isotope::Rh108 => 108,
            Isotope::Rh109 => 109,
            Isotope::Rh110 => 110,
            Isotope::Rh111 => 111,
            Isotope::Rh112 => 112,
            Isotope::Rh113 => 113,
            Isotope::Rh114 => 114,
            Isotope::Rh115 => 115,
            Isotope::Rh116 => 116,
            Isotope::Rh117 => 117,
            Isotope::Rh118 => 118,
            Isotope::Rh119 => 119,
            Isotope::Rh120 => 120,
            Isotope::Rh121 => 121,
            Isotope::Rh122 => 122,
            Isotope::Rh123 => 123,
            Isotope::Rh124 => 124,
            Isotope::Rh125 => 125,
            Isotope::Rh126 => 126,
            Isotope::Rh127 => 127,
            Isotope::Rh128 => 128,
            Isotope::Pd90 => 90,
            Isotope::Pd91 => 91,
            Isotope::Pd92 => 92,
            Isotope::Pd93 => 93,
            Isotope::Pd94 => 94,
            Isotope::Pd95 => 95,
            Isotope::Pd96 => 96,
            Isotope::Pd97 => 97,
            Isotope::Pd98 => 98,
            Isotope::Pd99 => 99,
            Isotope::Pd100 => 100,
            Isotope::Pd101 => 101,
            Isotope::Pd102 => 102,
            Isotope::Pd103 => 103,
            Isotope::Pd104 => 104,
            Isotope::Pd105 => 105,
            Isotope::Pd106 => 106,
            Isotope::Pd107 => 107,
            Isotope::Pd108 => 108,
            Isotope::Pd109 => 109,
            Isotope::Pd110 => 110,
            Isotope::Pd111 => 111,
            Isotope::Pd112 => 112,
            Isotope::Pd113 => 113,
            Isotope::Pd114 => 114,
            Isotope::Pd115 => 115,
            Isotope::Pd116 => 116,
            Isotope::Pd117 => 117,
            Isotope::Pd118 => 118,
            Isotope::Pd119 => 119,
            Isotope::Pd120 => 120,
            Isotope::Pd121 => 121,
            Isotope::Pd122 => 122,
            Isotope::Pd123 => 123,
            Isotope::Pd124 => 124,
            Isotope::Pd125 => 125,
            Isotope::Pd126 => 126,
            Isotope::Pd127 => 127,
            Isotope::Pd128 => 128,
            Isotope::Pd129 => 129,
            Isotope::Pd130 => 130,
            Isotope::Pd131 => 131,
            Isotope::Ag92 => 92,
            Isotope::Ag93 => 93,
            Isotope::Ag94 => 94,
            Isotope::Ag95 => 95,
            Isotope::Ag96 => 96,
            Isotope::Ag97 => 97,
            Isotope::Ag98 => 98,
            Isotope::Ag99 => 99,
            Isotope::Ag100 => 100,
            Isotope::Ag101 => 101,
            Isotope::Ag102 => 102,
            Isotope::Ag103 => 103,
            Isotope::Ag104 => 104,
            Isotope::Ag105 => 105,
            Isotope::Ag106 => 106,
            Isotope::Ag107 => 107,
            Isotope::Ag108 => 108,
            Isotope::Ag109 => 109,
            Isotope::Ag110 => 110,
            Isotope::Ag111 => 111,
            Isotope::Ag112 => 112,
            Isotope::Ag113 => 113,
            Isotope::Ag114 => 114,
            Isotope::Ag115 => 115,
            Isotope::Ag116 => 116,
            Isotope::Ag117 => 117,
            Isotope::Ag118 => 118,
            Isotope::Ag119 => 119,
            Isotope::Ag120 => 120,
            Isotope::Ag121 => 121,
            Isotope::Ag122 => 122,
            Isotope::Ag123 => 123,
            Isotope::Ag124 => 124,
            Isotope::Ag125 => 125,
            Isotope::Ag126 => 126,
            Isotope::Ag127 => 127,
            Isotope::Ag128 => 128,
            Isotope::Ag129 => 129,
            Isotope::Ag130 => 130,
            Isotope::Ag131 => 131,
            Isotope::Ag132 => 132,
            Isotope::Ag133 => 133,
            Isotope::Cd94 => 94,
            Isotope::Cd95 => 95,
            Isotope::Cd96 => 96,
            Isotope::Cd97 => 97,
            Isotope::Cd98 => 98,
            Isotope::Cd99 => 99,
            Isotope::Cd100 => 100,
            Isotope::Cd101 => 101,
            Isotope::Cd102 => 102,
            Isotope::Cd103 => 103,
            Isotope::Cd104 => 104,
            Isotope::Cd105 => 105,
            Isotope::Cd106 => 106,
            Isotope::Cd107 => 107,
            Isotope::Cd108 => 108,
            Isotope::Cd109 => 109,
            Isotope::Cd110 => 110,
            Isotope::Cd111 => 111,
            Isotope::Cd112 => 112,
            Isotope::Cd113 => 113,
            Isotope::Cd114 => 114,
            Isotope::Cd115 => 115,
            Isotope::Cd116 => 116,
            Isotope::Cd117 => 117,
            Isotope::Cd118 => 118,
            Isotope::Cd119 => 119,
            Isotope::Cd120 => 120,
            Isotope::Cd121 => 121,
            Isotope::Cd122 => 122,
            Isotope::Cd123 => 123,
            Isotope::Cd124 => 124,
            Isotope::Cd125 => 125,
            Isotope::Cd126 => 126,
            Isotope::Cd127 => 127,
            Isotope::Cd128 => 128,
            Isotope::Cd129 => 129,
            Isotope::Cd130 => 130,
            Isotope::Cd131 => 131,
            Isotope::Cd132 => 132,
            Isotope::Cd133 => 133,
            Isotope::Cd134 => 134,
            Isotope::Cd135 => 135,
            Isotope::In96 => 96,
            Isotope::In97 => 97,
            Isotope::In98 => 98,
            Isotope::In99 => 99,
            Isotope::In100 => 100,
            Isotope::In101 => 101,
            Isotope::In102 => 102,
            Isotope::In103 => 103,
            Isotope::In104 => 104,
            Isotope::In105 => 105,
            Isotope::In106 => 106,
            Isotope::In107 => 107,
            Isotope::In108 => 108,
            Isotope::In109 => 109,
            Isotope::In110 => 110,
            Isotope::In111 => 111,
            Isotope::In112 => 112,
            Isotope::In113 => 113,
            Isotope::In114 => 114,
            Isotope::In115 => 115,
            Isotope::In116 => 116,
            Isotope::In117 => 117,
            Isotope::In118 => 118,
            Isotope::In119 => 119,
            Isotope::In120 => 120,
            Isotope::In121 => 121,
            Isotope::In122 => 122,
            Isotope::In123 => 123,
            Isotope::In124 => 124,
            Isotope::In125 => 125,
            Isotope::In126 => 126,
            Isotope::In127 => 127,
            Isotope::In128 => 128,
            Isotope::In129 => 129,
            Isotope::In130 => 130,
            Isotope::In131 => 131,
            Isotope::In132 => 132,
            Isotope::In133 => 133,
            Isotope::In134 => 134,
            Isotope::In135 => 135,
            Isotope::In136 => 136,
            Isotope::In137 => 137,
            Isotope::Sn99 => 99,
            Isotope::Sn100 => 100,
            Isotope::Sn101 => 101,
            Isotope::Sn102 => 102,
            Isotope::Sn103 => 103,
            Isotope::Sn104 => 104,
            Isotope::Sn105 => 105,
            Isotope::Sn106 => 106,
            Isotope::Sn107 => 107,
            Isotope::Sn108 => 108,
            Isotope::Sn109 => 109,
            Isotope::Sn110 => 110,
            Isotope::Sn111 => 111,
            Isotope::Sn112 => 112,
            Isotope::Sn113 => 113,
            Isotope::Sn114 => 114,
            Isotope::Sn115 => 115,
            Isotope::Sn116 => 116,
            Isotope::Sn117 => 117,
            Isotope::Sn118 => 118,
            Isotope::Sn119 => 119,
            Isotope::Sn120 => 120,
            Isotope::Sn121 => 121,
            Isotope::Sn122 => 122,
            Isotope::Sn123 => 123,
            Isotope::Sn124 => 124,
            Isotope::Sn125 => 125,
            Isotope::Sn126 => 126,
            Isotope::Sn127 => 127,
            Isotope::Sn128 => 128,
            Isotope::Sn129 => 129,
            Isotope::Sn130 => 130,
            Isotope::Sn131 => 131,
            Isotope::Sn132 => 132,
            Isotope::Sn133 => 133,
            Isotope::Sn134 => 134,
            Isotope::Sn135 => 135,
            Isotope::Sn136 => 136,
            Isotope::Sn137 => 137,
            Isotope::Sn138 => 138,
            Isotope::Sn139 => 139,
            Isotope::Sn140 => 140,
            Isotope::Sb102 => 102,
            Isotope::Sb103 => 103,
            Isotope::Sb104 => 104,
            Isotope::Sb105 => 105,
            Isotope::Sb106 => 106,
            Isotope::Sb107 => 107,
            Isotope::Sb108 => 108,
            Isotope::Sb109 => 109,
            Isotope::Sb110 => 110,
            Isotope::Sb111 => 111,
            Isotope::Sb112 => 112,
            Isotope::Sb113 => 113,
            Isotope::Sb114 => 114,
            Isotope::Sb115 => 115,
            Isotope::Sb116 => 116,
            Isotope::Sb117 => 117,
            Isotope::Sb118 => 118,
            Isotope::Sb119 => 119,
            Isotope::Sb120 => 120,
            Isotope::Sb121 => 121,
            Isotope::Sb122 => 122,
            Isotope::Sb123 => 123,
            Isotope::Sb124 => 124,
            Isotope::Sb125 => 125,
            Isotope::Sb126 => 126,
            Isotope::Sb127 => 127,
            Isotope::Sb128 => 128,
            Isotope::Sb129 => 129,
            Isotope::Sb130 => 130,
            Isotope::Sb131 => 131,
            Isotope::Sb132 => 132,
            Isotope::Sb133 => 133,
            Isotope::Sb134 => 134,
            Isotope::Sb135 => 135,
            Isotope::Sb136 => 136,
            Isotope::Sb137 => 137,
            Isotope::Sb138 => 138,
            Isotope::Sb139 => 139,
            Isotope::Sb140 => 140,
            Isotope::Sb141 => 141,
            Isotope::Sb142 => 142,
            Isotope::Te104 => 104,
            Isotope::Te105 => 105,
            Isotope::Te106 => 106,
            Isotope::Te107 => 107,
            Isotope::Te108 => 108,
            Isotope::Te109 => 109,
            Isotope::Te110 => 110,
            Isotope::Te111 => 111,
            Isotope::Te112 => 112,
            Isotope::Te113 => 113,
            Isotope::Te114 => 114,
            Isotope::Te115 => 115,
            Isotope::Te116 => 116,
            Isotope::Te117 => 117,
            Isotope::Te118 => 118,
            Isotope::Te119 => 119,
            Isotope::Te120 => 120,
            Isotope::Te121 => 121,
            Isotope::Te122 => 122,
            Isotope::Te123 => 123,
            Isotope::Te124 => 124,
            Isotope::Te125 => 125,
            Isotope::Te126 => 126,
            Isotope::Te127 => 127,
            Isotope::Te128 => 128,
            Isotope::Te129 => 129,
            Isotope::Te130 => 130,
            Isotope::Te131 => 131,
            Isotope::Te132 => 132,
            Isotope::Te133 => 133,
            Isotope::Te134 => 134,
            Isotope::Te135 => 135,
            Isotope::Te136 => 136,
            Isotope::Te137 => 137,
            Isotope::Te138 => 138,
            Isotope::Te139 => 139,
            Isotope::Te140 => 140,
            Isotope::Te141 => 141,
            Isotope::Te142 => 142,
            Isotope::Te143 => 143,
            Isotope::Te144 => 144,
            Isotope::Te145 => 145,
            Isotope::I106 => 106,
            Isotope::I107 => 107,
            Isotope::I108 => 108,
            Isotope::I109 => 109,
            Isotope::I110 => 110,
            Isotope::I111 => 111,
            Isotope::I112 => 112,
            Isotope::I113 => 113,
            Isotope::I114 => 114,
            Isotope::I115 => 115,
            Isotope::I116 => 116,
            Isotope::I117 => 117,
            Isotope::I118 => 118,
            Isotope::I119 => 119,
            Isotope::I120 => 120,
            Isotope::I121 => 121,
            Isotope::I122 => 122,
            Isotope::I123 => 123,
            Isotope::I124 => 124,
            Isotope::I125 => 125,
            Isotope::I126 => 126,
            Isotope::I127 => 127,
            Isotope::I128 => 128,
            Isotope::I129 => 129,
            Isotope::I130 => 130,
            Isotope::I131 => 131,
            Isotope::I132 => 132,
            Isotope::I133 => 133,
            Isotope::I134 => 134,
            Isotope::I135 => 135,
            Isotope::I136 => 136,
            Isotope::I137 => 137,
            Isotope::I138 => 138,
            Isotope::I139 => 139,
            Isotope::I140 => 140,
            Isotope::I141 => 141,
            Isotope::I142 => 142,
            Isotope::I143 => 143,
            Isotope::I144 => 144,
            Isotope::I145 => 145,
            Isotope::I146 => 146,
            Isotope::I147 => 147,
            Isotope::Xe108 => 108,
            Isotope::Xe109 => 109,
            Isotope::Xe110 => 110,
            Isotope::Xe111 => 111,
            Isotope::Xe112 => 112,
            Isotope::Xe113 => 113,
            Isotope::Xe114 => 114,
            Isotope::Xe115 => 115,
            Isotope::Xe116 => 116,
            Isotope::Xe117 => 117,
            Isotope::Xe118 => 118,
            Isotope::Xe119 => 119,
            Isotope::Xe120 => 120,
            Isotope::Xe121 => 121,
            Isotope::Xe122 => 122,
            Isotope::Xe123 => 123,
            Isotope::Xe124 => 124,
            Isotope::Xe125 => 125,
            Isotope::Xe126 => 126,
            Isotope::Xe127 => 127,
            Isotope::Xe128 => 128,
            Isotope::Xe129 => 129,
            Isotope::Xe130 => 130,
            Isotope::Xe131 => 131,
            Isotope::Xe132 => 132,
            Isotope::Xe133 => 133,
            Isotope::Xe134 => 134,
            Isotope::Xe135 => 135,
            Isotope::Xe136 => 136,
            Isotope::Xe137 => 137,
            Isotope::Xe138 => 138,
            Isotope::Xe139 => 139,
            Isotope::Xe140 => 140,
            Isotope::Xe141 => 141,
            Isotope::Xe142 => 142,
            Isotope::Xe143 => 143,
            Isotope::Xe144 => 144,
            Isotope::Xe145 => 145,
            Isotope::Xe146 => 146,
            Isotope::Xe147 => 147,
            Isotope::Xe148 => 148,
            Isotope::Xe149 => 149,
            Isotope::Xe150 => 150,
            Isotope::Cs111 => 111,
            Isotope::Cs112 => 112,
            Isotope::Cs113 => 113,
            Isotope::Cs114 => 114,
            Isotope::Cs115 => 115,
            Isotope::Cs116 => 116,
            Isotope::Cs117 => 117,
            Isotope::Cs118 => 118,
            Isotope::Cs119 => 119,
            Isotope::Cs120 => 120,
            Isotope::Cs121 => 121,
            Isotope::Cs122 => 122,
            Isotope::Cs123 => 123,
            Isotope::Cs124 => 124,
            Isotope::Cs125 => 125,
            Isotope::Cs126 => 126,
            Isotope::Cs127 => 127,
            Isotope::Cs128 => 128,
            Isotope::Cs129 => 129,
            Isotope::Cs130 => 130,
            Isotope::Cs131 => 131,
            Isotope::Cs132 => 132,
            Isotope::Cs133 => 133,
            Isotope::Cs134 => 134,
            Isotope::Cs135 => 135,
            Isotope::Cs136 => 136,
            Isotope::Cs137 => 137,
            Isotope::Cs138 => 138,
            Isotope::Cs139 => 139,
            Isotope::Cs140 => 140,
            Isotope::Cs141 => 141,
            Isotope::Cs142 => 142,
            Isotope::Cs143 => 143,
            Isotope::Cs144 => 144,
            Isotope::Cs145 => 145,
            Isotope::Cs146 => 146,
            Isotope::Cs147 => 147,
            Isotope::Cs148 => 148,
            Isotope::Cs149 => 149,
            Isotope::Cs150 => 150,
            Isotope::Cs151 => 151,
            Isotope::Cs152 => 152,
            Isotope::Ba113 => 113,
            Isotope::Ba114 => 114,
            Isotope::Ba115 => 115,
            Isotope::Ba116 => 116,
            Isotope::Ba117 => 117,
            Isotope::Ba118 => 118,
            Isotope::Ba119 => 119,
            Isotope::Ba120 => 120,
            Isotope::Ba121 => 121,
            Isotope::Ba122 => 122,
            Isotope::Ba123 => 123,
            Isotope::Ba124 => 124,
            Isotope::Ba125 => 125,
            Isotope::Ba126 => 126,
            Isotope::Ba127 => 127,
            Isotope::Ba128 => 128,
            Isotope::Ba129 => 129,
            Isotope::Ba130 => 130,
            Isotope::Ba131 => 131,
            Isotope::Ba132 => 132,
            Isotope::Ba133 => 133,
            Isotope::Ba134 => 134,
            Isotope::Ba135 => 135,
            Isotope::Ba136 => 136,
            Isotope::Ba137 => 137,
            Isotope::Ba138 => 138,
            Isotope::Ba139 => 139,
            Isotope::Ba140 => 140,
            Isotope::Ba141 => 141,
            Isotope::Ba142 => 142,
            Isotope::Ba143 => 143,
            Isotope::Ba144 => 144,
            Isotope::Ba145 => 145,
            Isotope::Ba146 => 146,
            Isotope::Ba147 => 147,
            Isotope::Ba148 => 148,
            Isotope::Ba149 => 149,
            Isotope::Ba150 => 150,
            Isotope::Ba151 => 151,
            Isotope::Ba152 => 152,
            Isotope::Ba153 => 153,
            Isotope::Ba154 => 154,
            Isotope::La116 => 116,
            Isotope::La117 => 117,
            Isotope::La118 => 118,
            Isotope::La119 => 119,
            Isotope::La120 => 120,
            Isotope::La121 => 121,
            Isotope::La122 => 122,
            Isotope::La123 => 123,
            Isotope::La124 => 124,
            Isotope::La125 => 125,
            Isotope::La126 => 126,
            Isotope::La127 => 127,
            Isotope::La128 => 128,
            Isotope::La129 => 129,
            Isotope::La130 => 130,
            Isotope::La131 => 131,
            Isotope::La132 => 132,
            Isotope::La133 => 133,
            Isotope::La134 => 134,
            Isotope::La135 => 135,
            Isotope::La136 => 136,
            Isotope::La137 => 137,
            Isotope::La138 => 138,
            Isotope::La139 => 139,
            Isotope::La140 => 140,
            Isotope::La141 => 141,
            Isotope::La142 => 142,
            Isotope::La143 => 143,
            Isotope::La144 => 144,
            Isotope::La145 => 145,
            Isotope::La146 => 146,
            Isotope::La147 => 147,
            Isotope::La148 => 148,
            Isotope::La149 => 149,
            Isotope::La150 => 150,
            Isotope::La151 => 151,
            Isotope::La152 => 152,
            Isotope::La153 => 153,
            Isotope::La154 => 154,
            Isotope::La155 => 155,
            Isotope::La156 => 156,
            Isotope::La157 => 157,
            Isotope::Ce119 => 119,
            Isotope::Ce120 => 120,
            Isotope::Ce121 => 121,
            Isotope::Ce122 => 122,
            Isotope::Ce123 => 123,
            Isotope::Ce124 => 124,
            Isotope::Ce125 => 125,
            Isotope::Ce126 => 126,
            Isotope::Ce127 => 127,
            Isotope::Ce128 => 128,
            Isotope::Ce129 => 129,
            Isotope::Ce130 => 130,
            Isotope::Ce131 => 131,
            Isotope::Ce132 => 132,
            Isotope::Ce133 => 133,
            Isotope::Ce134 => 134,
            Isotope::Ce135 => 135,
            Isotope::Ce136 => 136,
            Isotope::Ce137 => 137,
            Isotope::Ce138 => 138,
            Isotope::Ce139 => 139,
            Isotope::Ce140 => 140,
            Isotope::Ce141 => 141,
            Isotope::Ce142 => 142,
            Isotope::Ce143 => 143,
            Isotope::Ce144 => 144,
            Isotope::Ce145 => 145,
            Isotope::Ce146 => 146,
            Isotope::Ce147 => 147,
            Isotope::Ce148 => 148,
            Isotope::Ce149 => 149,
            Isotope::Ce150 => 150,
            Isotope::Ce151 => 151,
            Isotope::Ce152 => 152,
            Isotope::Ce153 => 153,
            Isotope::Ce154 => 154,
            Isotope::Ce155 => 155,
            Isotope::Ce156 => 156,
            Isotope::Ce157 => 157,
            Isotope::Ce158 => 158,
            Isotope::Ce159 => 159,
            Isotope::Pr121 => 121,
            Isotope::Pr122 => 122,
            Isotope::Pr123 => 123,
            Isotope::Pr124 => 124,
            Isotope::Pr125 => 125,
            Isotope::Pr126 => 126,
            Isotope::Pr127 => 127,
            Isotope::Pr128 => 128,
            Isotope::Pr129 => 129,
            Isotope::Pr130 => 130,
            Isotope::Pr131 => 131,
            Isotope::Pr132 => 132,
            Isotope::Pr133 => 133,
            Isotope::Pr134 => 134,
            Isotope::Pr135 => 135,
            Isotope::Pr136 => 136,
            Isotope::Pr137 => 137,
            Isotope::Pr138 => 138,
            Isotope::Pr139 => 139,
            Isotope::Pr140 => 140,
            Isotope::Pr141 => 141,
            Isotope::Pr142 => 142,
            Isotope::Pr143 => 143,
            Isotope::Pr144 => 144,
            Isotope::Pr145 => 145,
            Isotope::Pr146 => 146,
            Isotope::Pr147 => 147,
            Isotope::Pr148 => 148,
            Isotope::Pr149 => 149,
            Isotope::Pr150 => 150,
            Isotope::Pr151 => 151,
            Isotope::Pr152 => 152,
            Isotope::Pr153 => 153,
            Isotope::Pr154 => 154,
            Isotope::Pr155 => 155,
            Isotope::Pr156 => 156,
            Isotope::Pr157 => 157,
            Isotope::Pr158 => 158,
            Isotope::Pr159 => 159,
            Isotope::Pr160 => 160,
            Isotope::Pr161 => 161,
            Isotope::Nd124 => 124,
            Isotope::Nd125 => 125,
            Isotope::Nd126 => 126,
            Isotope::Nd127 => 127,
            Isotope::Nd128 => 128,
            Isotope::Nd129 => 129,
            Isotope::Nd130 => 130,
            Isotope::Nd131 => 131,
            Isotope::Nd132 => 132,
            Isotope::Nd133 => 133,
            Isotope::Nd134 => 134,
            Isotope::Nd135 => 135,
            Isotope::Nd136 => 136,
            Isotope::Nd137 => 137,
            Isotope::Nd138 => 138,
            Isotope::Nd139 => 139,
            Isotope::Nd140 => 140,
            Isotope::Nd141 => 141,
            Isotope::Nd142 => 142,
            Isotope::Nd143 => 143,
            Isotope::Nd144 => 144,
            Isotope::Nd145 => 145,
            Isotope::Nd146 => 146,
            Isotope::Nd147 => 147,
            Isotope::Nd148 => 148,
            Isotope::Nd149 => 149,
            Isotope::Nd150 => 150,
            Isotope::Nd151 => 151,
            Isotope::Nd152 => 152,
            Isotope::Nd153 => 153,
            Isotope::Nd154 => 154,
            Isotope::Nd155 => 155,
            Isotope::Nd156 => 156,
            Isotope::Nd157 => 157,
            Isotope::Nd158 => 158,
            Isotope::Nd159 => 159,
            Isotope::Nd160 => 160,
            Isotope::Nd161 => 161,
            Isotope::Nd162 => 162,
            Isotope::Nd163 => 163,
            Isotope::Pm126 => 126,
            Isotope::Pm127 => 127,
            Isotope::Pm128 => 128,
            Isotope::Pm129 => 129,
            Isotope::Pm130 => 130,
            Isotope::Pm131 => 131,
            Isotope::Pm132 => 132,
            Isotope::Pm133 => 133,
            Isotope::Pm134 => 134,
            Isotope::Pm135 => 135,
            Isotope::Pm136 => 136,
            Isotope::Pm137 => 137,
            Isotope::Pm138 => 138,
            Isotope::Pm139 => 139,
            Isotope::Pm140 => 140,
            Isotope::Pm141 => 141,
            Isotope::Pm142 => 142,
            Isotope::Pm143 => 143,
            Isotope::Pm144 => 144,
            Isotope::Pm145 => 145,
            Isotope::Pm146 => 146,
            Isotope::Pm147 => 147,
            Isotope::Pm148 => 148,
            Isotope::Pm149 => 149,
            Isotope::Pm150 => 150,
            Isotope::Pm151 => 151,
            Isotope::Pm152 => 152,
            Isotope::Pm153 => 153,
            Isotope::Pm154 => 154,
            Isotope::Pm155 => 155,
            Isotope::Pm156 => 156,
            Isotope::Pm157 => 157,
            Isotope::Pm158 => 158,
            Isotope::Pm159 => 159,
            Isotope::Pm160 => 160,
            Isotope::Pm161 => 161,
            Isotope::Pm162 => 162,
            Isotope::Pm163 => 163,
            Isotope::Pm164 => 164,
            Isotope::Pm165 => 165,
            Isotope::Sm128 => 128,
            Isotope::Sm129 => 129,
            Isotope::Sm130 => 130,
            Isotope::Sm131 => 131,
            Isotope::Sm132 => 132,
            Isotope::Sm133 => 133,
            Isotope::Sm134 => 134,
            Isotope::Sm135 => 135,
            Isotope::Sm136 => 136,
            Isotope::Sm137 => 137,
            Isotope::Sm138 => 138,
            Isotope::Sm139 => 139,
            Isotope::Sm140 => 140,
            Isotope::Sm141 => 141,
            Isotope::Sm142 => 142,
            Isotope::Sm143 => 143,
            Isotope::Sm144 => 144,
            Isotope::Sm145 => 145,
            Isotope::Sm146 => 146,
            Isotope::Sm147 => 147,
            Isotope::Sm148 => 148,
            Isotope::Sm149 => 149,
            Isotope::Sm150 => 150,
            Isotope::Sm151 => 151,
            Isotope::Sm152 => 152,
            Isotope::Sm153 => 153,
            Isotope::Sm154 => 154,
            Isotope::Sm155 => 155,
            Isotope::Sm156 => 156,
            Isotope::Sm157 => 157,
            Isotope::Sm158 => 158,
            Isotope::Sm159 => 159,
            Isotope::Sm160 => 160,
            Isotope::Sm161 => 161,
            Isotope::Sm162 => 162,
            Isotope::Sm163 => 163,
            Isotope::Sm164 => 164,
            Isotope::Sm165 => 165,
            Isotope::Sm166 => 166,
            Isotope::Sm167 => 167,
            Isotope::Sm168 => 168,
            Isotope::Eu130 => 130,
            Isotope::Eu131 => 131,
            Isotope::Eu132 => 132,
            Isotope::Eu133 => 133,
            Isotope::Eu134 => 134,
            Isotope::Eu135 => 135,
            Isotope::Eu136 => 136,
            Isotope::Eu137 => 137,
            Isotope::Eu138 => 138,
            Isotope::Eu139 => 139,
            Isotope::Eu140 => 140,
            Isotope::Eu141 => 141,
            Isotope::Eu142 => 142,
            Isotope::Eu143 => 143,
            Isotope::Eu144 => 144,
            Isotope::Eu145 => 145,
            Isotope::Eu146 => 146,
            Isotope::Eu147 => 147,
            Isotope::Eu148 => 148,
            Isotope::Eu149 => 149,
            Isotope::Eu150 => 150,
            Isotope::Eu151 => 151,
            Isotope::Eu152 => 152,
            Isotope::Eu153 => 153,
            Isotope::Eu154 => 154,
            Isotope::Eu155 => 155,
            Isotope::Eu156 => 156,
            Isotope::Eu157 => 157,
            Isotope::Eu158 => 158,
            Isotope::Eu159 => 159,
            Isotope::Eu160 => 160,
            Isotope::Eu161 => 161,
            Isotope::Eu162 => 162,
            Isotope::Eu163 => 163,
            Isotope::Eu164 => 164,
            Isotope::Eu165 => 165,
            Isotope::Eu166 => 166,
            Isotope::Eu167 => 167,
            Isotope::Eu168 => 168,
            Isotope::Eu169 => 169,
            Isotope::Eu170 => 170,
            Isotope::Gd133 => 133,
            Isotope::Gd134 => 134,
            Isotope::Gd135 => 135,
            Isotope::Gd136 => 136,
            Isotope::Gd137 => 137,
            Isotope::Gd138 => 138,
            Isotope::Gd139 => 139,
            Isotope::Gd140 => 140,
            Isotope::Gd141 => 141,
            Isotope::Gd142 => 142,
            Isotope::Gd143 => 143,
            Isotope::Gd144 => 144,
            Isotope::Gd145 => 145,
            Isotope::Gd146 => 146,
            Isotope::Gd147 => 147,
            Isotope::Gd148 => 148,
            Isotope::Gd149 => 149,
            Isotope::Gd150 => 150,
            Isotope::Gd151 => 151,
            Isotope::Gd152 => 152,
            Isotope::Gd153 => 153,
            Isotope::Gd154 => 154,
            Isotope::Gd155 => 155,
            Isotope::Gd156 => 156,
            Isotope::Gd157 => 157,
            Isotope::Gd158 => 158,
            Isotope::Gd159 => 159,
            Isotope::Gd160 => 160,
            Isotope::Gd161 => 161,
            Isotope::Gd162 => 162,
            Isotope::Gd163 => 163,
            Isotope::Gd164 => 164,
            Isotope::Gd165 => 165,
            Isotope::Gd166 => 166,
            Isotope::Gd167 => 167,
            Isotope::Gd168 => 168,
            Isotope::Gd169 => 169,
            Isotope::Gd170 => 170,
            Isotope::Gd171 => 171,
            Isotope::Gd172 => 172,
            Isotope::Tb135 => 135,
            Isotope::Tb136 => 136,
            Isotope::Tb137 => 137,
            Isotope::Tb138 => 138,
            Isotope::Tb139 => 139,
            Isotope::Tb140 => 140,
            Isotope::Tb141 => 141,
            Isotope::Tb142 => 142,
            Isotope::Tb143 => 143,
            Isotope::Tb144 => 144,
            Isotope::Tb145 => 145,
            Isotope::Tb146 => 146,
            Isotope::Tb147 => 147,
            Isotope::Tb148 => 148,
            Isotope::Tb149 => 149,
            Isotope::Tb150 => 150,
            Isotope::Tb151 => 151,
            Isotope::Tb152 => 152,
            Isotope::Tb153 => 153,
            Isotope::Tb154 => 154,
            Isotope::Tb155 => 155,
            Isotope::Tb156 => 156,
            Isotope::Tb157 => 157,
            Isotope::Tb158 => 158,
            Isotope::Tb159 => 159,
            Isotope::Tb160 => 160,
            Isotope::Tb161 => 161,
            Isotope::Tb162 => 162,
            Isotope::Tb163 => 163,
            Isotope::Tb164 => 164,
            Isotope::Tb165 => 165,
            Isotope::Tb166 => 166,
            Isotope::Tb167 => 167,
            Isotope::Tb168 => 168,
            Isotope::Tb169 => 169,
            Isotope::Tb170 => 170,
            Isotope::Tb171 => 171,
            Isotope::Tb172 => 172,
            Isotope::Tb173 => 173,
            Isotope::Tb174 => 174,
            Isotope::Dy138 => 138,
            Isotope::Dy139 => 139,
            Isotope::Dy140 => 140,
            Isotope::Dy141 => 141,
            Isotope::Dy142 => 142,
            Isotope::Dy143 => 143,
            Isotope::Dy144 => 144,
            Isotope::Dy145 => 145,
            Isotope::Dy146 => 146,
            Isotope::Dy147 => 147,
            Isotope::Dy148 => 148,
            Isotope::Dy149 => 149,
            Isotope::Dy150 => 150,
            Isotope::Dy151 => 151,
            Isotope::Dy152 => 152,
            Isotope::Dy153 => 153,
            Isotope::Dy154 => 154,
            Isotope::Dy155 => 155,
            Isotope::Dy156 => 156,
            Isotope::Dy157 => 157,
            Isotope::Dy158 => 158,
            Isotope::Dy159 => 159,
            Isotope::Dy160 => 160,
            Isotope::Dy161 => 161,
            Isotope::Dy162 => 162,
            Isotope::Dy163 => 163,
            Isotope::Dy164 => 164,
            Isotope::Dy165 => 165,
            Isotope::Dy166 => 166,
            Isotope::Dy167 => 167,
            Isotope::Dy168 => 168,
            Isotope::Dy169 => 169,
            Isotope::Dy170 => 170,
            Isotope::Dy171 => 171,
            Isotope::Dy172 => 172,
            Isotope::Dy173 => 173,
            Isotope::Dy174 => 174,
            Isotope::Dy175 => 175,
            Isotope::Dy176 => 176,
            Isotope::Ho140 => 140,
            Isotope::Ho141 => 141,
            Isotope::Ho142 => 142,
            Isotope::Ho143 => 143,
            Isotope::Ho144 => 144,
            Isotope::Ho145 => 145,
            Isotope::Ho146 => 146,
            Isotope::Ho147 => 147,
            Isotope::Ho148 => 148,
            Isotope::Ho149 => 149,
            Isotope::Ho150 => 150,
            Isotope::Ho151 => 151,
            Isotope::Ho152 => 152,
            Isotope::Ho153 => 153,
            Isotope::Ho154 => 154,
            Isotope::Ho155 => 155,
            Isotope::Ho156 => 156,
            Isotope::Ho157 => 157,
            Isotope::Ho158 => 158,
            Isotope::Ho159 => 159,
            Isotope::Ho160 => 160,
            Isotope::Ho161 => 161,
            Isotope::Ho162 => 162,
            Isotope::Ho163 => 163,
            Isotope::Ho164 => 164,
            Isotope::Ho165 => 165,
            Isotope::Ho166 => 166,
            Isotope::Ho167 => 167,
            Isotope::Ho168 => 168,
            Isotope::Ho169 => 169,
            Isotope::Ho170 => 170,
            Isotope::Ho171 => 171,
            Isotope::Ho172 => 172,
            Isotope::Ho173 => 173,
            Isotope::Ho174 => 174,
            Isotope::Ho175 => 175,
            Isotope::Ho176 => 176,
            Isotope::Ho177 => 177,
            Isotope::Ho178 => 178,
            Isotope::Er142 => 142,
            Isotope::Er143 => 143,
            Isotope::Er144 => 144,
            Isotope::Er145 => 145,
            Isotope::Er146 => 146,
            Isotope::Er147 => 147,
            Isotope::Er148 => 148,
            Isotope::Er149 => 149,
            Isotope::Er150 => 150,
            Isotope::Er151 => 151,
            Isotope::Er152 => 152,
            Isotope::Er153 => 153,
            Isotope::Er154 => 154,
            Isotope::Er155 => 155,
            Isotope::Er156 => 156,
            Isotope::Er157 => 157,
            Isotope::Er158 => 158,
            Isotope::Er159 => 159,
            Isotope::Er160 => 160,
            Isotope::Er161 => 161,
            Isotope::Er162 => 162,
            Isotope::Er163 => 163,
            Isotope::Er164 => 164,
            Isotope::Er165 => 165,
            Isotope::Er166 => 166,
            Isotope::Er167 => 167,
            Isotope::Er168 => 168,
            Isotope::Er169 => 169,
            Isotope::Er170 => 170,
            Isotope::Er171 => 171,
            Isotope::Er172 => 172,
            Isotope::Er173 => 173,
            Isotope::Er174 => 174,
            Isotope::Er175 => 175,
            Isotope::Er176 => 176,
            Isotope::Er177 => 177,
            Isotope::Er178 => 178,
            Isotope::Er179 => 179,
            Isotope::Er180 => 180,
            Isotope::Tm144 => 144,
            Isotope::Tm145 => 145,
            Isotope::Tm146 => 146,
            Isotope::Tm147 => 147,
            Isotope::Tm148 => 148,
            Isotope::Tm149 => 149,
            Isotope::Tm150 => 150,
            Isotope::Tm151 => 151,
            Isotope::Tm152 => 152,
            Isotope::Tm153 => 153,
            Isotope::Tm154 => 154,
            Isotope::Tm155 => 155,
            Isotope::Tm156 => 156,
            Isotope::Tm157 => 157,
            Isotope::Tm158 => 158,
            Isotope::Tm159 => 159,
            Isotope::Tm160 => 160,
            Isotope::Tm161 => 161,
            Isotope::Tm162 => 162,
            Isotope::Tm163 => 163,
            Isotope::Tm164 => 164,
            Isotope::Tm165 => 165,
            Isotope::Tm166 => 166,
            Isotope::Tm167 => 167,
            Isotope::Tm168 => 168,
            Isotope::Tm169 => 169,
            Isotope::Tm170 => 170,
            Isotope::Tm171 => 171,
            Isotope::Tm172 => 172,
            Isotope::Tm173 => 173,
            Isotope::Tm174 => 174,
            Isotope::Tm175 => 175,
            Isotope::Tm176 => 176,
            Isotope::Tm177 => 177,
            Isotope::Tm178 => 178,
            Isotope::Tm179 => 179,
            Isotope::Tm180 => 180,
            Isotope::Tm181 => 181,
            Isotope::Tm182 => 182,
            Isotope::Yb148 => 148,
            Isotope::Yb149 => 149,
            Isotope::Yb150 => 150,
            Isotope::Yb151 => 151,
            Isotope::Yb152 => 152,
            Isotope::Yb153 => 153,
            Isotope::Yb154 => 154,
            Isotope::Yb155 => 155,
            Isotope::Yb156 => 156,
            Isotope::Yb157 => 157,
            Isotope::Yb158 => 158,
            Isotope::Yb159 => 159,
            Isotope::Yb160 => 160,
            Isotope::Yb161 => 161,
            Isotope::Yb162 => 162,
            Isotope::Yb163 => 163,
            Isotope::Yb164 => 164,
            Isotope::Yb165 => 165,
            Isotope::Yb166 => 166,
            Isotope::Yb167 => 167,
            Isotope::Yb168 => 168,
            Isotope::Yb169 => 169,
            Isotope::Yb170 => 170,
            Isotope::Yb171 => 171,
            Isotope::Yb172 => 172,
            Isotope::Yb173 => 173,
            Isotope::Yb174 => 174,
            Isotope::Yb175 => 175,
            Isotope::Yb176 => 176,
            Isotope::Yb177 => 177,
            Isotope::Yb178 => 178,
            Isotope::Yb179 => 179,
            Isotope::Yb180 => 180,
            Isotope::Yb181 => 181,
            Isotope::Yb182 => 182,
            Isotope::Yb183 => 183,
            Isotope::Yb184 => 184,
            Isotope::Yb185 => 185,
            Isotope::Lu150 => 150,
            Isotope::Lu151 => 151,
            Isotope::Lu152 => 152,
            Isotope::Lu153 => 153,
            Isotope::Lu154 => 154,
            Isotope::Lu155 => 155,
            Isotope::Lu156 => 156,
            Isotope::Lu157 => 157,
            Isotope::Lu158 => 158,
            Isotope::Lu159 => 159,
            Isotope::Lu160 => 160,
            Isotope::Lu161 => 161,
            Isotope::Lu162 => 162,
            Isotope::Lu163 => 163,
            Isotope::Lu164 => 164,
            Isotope::Lu165 => 165,
            Isotope::Lu166 => 166,
            Isotope::Lu167 => 167,
            Isotope::Lu168 => 168,
            Isotope::Lu169 => 169,
            Isotope::Lu170 => 170,
            Isotope::Lu171 => 171,
            Isotope::Lu172 => 172,
            Isotope::Lu173 => 173,
            Isotope::Lu174 => 174,
            Isotope::Lu175 => 175,
            Isotope::Lu176 => 176,
            Isotope::Lu177 => 177,
            Isotope::Lu178 => 178,
            Isotope::Lu179 => 179,
            Isotope::Lu180 => 180,
            Isotope::Lu181 => 181,
            Isotope::Lu182 => 182,
            Isotope::Lu183 => 183,
            Isotope::Lu184 => 184,
            Isotope::Lu185 => 185,
            Isotope::Lu186 => 186,
            Isotope::Lu187 => 187,
            Isotope::Lu188 => 188,
            Isotope::Hf153 => 153,
            Isotope::Hf154 => 154,
            Isotope::Hf155 => 155,
            Isotope::Hf156 => 156,
            Isotope::Hf157 => 157,
            Isotope::Hf158 => 158,
            Isotope::Hf159 => 159,
            Isotope::Hf160 => 160,
            Isotope::Hf161 => 161,
            Isotope::Hf162 => 162,
            Isotope::Hf163 => 163,
            Isotope::Hf164 => 164,
            Isotope::Hf165 => 165,
            Isotope::Hf166 => 166,
            Isotope::Hf167 => 167,
            Isotope::Hf168 => 168,
            Isotope::Hf169 => 169,
            Isotope::Hf170 => 170,
            Isotope::Hf171 => 171,
            Isotope::Hf172 => 172,
            Isotope::Hf173 => 173,
            Isotope::Hf174 => 174,
            Isotope::Hf175 => 175,
            Isotope::Hf176 => 176,
            Isotope::Hf177 => 177,
            Isotope::Hf178 => 178,
            Isotope::Hf179 => 179,
            Isotope::Hf180 => 180,
            Isotope::Hf181 => 181,
            Isotope::Hf182 => 182,
            Isotope::Hf183 => 183,
            Isotope::Hf184 => 184,
            Isotope::Hf185 => 185,
            Isotope::Hf186 => 186,
            Isotope::Hf187 => 187,
            Isotope::Hf188 => 188,
            Isotope::Hf189 => 189,
            Isotope::Hf190 => 190,
            Isotope::Ta155 => 155,
            Isotope::Ta156 => 156,
            Isotope::Ta157 => 157,
            Isotope::Ta158 => 158,
            Isotope::Ta159 => 159,
            Isotope::Ta160 => 160,
            Isotope::Ta161 => 161,
            Isotope::Ta162 => 162,
            Isotope::Ta163 => 163,
            Isotope::Ta164 => 164,
            Isotope::Ta165 => 165,
            Isotope::Ta166 => 166,
            Isotope::Ta167 => 167,
            Isotope::Ta168 => 168,
            Isotope::Ta169 => 169,
            Isotope::Ta170 => 170,
            Isotope::Ta171 => 171,
            Isotope::Ta172 => 172,
            Isotope::Ta173 => 173,
            Isotope::Ta174 => 174,
            Isotope::Ta175 => 175,
            Isotope::Ta176 => 176,
            Isotope::Ta177 => 177,
            Isotope::Ta178 => 178,
            Isotope::Ta179 => 179,
            Isotope::Ta180 => 180,
            Isotope::Ta181 => 181,
            Isotope::Ta182 => 182,
            Isotope::Ta183 => 183,
            Isotope::Ta184 => 184,
            Isotope::Ta185 => 185,
            Isotope::Ta186 => 186,
            Isotope::Ta187 => 187,
            Isotope::Ta188 => 188,
            Isotope::Ta189 => 189,
            Isotope::Ta190 => 190,
            Isotope::Ta191 => 191,
            Isotope::Ta192 => 192,
            Isotope::Ta193 => 193,
            Isotope::Ta194 => 194,
            Isotope::W157 => 157,
            Isotope::W158 => 158,
            Isotope::W159 => 159,
            Isotope::W160 => 160,
            Isotope::W161 => 161,
            Isotope::W162 => 162,
            Isotope::W163 => 163,
            Isotope::W164 => 164,
            Isotope::W165 => 165,
            Isotope::W166 => 166,
            Isotope::W167 => 167,
            Isotope::W168 => 168,
            Isotope::W169 => 169,
            Isotope::W170 => 170,
            Isotope::W171 => 171,
            Isotope::W172 => 172,
            Isotope::W173 => 173,
            Isotope::W174 => 174,
            Isotope::W175 => 175,
            Isotope::W176 => 176,
            Isotope::W177 => 177,
            Isotope::W178 => 178,
            Isotope::W179 => 179,
            Isotope::W180 => 180,
            Isotope::W181 => 181,
            Isotope::W182 => 182,
            Isotope::W183 => 183,
            Isotope::W184 => 184,
            Isotope::W185 => 185,
            Isotope::W186 => 186,
            Isotope::W187 => 187,
            Isotope::W188 => 188,
            Isotope::W189 => 189,
            Isotope::W190 => 190,
            Isotope::W191 => 191,
            Isotope::W192 => 192,
            Isotope::W193 => 193,
            Isotope::W194 => 194,
            Isotope::W195 => 195,
            Isotope::W196 => 196,
            Isotope::W197 => 197,
            Isotope::Re159 => 159,
            Isotope::Re160 => 160,
            Isotope::Re161 => 161,
            Isotope::Re162 => 162,
            Isotope::Re163 => 163,
            Isotope::Re164 => 164,
            Isotope::Re165 => 165,
            Isotope::Re166 => 166,
            Isotope::Re167 => 167,
            Isotope::Re168 => 168,
            Isotope::Re169 => 169,
            Isotope::Re170 => 170,
            Isotope::Re171 => 171,
            Isotope::Re172 => 172,
            Isotope::Re173 => 173,
            Isotope::Re174 => 174,
            Isotope::Re175 => 175,
            Isotope::Re176 => 176,
            Isotope::Re177 => 177,
            Isotope::Re178 => 178,
            Isotope::Re179 => 179,
            Isotope::Re180 => 180,
            Isotope::Re181 => 181,
            Isotope::Re182 => 182,
            Isotope::Re183 => 183,
            Isotope::Re184 => 184,
            Isotope::Re185 => 185,
            Isotope::Re186 => 186,
            Isotope::Re187 => 187,
            Isotope::Re188 => 188,
            Isotope::Re189 => 189,
            Isotope::Re190 => 190,
            Isotope::Re191 => 191,
            Isotope::Re192 => 192,
            Isotope::Re193 => 193,
            Isotope::Re194 => 194,
            Isotope::Re195 => 195,
            Isotope::Re196 => 196,
            Isotope::Re197 => 197,
            Isotope::Re198 => 198,
            Isotope::Re199 => 199,
            Isotope::Os161 => 161,
            Isotope::Os162 => 162,
            Isotope::Os163 => 163,
            Isotope::Os164 => 164,
            Isotope::Os165 => 165,
            Isotope::Os166 => 166,
            Isotope::Os167 => 167,
            Isotope::Os168 => 168,
            Isotope::Os169 => 169,
            Isotope::Os170 => 170,
            Isotope::Os171 => 171,
            Isotope::Os172 => 172,
            Isotope::Os173 => 173,
            Isotope::Os174 => 174,
            Isotope::Os175 => 175,
            Isotope::Os176 => 176,
            Isotope::Os177 => 177,
            Isotope::Os178 => 178,
            Isotope::Os179 => 179,
            Isotope::Os180 => 180,
            Isotope::Os181 => 181,
            Isotope::Os182 => 182,
            Isotope::Os183 => 183,
            Isotope::Os184 => 184,
            Isotope::Os185 => 185,
            Isotope::Os186 => 186,
            Isotope::Os187 => 187,
            Isotope::Os188 => 188,
            Isotope::Os189 => 189,
            Isotope::Os190 => 190,
            Isotope::Os191 => 191,
            Isotope::Os192 => 192,
            Isotope::Os193 => 193,
            Isotope::Os194 => 194,
            Isotope::Os195 => 195,
            Isotope::Os196 => 196,
            Isotope::Os197 => 197,
            Isotope::Os198 => 198,
            Isotope::Os199 => 199,
            Isotope::Os200 => 200,
            Isotope::Os201 => 201,
            Isotope::Os202 => 202,
            Isotope::Os203 => 203,
            Isotope::Ir163 => 163,
            Isotope::Ir164 => 164,
            Isotope::Ir165 => 165,
            Isotope::Ir166 => 166,
            Isotope::Ir167 => 167,
            Isotope::Ir168 => 168,
            Isotope::Ir169 => 169,
            Isotope::Ir170 => 170,
            Isotope::Ir171 => 171,
            Isotope::Ir172 => 172,
            Isotope::Ir173 => 173,
            Isotope::Ir174 => 174,
            Isotope::Ir175 => 175,
            Isotope::Ir176 => 176,
            Isotope::Ir177 => 177,
            Isotope::Ir178 => 178,
            Isotope::Ir179 => 179,
            Isotope::Ir180 => 180,
            Isotope::Ir181 => 181,
            Isotope::Ir182 => 182,
            Isotope::Ir183 => 183,
            Isotope::Ir184 => 184,
            Isotope::Ir185 => 185,
            Isotope::Ir186 => 186,
            Isotope::Ir187 => 187,
            Isotope::Ir188 => 188,
            Isotope::Ir189 => 189,
            Isotope::Ir190 => 190,
            Isotope::Ir191 => 191,
            Isotope::Ir192 => 192,
            Isotope::Ir193 => 193,
            Isotope::Ir194 => 194,
            Isotope::Ir195 => 195,
            Isotope::Ir196 => 196,
            Isotope::Ir197 => 197,
            Isotope::Ir198 => 198,
            Isotope::Ir199 => 199,
            Isotope::Ir200 => 200,
            Isotope::Ir201 => 201,
            Isotope::Ir202 => 202,
            Isotope::Ir203 => 203,
            Isotope::Ir204 => 204,
            Isotope::Ir205 => 205,
            Isotope::Pt165 => 165,
            Isotope::Pt166 => 166,
            Isotope::Pt167 => 167,
            Isotope::Pt168 => 168,
            Isotope::Pt169 => 169,
            Isotope::Pt170 => 170,
            Isotope::Pt171 => 171,
            Isotope::Pt172 => 172,
            Isotope::Pt173 => 173,
            Isotope::Pt174 => 174,
            Isotope::Pt175 => 175,
            Isotope::Pt176 => 176,
            Isotope::Pt177 => 177,
            Isotope::Pt178 => 178,
            Isotope::Pt179 => 179,
            Isotope::Pt180 => 180,
            Isotope::Pt181 => 181,
            Isotope::Pt182 => 182,
            Isotope::Pt183 => 183,
            Isotope::Pt184 => 184,
            Isotope::Pt185 => 185,
            Isotope::Pt186 => 186,
            Isotope::Pt187 => 187,
            Isotope::Pt188 => 188,
            Isotope::Pt189 => 189,
            Isotope::Pt190 => 190,
            Isotope::Pt191 => 191,
            Isotope::Pt192 => 192,
            Isotope::Pt193 => 193,
            Isotope::Pt194 => 194,
            Isotope::Pt195 => 195,
            Isotope::Pt196 => 196,
            Isotope::Pt197 => 197,
            Isotope::Pt198 => 198,
            Isotope::Pt199 => 199,
            Isotope::Pt200 => 200,
            Isotope::Pt201 => 201,
            Isotope::Pt202 => 202,
            Isotope::Pt203 => 203,
            Isotope::Pt204 => 204,
            Isotope::Pt205 => 205,
            Isotope::Pt206 => 206,
            Isotope::Pt207 => 207,
            Isotope::Pt208 => 208,
            Isotope::Au168 => 168,
            Isotope::Au169 => 169,
            Isotope::Au170 => 170,
            Isotope::Au171 => 171,
            Isotope::Au172 => 172,
            Isotope::Au173 => 173,
            Isotope::Au174 => 174,
            Isotope::Au175 => 175,
            Isotope::Au176 => 176,
            Isotope::Au177 => 177,
            Isotope::Au178 => 178,
            Isotope::Au179 => 179,
            Isotope::Au180 => 180,
            Isotope::Au181 => 181,
            Isotope::Au182 => 182,
            Isotope::Au183 => 183,
            Isotope::Au184 => 184,
            Isotope::Au185 => 185,
            Isotope::Au186 => 186,
            Isotope::Au187 => 187,
            Isotope::Au188 => 188,
            Isotope::Au189 => 189,
            Isotope::Au190 => 190,
            Isotope::Au191 => 191,
            Isotope::Au192 => 192,
            Isotope::Au193 => 193,
            Isotope::Au194 => 194,
            Isotope::Au195 => 195,
            Isotope::Au196 => 196,
            Isotope::Au197 => 197,
            Isotope::Au198 => 198,
            Isotope::Au199 => 199,
            Isotope::Au200 => 200,
            Isotope::Au201 => 201,
            Isotope::Au202 => 202,
            Isotope::Au203 => 203,
            Isotope::Au204 => 204,
            Isotope::Au205 => 205,
            Isotope::Au206 => 206,
            Isotope::Au207 => 207,
            Isotope::Au208 => 208,
            Isotope::Au209 => 209,
            Isotope::Au210 => 210,
            Isotope::Hg170 => 170,
            Isotope::Hg171 => 171,
            Isotope::Hg172 => 172,
            Isotope::Hg173 => 173,
            Isotope::Hg174 => 174,
            Isotope::Hg175 => 175,
            Isotope::Hg176 => 176,
            Isotope::Hg177 => 177,
            Isotope::Hg178 => 178,
            Isotope::Hg179 => 179,
            Isotope::Hg180 => 180,
            Isotope::Hg181 => 181,
            Isotope::Hg182 => 182,
            Isotope::Hg183 => 183,
            Isotope::Hg184 => 184,
            Isotope::Hg185 => 185,
            Isotope::Hg186 => 186,
            Isotope::Hg187 => 187,
            Isotope::Hg188 => 188,
            Isotope::Hg189 => 189,
            Isotope::Hg190 => 190,
            Isotope::Hg191 => 191,
            Isotope::Hg192 => 192,
            Isotope::Hg193 => 193,
            Isotope::Hg194 => 194,
            Isotope::Hg195 => 195,
            Isotope::Hg196 => 196,
            Isotope::Hg197 => 197,
            Isotope::Hg198 => 198,
            Isotope::Hg199 => 199,
            Isotope::Hg200 => 200,
            Isotope::Hg201 => 201,
            Isotope::Hg202 => 202,
            Isotope::Hg203 => 203,
            Isotope::Hg204 => 204,
            Isotope::Hg205 => 205,
            Isotope::Hg206 => 206,
            Isotope::Hg207 => 207,
            Isotope::Hg208 => 208,
            Isotope::Hg209 => 209,
            Isotope::Hg210 => 210,
            Isotope::Hg211 => 211,
            Isotope::Hg212 => 212,
            Isotope::Hg213 => 213,
            Isotope::Hg214 => 214,
            Isotope::Hg215 => 215,
            Isotope::Hg216 => 216,
            Isotope::Tl176 => 176,
            Isotope::Tl177 => 177,
            Isotope::Tl178 => 178,
            Isotope::Tl179 => 179,
            Isotope::Tl180 => 180,
            Isotope::Tl181 => 181,
            Isotope::Tl182 => 182,
            Isotope::Tl183 => 183,
            Isotope::Tl184 => 184,
            Isotope::Tl185 => 185,
            Isotope::Tl186 => 186,
            Isotope::Tl187 => 187,
            Isotope::Tl188 => 188,
            Isotope::Tl189 => 189,
            Isotope::Tl190 => 190,
            Isotope::Tl191 => 191,
            Isotope::Tl192 => 192,
            Isotope::Tl193 => 193,
            Isotope::Tl194 => 194,
            Isotope::Tl195 => 195,
            Isotope::Tl196 => 196,
            Isotope::Tl197 => 197,
            Isotope::Tl198 => 198,
            Isotope::Tl199 => 199,
            Isotope::Tl200 => 200,
            Isotope::Tl201 => 201,
            Isotope::Tl202 => 202,
            Isotope::Tl203 => 203,
            Isotope::Tl204 => 204,
            Isotope::Tl205 => 205,
            Isotope::Tl206 => 206,
            Isotope::Tl207 => 207,
            Isotope::Tl208 => 208,
            Isotope::Tl209 => 209,
            Isotope::Tl210 => 210,
            Isotope::Tl211 => 211,
            Isotope::Tl212 => 212,
            Isotope::Tl213 => 213,
            Isotope::Tl214 => 214,
            Isotope::Tl215 => 215,
            Isotope::Tl216 => 216,
            Isotope::Tl217 => 217,
            Isotope::Tl218 => 218,
            Isotope::Pb178 => 178,
            Isotope::Pb179 => 179,
            Isotope::Pb180 => 180,
            Isotope::Pb181 => 181,
            Isotope::Pb182 => 182,
            Isotope::Pb183 => 183,
            Isotope::Pb184 => 184,
            Isotope::Pb185 => 185,
            Isotope::Pb186 => 186,
            Isotope::Pb187 => 187,
            Isotope::Pb188 => 188,
            Isotope::Pb189 => 189,
            Isotope::Pb190 => 190,
            Isotope::Pb191 => 191,
            Isotope::Pb192 => 192,
            Isotope::Pb193 => 193,
            Isotope::Pb194 => 194,
            Isotope::Pb195 => 195,
            Isotope::Pb196 => 196,
            Isotope::Pb197 => 197,
            Isotope::Pb198 => 198,
            Isotope::Pb199 => 199,
            Isotope::Pb200 => 200,
            Isotope::Pb201 => 201,
            Isotope::Pb202 => 202,
            Isotope::Pb203 => 203,
            Isotope::Pb204 => 204,
            Isotope::Pb205 => 205,
            Isotope::Pb206 => 206,
            Isotope::Pb207 => 207,
            Isotope::Pb208 => 208,
            Isotope::Pb209 => 209,
            Isotope::Pb210 => 210,
            Isotope::Pb211 => 211,
            Isotope::Pb212 => 212,
            Isotope::Pb213 => 213,
            Isotope::Pb214 => 214,
            Isotope::Pb215 => 215,
            Isotope::Pb216 => 216,
            Isotope::Pb217 => 217,
            Isotope::Pb218 => 218,
            Isotope::Pb219 => 219,
            Isotope::Pb220 => 220,
            Isotope::Bi184 => 184,
            Isotope::Bi185 => 185,
            Isotope::Bi186 => 186,
            Isotope::Bi187 => 187,
            Isotope::Bi188 => 188,
            Isotope::Bi189 => 189,
            Isotope::Bi190 => 190,
            Isotope::Bi191 => 191,
            Isotope::Bi192 => 192,
            Isotope::Bi193 => 193,
            Isotope::Bi194 => 194,
            Isotope::Bi195 => 195,
            Isotope::Bi196 => 196,
            Isotope::Bi197 => 197,
            Isotope::Bi198 => 198,
            Isotope::Bi199 => 199,
            Isotope::Bi200 => 200,
            Isotope::Bi201 => 201,
            Isotope::Bi202 => 202,
            Isotope::Bi203 => 203,
            Isotope::Bi204 => 204,
            Isotope::Bi205 => 205,
            Isotope::Bi206 => 206,
            Isotope::Bi207 => 207,
            Isotope::Bi208 => 208,
            Isotope::Bi209 => 209,
            Isotope::Bi210 => 210,
            Isotope::Bi211 => 211,
            Isotope::Bi212 => 212,
            Isotope::Bi213 => 213,
            Isotope::Bi214 => 214,
            Isotope::Bi215 => 215,
            Isotope::Bi216 => 216,
            Isotope::Bi217 => 217,
            Isotope::Bi218 => 218,
            Isotope::Bi219 => 219,
            Isotope::Bi220 => 220,
            Isotope::Bi221 => 221,
            Isotope::Bi222 => 222,
            Isotope::Bi223 => 223,
            Isotope::Bi224 => 224,
            Isotope::Po186 => 186,
            Isotope::Po187 => 187,
            Isotope::Po188 => 188,
            Isotope::Po189 => 189,
            Isotope::Po190 => 190,
            Isotope::Po191 => 191,
            Isotope::Po192 => 192,
            Isotope::Po193 => 193,
            Isotope::Po194 => 194,
            Isotope::Po195 => 195,
            Isotope::Po196 => 196,
            Isotope::Po197 => 197,
            Isotope::Po198 => 198,
            Isotope::Po199 => 199,
            Isotope::Po200 => 200,
            Isotope::Po201 => 201,
            Isotope::Po202 => 202,
            Isotope::Po203 => 203,
            Isotope::Po204 => 204,
            Isotope::Po205 => 205,
            Isotope::Po206 => 206,
            Isotope::Po207 => 207,
            Isotope::Po208 => 208,
            Isotope::Po209 => 209,
            Isotope::Po210 => 210,
            Isotope::Po211 => 211,
            Isotope::Po212 => 212,
            Isotope::Po213 => 213,
            Isotope::Po214 => 214,
            Isotope::Po215 => 215,
            Isotope::Po216 => 216,
            Isotope::Po217 => 217,
            Isotope::Po218 => 218,
            Isotope::Po219 => 219,
            Isotope::Po220 => 220,
            Isotope::Po221 => 221,
            Isotope::Po222 => 222,
            Isotope::Po223 => 223,
            Isotope::Po224 => 224,
            Isotope::Po225 => 225,
            Isotope::Po226 => 226,
            Isotope::Po227 => 227,
            Isotope::At191 => 191,
            Isotope::At192 => 192,
            Isotope::At193 => 193,
            Isotope::At194 => 194,
            Isotope::At195 => 195,
            Isotope::At196 => 196,
            Isotope::At197 => 197,
            Isotope::At198 => 198,
            Isotope::At199 => 199,
            Isotope::At200 => 200,
            Isotope::At201 => 201,
            Isotope::At202 => 202,
            Isotope::At203 => 203,
            Isotope::At204 => 204,
            Isotope::At205 => 205,
            Isotope::At206 => 206,
            Isotope::At207 => 207,
            Isotope::At208 => 208,
            Isotope::At209 => 209,
            Isotope::At210 => 210,
            Isotope::At211 => 211,
            Isotope::At212 => 212,
            Isotope::At213 => 213,
            Isotope::At214 => 214,
            Isotope::At215 => 215,
            Isotope::At216 => 216,
            Isotope::At217 => 217,
            Isotope::At218 => 218,
            Isotope::At219 => 219,
            Isotope::At220 => 220,
            Isotope::At221 => 221,
            Isotope::At222 => 222,
            Isotope::At223 => 223,
            Isotope::At224 => 224,
            Isotope::At225 => 225,
            Isotope::At226 => 226,
            Isotope::At227 => 227,
            Isotope::At228 => 228,
            Isotope::At229 => 229,
            Isotope::Rn193 => 193,
            Isotope::Rn194 => 194,
            Isotope::Rn195 => 195,
            Isotope::Rn196 => 196,
            Isotope::Rn197 => 197,
            Isotope::Rn198 => 198,
            Isotope::Rn199 => 199,
            Isotope::Rn200 => 200,
            Isotope::Rn201 => 201,
            Isotope::Rn202 => 202,
            Isotope::Rn203 => 203,
            Isotope::Rn204 => 204,
            Isotope::Rn205 => 205,
            Isotope::Rn206 => 206,
            Isotope::Rn207 => 207,
            Isotope::Rn208 => 208,
            Isotope::Rn209 => 209,
            Isotope::Rn210 => 210,
            Isotope::Rn211 => 211,
            Isotope::Rn212 => 212,
            Isotope::Rn213 => 213,
            Isotope::Rn214 => 214,
            Isotope::Rn215 => 215,
            Isotope::Rn216 => 216,
            Isotope::Rn217 => 217,
            Isotope::Rn218 => 218,
            Isotope::Rn219 => 219,
            Isotope::Rn220 => 220,
            Isotope::Rn221 => 221,
            Isotope::Rn222 => 222,
            Isotope::Rn223 => 223,
            Isotope::Rn224 => 224,
            Isotope::Rn225 => 225,
            Isotope::Rn226 => 226,
            Isotope::Rn227 => 227,
            Isotope::Rn228 => 228,
            Isotope::Rn229 => 229,
            Isotope::Rn230 => 230,
            Isotope::Rn231 => 231,
            Isotope::Fr197 => 197,
            Isotope::Fr198 => 198,
            Isotope::Fr199 => 199,
            Isotope::Fr200 => 200,
            Isotope::Fr201 => 201,
            Isotope::Fr202 => 202,
            Isotope::Fr203 => 203,
            Isotope::Fr204 => 204,
            Isotope::Fr205 => 205,
            Isotope::Fr206 => 206,
            Isotope::Fr207 => 207,
            Isotope::Fr208 => 208,
            Isotope::Fr209 => 209,
            Isotope::Fr210 => 210,
            Isotope::Fr211 => 211,
            Isotope::Fr212 => 212,
            Isotope::Fr213 => 213,
            Isotope::Fr214 => 214,
            Isotope::Fr215 => 215,
            Isotope::Fr216 => 216,
            Isotope::Fr217 => 217,
            Isotope::Fr218 => 218,
            Isotope::Fr219 => 219,
            Isotope::Fr220 => 220,
            Isotope::Fr221 => 221,
            Isotope::Fr222 => 222,
            Isotope::Fr223 => 223,
            Isotope::Fr224 => 224,
            Isotope::Fr225 => 225,
            Isotope::Fr226 => 226,
            Isotope::Fr227 => 227,
            Isotope::Fr228 => 228,
            Isotope::Fr229 => 229,
            Isotope::Fr230 => 230,
            Isotope::Fr231 => 231,
            Isotope::Fr232 => 232,
            Isotope::Fr233 => 233,
            Isotope::Ra201 => 201,
            Isotope::Ra202 => 202,
            Isotope::Ra203 => 203,
            Isotope::Ra204 => 204,
            Isotope::Ra205 => 205,
            Isotope::Ra206 => 206,
            Isotope::Ra207 => 207,
            Isotope::Ra208 => 208,
            Isotope::Ra209 => 209,
            Isotope::Ra210 => 210,
            Isotope::Ra211 => 211,
            Isotope::Ra212 => 212,
            Isotope::Ra213 => 213,
            Isotope::Ra214 => 214,
            Isotope::Ra215 => 215,
            Isotope::Ra216 => 216,
            Isotope::Ra217 => 217,
            Isotope::Ra218 => 218,
            Isotope::Ra219 => 219,
            Isotope::Ra220 => 220,
            Isotope::Ra221 => 221,
            Isotope::Ra222 => 222,
            Isotope::Ra223 => 223,
            Isotope::Ra224 => 224,
            Isotope::Ra225 => 225,
            Isotope::Ra226 => 226,
            Isotope::Ra227 => 227,
            Isotope::Ra228 => 228,
            Isotope::Ra229 => 229,
            Isotope::Ra230 => 230,
            Isotope::Ra231 => 231,
            Isotope::Ra232 => 232,
            Isotope::Ra233 => 233,
            Isotope::Ra234 => 234,
            Isotope::Ra235 => 235,
            Isotope::Ac205 => 205,
            Isotope::Ac206 => 206,
            Isotope::Ac207 => 207,
            Isotope::Ac208 => 208,
            Isotope::Ac209 => 209,
            Isotope::Ac210 => 210,
            Isotope::Ac211 => 211,
            Isotope::Ac212 => 212,
            Isotope::Ac213 => 213,
            Isotope::Ac214 => 214,
            Isotope::Ac215 => 215,
            Isotope::Ac216 => 216,
            Isotope::Ac217 => 217,
            Isotope::Ac218 => 218,
            Isotope::Ac219 => 219,
            Isotope::Ac220 => 220,
            Isotope::Ac221 => 221,
            Isotope::Ac222 => 222,
            Isotope::Ac223 => 223,
            Isotope::Ac224 => 224,
            Isotope::Ac225 => 225,
            Isotope::Ac226 => 226,
            Isotope::Ac227 => 227,
            Isotope::Ac228 => 228,
            Isotope::Ac229 => 229,
            Isotope::Ac230 => 230,
            Isotope::Ac231 => 231,
            Isotope::Ac232 => 232,
            Isotope::Ac233 => 233,
            Isotope::Ac234 => 234,
            Isotope::Ac235 => 235,
            Isotope::Ac236 => 236,
            Isotope::Ac237 => 237,
            Isotope::Th208 => 208,
            Isotope::Th209 => 209,
            Isotope::Th210 => 210,
            Isotope::Th211 => 211,
            Isotope::Th212 => 212,
            Isotope::Th213 => 213,
            Isotope::Th214 => 214,
            Isotope::Th215 => 215,
            Isotope::Th216 => 216,
            Isotope::Th217 => 217,
            Isotope::Th218 => 218,
            Isotope::Th219 => 219,
            Isotope::Th220 => 220,
            Isotope::Th221 => 221,
            Isotope::Th222 => 222,
            Isotope::Th223 => 223,
            Isotope::Th224 => 224,
            Isotope::Th225 => 225,
            Isotope::Th226 => 226,
            Isotope::Th227 => 227,
            Isotope::Th228 => 228,
            Isotope::Th229 => 229,
            Isotope::Th230 => 230,
            Isotope::Th231 => 231,
            Isotope::Th232 => 232,
            Isotope::Th233 => 233,
            Isotope::Th234 => 234,
            Isotope::Th235 => 235,
            Isotope::Th236 => 236,
            Isotope::Th237 => 237,
            Isotope::Th238 => 238,
            Isotope::Th239 => 239,
            Isotope::Pa211 => 211,
            Isotope::Pa212 => 212,
            Isotope::Pa213 => 213,
            Isotope::Pa214 => 214,
            Isotope::Pa215 => 215,
            Isotope::Pa216 => 216,
            Isotope::Pa217 => 217,
            Isotope::Pa218 => 218,
            Isotope::Pa219 => 219,
            Isotope::Pa220 => 220,
            Isotope::Pa221 => 221,
            Isotope::Pa222 => 222,
            Isotope::Pa223 => 223,
            Isotope::Pa224 => 224,
            Isotope::Pa225 => 225,
            Isotope::Pa226 => 226,
            Isotope::Pa227 => 227,
            Isotope::Pa228 => 228,
            Isotope::Pa229 => 229,
            Isotope::Pa230 => 230,
            Isotope::Pa231 => 231,
            Isotope::Pa232 => 232,
            Isotope::Pa233 => 233,
            Isotope::Pa234 => 234,
            Isotope::Pa235 => 235,
            Isotope::Pa236 => 236,
            Isotope::Pa237 => 237,
            Isotope::Pa238 => 238,
            Isotope::Pa239 => 239,
            Isotope::Pa240 => 240,
            Isotope::Pa241 => 241,
            Isotope::U215 => 215,
            Isotope::U216 => 216,
            Isotope::U217 => 217,
            Isotope::U218 => 218,
            Isotope::U219 => 219,
            Isotope::U220 => 220,
            Isotope::U221 => 221,
            Isotope::U222 => 222,
            Isotope::U223 => 223,
            Isotope::U224 => 224,
            Isotope::U225 => 225,
            Isotope::U226 => 226,
            Isotope::U227 => 227,
            Isotope::U228 => 228,
            Isotope::U229 => 229,
            Isotope::U230 => 230,
            Isotope::U231 => 231,
            Isotope::U232 => 232,
            Isotope::U233 => 233,
            Isotope::U234 => 234,
            Isotope::U235 => 235,
            Isotope::U236 => 236,
            Isotope::U237 => 237,
            Isotope::U238 => 238,
            Isotope::U239 => 239,
            Isotope::U240 => 240,
            Isotope::U241 => 241,
            Isotope::U242 => 242,
            Isotope::U243 => 243,
            Isotope::Np219 => 219,
            Isotope::Np220 => 220,
            Isotope::Np221 => 221,
            Isotope::Np222 => 222,
            Isotope::Np223 => 223,
            Isotope::Np224 => 224,
            Isotope::Np225 => 225,
            Isotope::Np226 => 226,
            Isotope::Np227 => 227,
            Isotope::Np228 => 228,
            Isotope::Np229 => 229,
            Isotope::Np230 => 230,
            Isotope::Np231 => 231,
            Isotope::Np232 => 232,
            Isotope::Np233 => 233,
            Isotope::Np234 => 234,
            Isotope::Np235 => 235,
            Isotope::Np236 => 236,
            Isotope::Np237 => 237,
            Isotope::Np238 => 238,
            Isotope::Np239 => 239,
            Isotope::Np240 => 240,
            Isotope::Np241 => 241,
            Isotope::Np242 => 242,
            Isotope::Np243 => 243,
            Isotope::Np244 => 244,
            Isotope::Np245 => 245,
            Isotope::Pu221 => 221,
            Isotope::Pu222 => 222,
            Isotope::Pu223 => 223,
            Isotope::Pu224 => 224,
            Isotope::Pu225 => 225,
            Isotope::Pu226 => 226,
            Isotope::Pu227 => 227,
            Isotope::Pu228 => 228,
            Isotope::Pu229 => 229,
            Isotope::Pu230 => 230,
            Isotope::Pu231 => 231,
            Isotope::Pu232 => 232,
            Isotope::Pu233 => 233,
            Isotope::Pu234 => 234,
            Isotope::Pu235 => 235,
            Isotope::Pu236 => 236,
            Isotope::Pu237 => 237,
            Isotope::Pu238 => 238,
            Isotope::Pu239 => 239,
            Isotope::Pu240 => 240,
            Isotope::Pu241 => 241,
            Isotope::Pu242 => 242,
            Isotope::Pu243 => 243,
            Isotope::Pu244 => 244,
            Isotope::Pu245 => 245,
            Isotope::Pu246 => 246,
            Isotope::Pu247 => 247,
            Isotope::Am223 => 223,
            Isotope::Am224 => 224,
            Isotope::Am225 => 225,
            Isotope::Am226 => 226,
            Isotope::Am227 => 227,
            Isotope::Am228 => 228,
            Isotope::Am229 => 229,
            Isotope::Am230 => 230,
            Isotope::Am231 => 231,
            Isotope::Am232 => 232,
            Isotope::Am233 => 233,
            Isotope::Am234 => 234,
            Isotope::Am235 => 235,
            Isotope::Am236 => 236,
            Isotope::Am237 => 237,
            Isotope::Am238 => 238,
            Isotope::Am239 => 239,
            Isotope::Am240 => 240,
            Isotope::Am241 => 241,
            Isotope::Am242 => 242,
            Isotope::Am243 => 243,
            Isotope::Am244 => 244,
            Isotope::Am245 => 245,
            Isotope::Am246 => 246,
            Isotope::Am247 => 247,
            Isotope::Am248 => 248,
            Isotope::Am249 => 249,
            Isotope::Cm231 => 231,
            Isotope::Cm232 => 232,
            Isotope::Cm233 => 233,
            Isotope::Cm234 => 234,
            Isotope::Cm235 => 235,
            Isotope::Cm236 => 236,
            Isotope::Cm237 => 237,
            Isotope::Cm238 => 238,
            Isotope::Cm239 => 239,
            Isotope::Cm240 => 240,
            Isotope::Cm241 => 241,
            Isotope::Cm242 => 242,
            Isotope::Cm243 => 243,
            Isotope::Cm244 => 244,
            Isotope::Cm245 => 245,
            Isotope::Cm246 => 246,
            Isotope::Cm247 => 247,
            Isotope::Cm248 => 248,
            Isotope::Cm249 => 249,
            Isotope::Cm250 => 250,
            Isotope::Cm251 => 251,
            Isotope::Cm252 => 252,
            Isotope::Bk233 => 233,
            Isotope::Bk234 => 234,
            Isotope::Bk235 => 235,
            Isotope::Bk236 => 236,
            Isotope::Bk237 => 237,
            Isotope::Bk238 => 238,
            Isotope::Bk239 => 239,
            Isotope::Bk240 => 240,
            Isotope::Bk241 => 241,
            Isotope::Bk242 => 242,
            Isotope::Bk243 => 243,
            Isotope::Bk244 => 244,
            Isotope::Bk245 => 245,
            Isotope::Bk246 => 246,
            Isotope::Bk247 => 247,
            Isotope::Bk248 => 248,
            Isotope::Bk249 => 249,
            Isotope::Bk250 => 250,
            Isotope::Bk251 => 251,
            Isotope::Bk252 => 252,
            Isotope::Bk253 => 253,
            Isotope::Bk254 => 254,
            Isotope::Cf237 => 237,
            Isotope::Cf238 => 238,
            Isotope::Cf239 => 239,
            Isotope::Cf240 => 240,
            Isotope::Cf241 => 241,
            Isotope::Cf242 => 242,
            Isotope::Cf243 => 243,
            Isotope::Cf244 => 244,
            Isotope::Cf245 => 245,
            Isotope::Cf246 => 246,
            Isotope::Cf247 => 247,
            Isotope::Cf248 => 248,
            Isotope::Cf249 => 249,
            Isotope::Cf250 => 250,
            Isotope::Cf251 => 251,
            Isotope::Cf252 => 252,
            Isotope::Cf253 => 253,
            Isotope::Cf254 => 254,
            Isotope::Cf255 => 255,
            Isotope::Cf256 => 256,
            Isotope::Es239 => 239,
            Isotope::Es240 => 240,
            Isotope::Es241 => 241,
            Isotope::Es242 => 242,
            Isotope::Es243 => 243,
            Isotope::Es244 => 244,
            Isotope::Es245 => 245,
            Isotope::Es246 => 246,
            Isotope::Es247 => 247,
            Isotope::Es248 => 248,
            Isotope::Es249 => 249,
            Isotope::Es250 => 250,
            Isotope::Es251 => 251,
            Isotope::Es252 => 252,
            Isotope::Es253 => 253,
            Isotope::Es254 => 254,
            Isotope::Es255 => 255,
            Isotope::Es256 => 256,
            Isotope::Es257 => 257,
            Isotope::Es258 => 258,
            Isotope::Fm241 => 241,
            Isotope::Fm242 => 242,
            Isotope::Fm243 => 243,
            Isotope::Fm244 => 244,
            Isotope::Fm245 => 245,
            Isotope::Fm246 => 246,
            Isotope::Fm247 => 247,
            Isotope::Fm248 => 248,
            Isotope::Fm249 => 249,
            Isotope::Fm250 => 250,
            Isotope::Fm251 => 251,
            Isotope::Fm252 => 252,
            Isotope::Fm253 => 253,
            Isotope::Fm254 => 254,
            Isotope::Fm255 => 255,
            Isotope::Fm256 => 256,
            Isotope::Fm257 => 257,
            Isotope::Fm258 => 258,
            Isotope::Fm259 => 259,
            Isotope::Fm260 => 260,
            Isotope::Md244 => 244,
            Isotope::Md245 => 245,
            Isotope::Md246 => 246,
            Isotope::Md247 => 247,
            Isotope::Md248 => 248,
            Isotope::Md249 => 249,
            Isotope::Md250 => 250,
            Isotope::Md251 => 251,
            Isotope::Md252 => 252,
            Isotope::Md253 => 253,
            Isotope::Md254 => 254,
            Isotope::Md255 => 255,
            Isotope::Md256 => 256,
            Isotope::Md257 => 257,
            Isotope::Md258 => 258,
            Isotope::Md259 => 259,
            Isotope::Md260 => 260,
            Isotope::Md261 => 261,
            Isotope::Md262 => 262,
            Isotope::No248 => 248,
            Isotope::No249 => 249,
            Isotope::No250 => 250,
            Isotope::No251 => 251,
            Isotope::No252 => 252,
            Isotope::No253 => 253,
            Isotope::No254 => 254,
            Isotope::No255 => 255,
            Isotope::No256 => 256,
            Isotope::No257 => 257,
            Isotope::No258 => 258,
            Isotope::No259 => 259,
            Isotope::No260 => 260,
            Isotope::No261 => 261,
            Isotope::No262 => 262,
            Isotope::No263 => 263,
            Isotope::No264 => 264,
            Isotope::Lr251 => 251,
            Isotope::Lr252 => 252,
            Isotope::Lr253 => 253,
            Isotope::Lr254 => 254,
            Isotope::Lr255 => 255,
            Isotope::Lr256 => 256,
            Isotope::Lr257 => 257,
            Isotope::Lr258 => 258,
            Isotope::Lr259 => 259,
            Isotope::Lr260 => 260,
            Isotope::Lr261 => 261,
            Isotope::Lr262 => 262,
            Isotope::Lr263 => 263,
            Isotope::Lr264 => 264,
            Isotope::Lr265 => 265,
            Isotope::Lr266 => 266,
            Isotope::Rf253 => 253,
            Isotope::Rf254 => 254,
            Isotope::Rf255 => 255,
            Isotope::Rf256 => 256,
            Isotope::Rf257 => 257,
            Isotope::Rf258 => 258,
            Isotope::Rf259 => 259,
            Isotope::Rf260 => 260,
            Isotope::Rf261 => 261,
            Isotope::Rf262 => 262,
            Isotope::Rf263 => 263,
            Isotope::Rf264 => 264,
            Isotope::Rf265 => 265,
            Isotope::Rf266 => 266,
            Isotope::Rf267 => 267,
            Isotope::Rf268 => 268,
            Isotope::Db255 => 255,
            Isotope::Db256 => 256,
            Isotope::Db257 => 257,
            Isotope::Db258 => 258,
            Isotope::Db259 => 259,
            Isotope::Db260 => 260,
            Isotope::Db261 => 261,
            Isotope::Db262 => 262,
            Isotope::Db263 => 263,
            Isotope::Db264 => 264,
            Isotope::Db265 => 265,
            Isotope::Db266 => 266,
            Isotope::Db267 => 267,
            Isotope::Db268 => 268,
            Isotope::Db269 => 269,
            Isotope::Db270 => 270,
            Isotope::Sg258 => 258,
            Isotope::Sg259 => 259,
            Isotope::Sg260 => 260,
            Isotope::Sg261 => 261,
            Isotope::Sg262 => 262,
            Isotope::Sg263 => 263,
            Isotope::Sg264 => 264,
            Isotope::Sg265 => 265,
            Isotope::Sg266 => 266,
            Isotope::Sg267 => 267,
            Isotope::Sg268 => 268,
            Isotope::Sg269 => 269,
            Isotope::Sg270 => 270,
            Isotope::Sg271 => 271,
            Isotope::Sg272 => 272,
            Isotope::Sg273 => 273,
            Isotope::Bh260 => 260,
            Isotope::Bh261 => 261,
            Isotope::Bh262 => 262,
            Isotope::Bh263 => 263,
            Isotope::Bh264 => 264,
            Isotope::Bh265 => 265,
            Isotope::Bh266 => 266,
            Isotope::Bh267 => 267,
            Isotope::Bh268 => 268,
            Isotope::Bh269 => 269,
            Isotope::Bh270 => 270,
            Isotope::Bh271 => 271,
            Isotope::Bh272 => 272,
            Isotope::Bh273 => 273,
            Isotope::Bh274 => 274,
            Isotope::Bh275 => 275,
            Isotope::Bh276 => 276,
            Isotope::Bh277 => 277,
            Isotope::Bh278 => 278,
            Isotope::Hs263 => 263,
            Isotope::Hs264 => 264,
            Isotope::Hs265 => 265,
            Isotope::Hs266 => 266,
            Isotope::Hs267 => 267,
            Isotope::Hs268 => 268,
            Isotope::Hs269 => 269,
            Isotope::Hs270 => 270,
            Isotope::Hs271 => 271,
            Isotope::Hs272 => 272,
            Isotope::Hs273 => 273,
            Isotope::Hs274 => 274,
            Isotope::Hs275 => 275,
            Isotope::Hs276 => 276,
            Isotope::Hs277 => 277,
            Isotope::Hs278 => 278,
            Isotope::Hs279 => 279,
            Isotope::Hs280 => 280,
            Isotope::Mt265 => 265,
            Isotope::Mt266 => 266,
            Isotope::Mt267 => 267,
            Isotope::Mt268 => 268,
            Isotope::Mt269 => 269,
            Isotope::Mt270 => 270,
            Isotope::Mt271 => 271,
            Isotope::Mt272 => 272,
            Isotope::Mt273 => 273,
            Isotope::Mt274 => 274,
            Isotope::Mt275 => 275,
            Isotope::Mt276 => 276,
            Isotope::Mt277 => 277,
            Isotope::Mt278 => 278,
            Isotope::Mt279 => 279,
            Isotope::Mt280 => 280,
            Isotope::Mt281 => 281,
            Isotope::Mt282 => 282,
            Isotope::Ds267 => 267,
            Isotope::Ds268 => 268,
            Isotope::Ds269 => 269,
            Isotope::Ds270 => 270,
            Isotope::Ds271 => 271,
            Isotope::Ds272 => 272,
            Isotope::Ds273 => 273,
            Isotope::Ds274 => 274,
            Isotope::Ds275 => 275,
            Isotope::Ds276 => 276,
            Isotope::Ds277 => 277,
            Isotope::Ds278 => 278,
            Isotope::Ds279 => 279,
            Isotope::Ds280 => 280,
            Isotope::Ds281 => 281,
            Isotope::Ds282 => 282,
            Isotope::Ds283 => 283,
            Isotope::Ds284 => 284,
            Isotope::Rg272 => 272,
            Isotope::Rg273 => 273,
            Isotope::Rg274 => 274,
            Isotope::Rg275 => 275,
            Isotope::Rg276 => 276,
            Isotope::Rg277 => 277,
            Isotope::Rg278 => 278,
            Isotope::Rg279 => 279,
            Isotope::Rg280 => 280,
            Isotope::Rg281 => 281,
            Isotope::Rg282 => 282,
            Isotope::Rg283 => 283,
            Isotope::Rg284 => 284,
            Isotope::Rg285 => 285,
            Isotope::Rg286 => 286,
            Isotope::Cn276 => 276,
            Isotope::Cn277 => 277,
            Isotope::Cn278 => 278,
            Isotope::Cn279 => 279,
            Isotope::Cn280 => 280,
            Isotope::Cn281 => 281,
            Isotope::Cn282 => 282,
            Isotope::Cn283 => 283,
            Isotope::Cn284 => 284,
            Isotope::Cn285 => 285,
            Isotope::Cn286 => 286,
            Isotope::Cn287 => 287,
            Isotope::Cn288 => 288,
            Isotope::Nh278 => 278,
            Isotope::Nh279 => 279,
            Isotope::Nh280 => 280,
            Isotope::Nh281 => 281,
            Isotope::Nh282 => 282,
            Isotope::Nh283 => 283,
            Isotope::Nh284 => 284,
            Isotope::Nh285 => 285,
            Isotope::Nh286 => 286,
            Isotope::Nh287 => 287,
            Isotope::Nh288 => 288,
            Isotope::Nh289 => 289,
            Isotope::Nh290 => 290,
            Isotope::Fl284 => 284,
            Isotope::Fl285 => 285,
            Isotope::Fl286 => 286,
            Isotope::Fl287 => 287,
            Isotope::Fl288 => 288,
            Isotope::Fl289 => 289,
            Isotope::Fl290 => 290,
            Isotope::Fl291 => 291,
            Isotope::Mc287 => 287,
            Isotope::Mc288 => 288,
            Isotope::Mc289 => 289,
            Isotope::Mc290 => 290,
            Isotope::Mc291 => 291,
            Isotope::Mc292 => 292,
            Isotope::Lv289 => 289,
            Isotope::Lv290 => 290,
            Isotope::Lv291 => 291,
            Isotope::Lv292 => 292,
            Isotope::Lv293 => 293,
            Isotope::Ts291 => 291,
            Isotope::Ts292 => 292,
            Isotope::Ts293 => 293,
            Isotope::Ts294 => 294,
            Isotope::Og293 => 293,
            Isotope::Og294 => 294,
            Isotope::Og295 => 295,
        }
    }
}
