/*
 * Copyright © 2025 UBports Foundation
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Alfred Neumayer <dev.beidl@gmail.com>
 */

#pragma once

#include "src/core/performance_booster.h"

#include <memory>
#include <string>
#include <thread>

namespace repowerd
{

class Log;

class QtiPerfPerformanceBooster : public PerformanceBooster
{
public:
    QtiPerfPerformanceBooster(std::shared_ptr<Log> const& log);
    ~QtiPerfPerformanceBooster();

    void set_performance_mode(PerformanceMode mode) override;

    std::shared_ptr<Log> const log;

private:
    void release_sustained();
    void release_interactive();
    void release_low_power();
    void hint_sustained();
    void hint_interactive();
    void hint_low_power();

    void* dlhandle;
    // Function signatures taken from: https://github.com/DerpFest-AOSP/vendor_qcom_opensource_power/blob/15/utils.c#L65
    int (*perf_lock_rel)(unsigned long);
    int (*perf_hint)(int, const char*, int, int);

    int sustained_lock_handle;
    int interaction_lock_handle;
    int low_power_lock_handle;
};

}
