% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/num_to_fac.R
\name{numeric_to_factor}
\alias{numeric_to_factor}
\title{Convert numeric vectors into factors associated value labels}
\usage{
numeric_to_factor(x, n = 4)
}
\arguments{
\item{x}{A data frame.}

\item{n}{Numeric, indicating the maximum amount of unique values in \code{x}
to be considered as "factor". Variables with more unique values than \code{n}
are not converted to factor.}
}
\value{
\code{x}, with numeric values with a maximum of \code{n} unique values
  being converted to factors.
}
\description{
This function converts numeric variables into factors,
  and uses associated value labels as factor levels.
}
\details{
If \code{x} is a labelled vector, associated value labels will be used
  as level. Else, the numeric vector is simply coerced using \code{as.factor()}.
}
\examples{
library(dplyr)
data(efc)
efc \%>\%
  select(e42dep, e16sex, c12hour, c160age, c172code) \%>\%
  numeric_to_factor()

}
