% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/integration.R
\name{IntegrateEmbeddings}
\alias{IntegrateEmbeddings}
\alias{IntegrateEmbeddings.IntegrationAnchorSet}
\alias{IntegrateEmbeddings.TransferAnchorSet}
\title{Integrate low dimensional embeddings}
\usage{
IntegrateEmbeddings(anchorset, ...)

\method{IntegrateEmbeddings}{IntegrationAnchorSet}(
  anchorset,
  new.reduction.name = "integrated_dr",
  reductions = NULL,
  dims.to.integrate = NULL,
  k.weight = 100,
  weight.reduction = NULL,
  sd.weight = 1,
  sample.tree = NULL,
  preserve.order = FALSE,
  verbose = TRUE,
  ...
)

\method{IntegrateEmbeddings}{TransferAnchorSet}(
  anchorset,
  reference,
  query,
  new.reduction.name = "integrated_dr",
  reductions = "pcaproject",
  dims.to.integrate = NULL,
  k.weight = 100,
  weight.reduction = NULL,
  reuse.weights.matrix = TRUE,
  sd.weight = 1,
  preserve.order = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{anchorset}{An AnchorSet object}

\item{...}{Reserved for internal use}

\item{new.reduction.name}{Name for new integrated dimensional reduction.}

\item{reductions}{Name of reductions to be integrated. For a
TransferAnchorSet, this should be the name of a reduction present in the
anchorset object (for example, "pcaproject"). For an IntegrationAnchorSet,
this should be a \code{\link{DimReduc}} object containing all cells present
in the anchorset object.}

\item{dims.to.integrate}{Number of dimensions to return integrated values for}

\item{k.weight}{Number of neighbors to consider when weighting anchors}

\item{weight.reduction}{Dimension reduction to use when calculating anchor
weights. This can be one of:
\itemize{
   \item{A string, specifying the name of a dimension reduction present in
   all objects to be integrated}
   \item{A vector of strings, specifying the name of a dimension reduction to
   use for each object to be integrated}
   \item{A vector of \code{\link{DimReduc}} objects, specifying the object to
   use for each object in the integration}
   \item{NULL, in which case the full corrected space is used for computing
   anchor weights.}
}}

\item{sd.weight}{Controls the bandwidth of the Gaussian kernel for weighting}

\item{sample.tree}{Specify the order of integration. If NULL, will compute
automatically.}

\item{preserve.order}{Do not reorder objects based on size for each pairwise
integration.}

\item{verbose}{Print progress bars and output}

\item{reference}{Reference object used in anchorset construction}

\item{query}{Query object used in anchorset construction}

\item{reuse.weights.matrix}{Can be used in conjunction with the store.weights
parameter in TransferData to reuse a precomputed weights matrix.}
}
\value{
When called on a TransferAnchorSet (from FindTransferAnchors), this
will return the query object with the integrated embeddings stored in a new
reduction. When called on an IntegrationAnchorSet (from IntegrateData), this
will return a merged object with the integrated reduction stored.
}
\description{
Perform dataset integration using a pre-computed Anchorset of specified low
dimensional representations.
}
\details{
The main steps of this procedure are identical to \code{\link{IntegrateData}}
with one key distinction. When computing the weights matrix, the distance
calculations are performed in the full space of integrated embeddings when
integrating more than two datasets, as opposed to a reduced PCA space which
is the default behavior in \code{\link{IntegrateData}}.
}
\concept{integration}
