% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/benchmark_suite.R
\name{solnp_standardize_problem}
\alias{solnp_standardize_problem}
\title{Standardize an Optimization Problem to NLP Standard Form}
\usage{
solnp_standardize_problem(prob)
}
\arguments{
\item{prob}{A list specifying the problem in SOLNP-compatible format, with components
\code{fn}, \code{eq_fn}, \code{eq_jac}, \code{eq_b}, \code{ineq_fn}, \code{ineq_jac},
\code{ineq_lower}, \code{ineq_upper}, and others.}
}
\value{
A list with the same structure as the input, but with \code{eq_fn} and \code{ineq_fn}
standardized to the forms \eqn{e(x) = 0} and \eqn{g(x) \leq 0}, and with
\code{eq_b}, \code{ineq_lower}, and \code{ineq_upper} removed.
}
\description{
Converts a problem specified with two-sided inequalities and nonzero equality right-hand sides
to the standard nonlinear programming (NLP) form.
}
\details{
The standard form given by the following set of equations:

\deqn{ \min_x\ f(x) }
\deqn{ \textrm{subject to}\quad e(x) = 0 }
\deqn{ \qquad\qquad\qquad g(x) \leq 0 }

Specifically:
\itemize{
\item All equality constraints are standardized to \eqn{e(x) = e(x) - b = 0}
\item Each two-sided inequality \eqn{l \leq g(x) \leq u} is converted to one or two
one-sided constraints: \eqn{l - g(x) \leq 0}, \eqn{g(x) - u \leq 0}
}

The returned problem object has all equalities as \eqn{e(x) = 0}, all inequalities as \eqn{g(x) \leq 0},
and any right-hand side or bounds are absorbed into the standardized constraint functions.
}
\examples{
# Alkylation problem
p <- solnp_problem_suite(suite = "Other", number = 1)
ps <- solnp_standardize_problem(p)
ps$eq_fn(ps$start)    # standardized equalities: e(x) = 0
ps$ineq_fn(ps$start)  # standardized inequalities: g(x) <= 0

}
\seealso{
\code{\link{solnp_problem_suite}}
}
