% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spline.R
\name{forecast.spline_model}
\alias{forecast.spline_model}
\alias{splinef}
\title{Returns local linear forecasts and prediction intervals using cubic
smoothing splines estimated with \code{\link[=spline_model]{spline_model()}}.}
\usage{
\method{forecast}{spline_model}(
  object,
  h = 10,
  level = c(80, 95),
  fan = FALSE,
  lambda = object$lambda,
  biasadj = attr(lambda, "biasadj"),
  simulate = FALSE,
  bootstrap = FALSE,
  innov = NULL,
  npaths = 5000,
  ...
)

splinef(
  y,
  h = 10,
  level = c(80, 95),
  fan = FALSE,
  lambda = NULL,
  biasadj = FALSE,
  method = c("gcv", "mle"),
  x = y
)
}
\arguments{
\item{object}{An object of class \code{spline_model}, produced using \code{\link[=spline_model]{spline_model()}}.}

\item{h}{Number of periods for forecasting. Default value is twice the
largest seasonal period (for seasonal data) or ten (for non-seasonal data).}

\item{level}{Confidence levels for prediction intervals.}

\item{fan}{If \code{TRUE}, \code{level} is set to \code{seq(51, 99, by = 3)}.
This is suitable for fan plots.}

\item{lambda}{Box-Cox transformation parameter. If \code{lambda = "auto"},
then a transformation is automatically selected using \code{BoxCox.lambda}.
The transformation is ignored if NULL. Otherwise,
data transformed before model is estimated.}

\item{biasadj}{Use adjusted back-transformed mean for Box-Cox
transformations. If transformed data is used to produce forecasts and fitted
values, a regular back transformation will result in median forecasts. If
biasadj is \code{TRUE}, an adjustment will be made to produce mean forecasts
and fitted values.}

\item{simulate}{If \code{TRUE}, prediction intervals are produced by simulation rather
than using analytic formulae. Errors are assumed to be normally distributed.}

\item{bootstrap}{If \code{TRUE}, then prediction intervals are produced by
simulation using resampled errors (rather than normally distributed errors). Ignored if \code{innov} is not \code{NULL}.}

\item{innov}{Optional matrix of future innovations to be used in
simulations. Ignored if \code{simulate = FALSE}. If provided, this overrides the \code{bootstrap} argument. The matrix
should have \code{h} rows and \code{npaths} columns.}

\item{npaths}{Number of sample paths used in computing simulated prediction
intervals.}

\item{...}{Other arguments are ignored.}

\item{y}{a numeric vector or univariate time series of class \code{ts}}

\item{method}{fitting method: maximum likelihood or minimize
    conditional sum-of-squares.  The default (unless there are missing
    values) is to use conditional-sum-of-squares to find starting
    values, then maximum likelihood.  Can be abbreviated.}

\item{x}{Deprecated. Included for backwards compatibility.}
}
\value{
An object of class \code{forecast}.
}
\description{
The cubic smoothing spline model is equivalent to an ARIMA(0,2,2) model but
with a restricted parameter space. The advantage of the spline model over
the full ARIMA model is that it provides a smooth historical trend as well
as a linear forecast function. Hyndman, King, Pitrun, and Billah (2002) show
that the forecast performance of the method is hardly affected by the
restricted parameter space.
}
\section{forecast class}{

An object of class \code{forecast} is a list usually containing at least
the following elements:
\describe{
\item{model}{A list containing information about the fitted model}
\item{method}{The name of the forecasting method as a character string}
\item{mean}{Point forecasts as a time series}
\item{lower}{Lower limits for prediction intervals}
\item{upper}{Upper limits for prediction intervals}
\item{level}{The confidence values associated with the prediction intervals}
\item{x}{The original time series.}
\item{residuals}{Residuals from the fitted model. For models with additive
errors, the residuals will be x minus the fitted values.}
\item{fitted}{Fitted values (one-step forecasts)}
}
The function \code{summary} can be used to obtain and print a summary of the
results, while the functions \code{plot} and \code{autoplot} produce plots of the forecasts and
prediction intervals. The generic accessors functions \code{fitted.values} and \code{residuals}
extract various useful features from the underlying model.
}

\examples{
fit <- spline_model(uspop)
fcast <- forecast(fit)
autoplot(fcast)
summary(fcast)

}
\references{
Hyndman, King, Pitrun and Billah (2005) Local linear forecasts
using cubic smoothing splines. \emph{Australian and New Zealand Journal of
Statistics}, \bold{47}(1), 87-99.
\url{https://robjhyndman.com/publications/splinefcast/}.
}
\seealso{
\code{\link[=spline_model]{spline_model()}}
}
\author{
Rob J Hyndman
}
\keyword{ts}
