% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mark.R
\name{mark}
\alias{mark}
\alias{bench_mark}
\title{Benchmark a series of functions}
\usage{
mark(
  ...,
  min_time = 0.5,
  iterations = NULL,
  min_iterations = 1,
  max_iterations = 10000,
  check = TRUE,
  memory = capabilities("profmem"),
  filter_gc = TRUE,
  relative = FALSE,
  time_unit = NULL,
  exprs = NULL,
  env = parent.frame()
)
}
\arguments{
\item{...}{Expressions to benchmark, if named the \code{expression} column will
be the name, otherwise it will be the deparsed expression.}

\item{min_time}{The minimum number of seconds to run each expression, set to
\code{Inf} to always run \code{max_iterations} times instead.}

\item{iterations}{If not \code{NULL}, the default, run each expression for
exactly this number of iterations. This overrides both \code{min_iterations}
and \code{max_iterations}.}

\item{min_iterations}{Each expression will be evaluated a minimum of \code{min_iterations} times.}

\item{max_iterations}{Each expression will be evaluated a maximum of \code{max_iterations} times.}

\item{check}{Check if results are consistent. If \code{TRUE}, checking is done
with \code{\link[=all.equal]{all.equal()}}, if \code{FALSE} checking is disabled and results are not
stored. If \code{check} is a function that function will be called with each
pair of results to determine consistency.}

\item{memory}{If \code{TRUE} (the default when R is compiled with memory
profiling), track memory allocations using \code{\link[utils:Rprofmem]{utils::Rprofmem()}}. If \code{FALSE}
disable memory tracking.}

\item{filter_gc}{If \code{TRUE} remove iterations that contained at least one
garbage collection before summarizing. If \code{TRUE} but an expression had
a garbage collection in every iteration, filtering is disabled, with a warning.}

\item{relative}{If \code{TRUE} all summaries are computed relative to the minimum
execution time rather than absolute time.}

\item{time_unit}{If \code{NULL} the times are reported in a human readable
fashion depending on each value. If one of 'ns', 'us', 'ms', 's', 'm', 'h',
'd', 'w' the time units are instead expressed as nanoseconds, microseconds,
milliseconds, seconds, hours, minutes, days or weeks respectively.}

\item{exprs}{A list of quoted expressions. If supplied overrides expressions
defined in \code{...}.}

\item{env}{The environment which to evaluate the expressions}
}
\value{
A \link[tibble:tibble]{tibble} with the additional summary columns.
The following summary columns are computed
\itemize{
\item \code{expression} - \code{bench_expr} The deparsed expression that was evaluated
(or its name if one was provided).
\item \code{min} - \code{bench_time} The minimum execution time.
\item \code{median} - \code{bench_time} The sample median of execution time.
\item \code{itr/sec} - \code{double} The estimated number of executions performed per
second.
\item \code{mem_alloc} - \code{bench_bytes} Total amount of memory allocated by R while
running the expression. Memory allocated \emph{outside} the R heap, e.g. by
\code{malloc()} or \code{new} directly is \emph{not} tracked, take care to avoid
misinterpreting the results if running code that may do this.
\item \code{gc/sec} - \code{double} The number of garbage collections per second.
\item \code{n_itr} - \code{integer} Total number of iterations after filtering
garbage collections (if \code{filter_gc == TRUE}).
\item \code{n_gc} - \code{double} Total number of garbage collections performed over all
iterations. This is a psudo-measure of the pressure on the garbage collector, if
it varies greatly between to alternatives generally the one with fewer
collections will cause fewer allocation in real usage.
\item \code{total_time} - \code{bench_time} The total time to perform the benchmarks.
\item \code{result} - \code{list} A list column of the object(s) returned by the
evaluated expression(s).
\item \code{memory} - \code{list} A list column with results from \code{\link[=Rprofmem]{Rprofmem()}}.
\item \code{time} - \code{list} A list column of \code{bench_time} vectors for each evaluated
expression.
\item \code{gc} - \code{list} A list column with tibbles containing the level of
garbage collection (0-2, columns) for each iteration (rows).
}
}
\description{
Benchmark a list of quoted expressions. Each expression will always run at
least twice, once to measure the memory allocation and store results and one
or more times to measure timing.
}
\examples{
dat <- data.frame(x = runif(100, 1, 1000), y=runif(10, 1, 1000))
mark(
  min_time = .1,

  dat[dat$x > 500, ],
  dat[which(dat$x > 500), ],
  subset(dat, x > 500))
}
\seealso{
\code{\link[=press]{press()}} to run benchmarks across a grid of parameters.
}
