% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callCIN.R
\name{callCIN}
\alias{callCIN}
\title{Call Chromosomal Instability}
\usage{
callCIN(
  res,
  id = 1,
  allele.specific = TRUE,
  reference.state = c("dominant", "normal")
)
}
\arguments{
\item{res}{Return object of the \code{\link{runAbsoluteCN}} function.}

\item{id}{Candidate solution to extract CIN from. \code{id=1} will use the
maximum likelihood solution.}

\item{allele.specific}{Use allele-specific or only total copy number for
detecting abnormal regions. Copy-number neutral LOH would be ignored when
this parameter is set to \code{FALSE}.}

\item{reference.state}{Copy number regions different from the reference
state are counted as abnormal. Default is \code{dominant} means the most
common state. The other option is \code{normal}, which defines normal
heterozygous, diploid as reference. The default is robust to errors in
ploidy.}
}
\value{
Returns \code{double(1)} with CIN value.
}
\description{
This function provides detailed CIN information.
}
\examples{

data(purecn.example.output)
head(callCIN(purecn.example.output))

}
\seealso{
\code{\link{runAbsoluteCN}}
}
\author{
Markus Riester
}
