% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/AllMethods.R
\name{degDefault}
\alias{degDefault}
\alias{degCorrect}
\alias{degDefault,DEGSet-method}
\alias{degCorrect,DEGSet-method}
\title{Method to get the default table to use.}
\usage{
degDefault(object)

degCorrect(object, fdr)

\S4method{degDefault}{DEGSet}(object)

\S4method{degCorrect}{DEGSet}(object, fdr)
}
\arguments{
\item{object}{\link{DEGSet}}

\item{fdr}{It can be \code{fdr-stat}, \code{fdr-pvalue}, vector of new padj}
}
\description{
It can accept a list of new padj values matching the
same dimmensions than the current vector.
}
\examples{
library(DESeq2)
library(dplyr)
dds <- makeExampleDESeqDataSet(betaSD=1)
colData(dds)[["treatment"]] <- sample(colData(dds)[["condition"]], 12)
design(dds) <-  ~ condition + treatment
dds <- DESeq(dds)
res <- degComps(dds, contrast = list("treatment_B_vs_A"))
}
\author{
Lorena Pantano
}
