# Introductory course

For those who wish to know more about the internals of trame, this developers
course consists of a two-hour training video, as well as associated course
slides, exercises, and a compact reference document.  This course was
originally presented to a group of Kitware developers, and is now available
to anyone who wishes to fully leverage trame’s powerful capabilities.

The course describes trame’s architecture; guidance on how to set up a Python
virtual environment for trame; various ways to work with internal state,
event, ui, and widgets; approaches to working with VTK.js, VTK, and ParaView
including VTK’s data processing pipelines along with client-side and
server-side rendering; interfaces to the Python and Jupyter ecosystems; and
ways to deploy trame as a desktop application or in the cloud.

Please view the following assets to participate in the course.

- [Video recording](https://vimeo.com/761096621/af2287747f)
- [Slides](https://github.com/Kitware/trame-tutorial/raw/master/course/introduction/Introduction_to_trame.pdf)
- [Exercises / code samples](https://github.com/Kitware/trame-tutorial/raw/master/course/introduction/exercises.zip)
- [Reference information](https://github.com/Kitware/trame-tutorial/raw/master/course/introduction/trame_intro_ref.pdf)

## Want to attend the next one?

We'll try to provide a course at least once a year. If you are interested, feel free to reach out to [Kitware](https://www.kitware.com/contact/) so we can keep you in the loop when those get scheduled. We also provide private training which can provide tailored content. Either way, if you have interest in trame [we can help](https://www.kitware.com/contact/). Just talk to us and we'll figure out how to best help you.

## Some Slides

| ![MVVM](/assets/images/course/mvvm_0.jpg) | ![Responsibilities](/assets/images/course/mvvm_1.jpg) |
| :---: | :---: |
| ![View Model](/assets/images/course/mvvm_2.jpg) | ![View](/assets/images/course/mvvm_3.jpg) |
| ![Full code](/assets/images/course/mvvm_4.jpg) | ![vtk.js](/assets/images/course/example.jpg) |
| ![vtk.js binding](/assets/images/course/example_explained.jpg) | ![Advanced](/assets/images/course/advanced.jpg) |
| ![Shared state summary](/assets/images/course/state.jpg) | ![Event summary](/assets/images/course/events.jpg) |
