# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import sys
from typing import Any, Callable, Dict, IO, Optional, TypeVar, Union, overload

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._billing_benefits_rp_operations import build_validate_purchase_request
from .._vendor import BillingBenefitsRPMixinABC

if sys.version_info >= (3, 8):
    from typing import Literal  # pylint: disable=no-name-in-module, ungrouped-imports
else:
    from typing_extensions import Literal  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class BillingBenefitsRPOperationsMixin(BillingBenefitsRPMixinABC):
    @overload
    async def validate_purchase(
        self, body: _models.SavingsPlanPurchaseValidateRequest, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.SavingsPlanValidateResponse:
        """Validate savings plan purchase.

        :param body: Request body for validating the purchase of a savings plan. Required.
        :type body: ~azure.mgmt.billingbenefits.models.SavingsPlanPurchaseValidateRequest
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SavingsPlanValidateResponse or the result of cls(response)
        :rtype: ~azure.mgmt.billingbenefits.models.SavingsPlanValidateResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def validate_purchase(
        self, body: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models.SavingsPlanValidateResponse:
        """Validate savings plan purchase.

        :param body: Request body for validating the purchase of a savings plan. Required.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SavingsPlanValidateResponse or the result of cls(response)
        :rtype: ~azure.mgmt.billingbenefits.models.SavingsPlanValidateResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def validate_purchase(
        self, body: Union[_models.SavingsPlanPurchaseValidateRequest, IO], **kwargs: Any
    ) -> _models.SavingsPlanValidateResponse:
        """Validate savings plan purchase.

        :param body: Request body for validating the purchase of a savings plan. Is either a model type
         or a IO type. Required.
        :type body: ~azure.mgmt.billingbenefits.models.SavingsPlanPurchaseValidateRequest or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SavingsPlanValidateResponse or the result of cls(response)
        :rtype: ~azure.mgmt.billingbenefits.models.SavingsPlanValidateResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2022-11-01"] = kwargs.pop(
            "api_version", _params.pop("api-version", self._config.api_version)
        )
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.SavingsPlanValidateResponse] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            _json = self._serialize.body(body, "SavingsPlanPurchaseValidateRequest")

        request = build_validate_purchase_request(
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            template_url=self.validate_purchase.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("SavingsPlanValidateResponse", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    validate_purchase.metadata = {"url": "/providers/Microsoft.BillingBenefits/validate"}
