; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
;=========================== begin_copyright_notice ============================
;
; Copyright (C) 2023-2024 Intel Corporation
;
; SPDX-License-Identifier: MIT
;
;============================ end_copyright_notice =============================
; REQUIRES: llvm-14-plus, regkeys
; RUN: igc_opt --typed-pointers -platformbmg -igc-resource-loop-unroll -regkey ResourceLoopUnrollNested=4 -verify -S < %s | FileCheck %s --check-prefix=CHECK-LL
; RUN: igc_opt --typed-pointers -platformbmg -igc-resource-loop-unroll -igc-emit-visa -simd-mode 16 -inputrt -regkey ResourceLoopUnrollNested=4 -regkey DumpVISAASMToConsole -S < %s | FileCheck %s --check-prefix=CHECK-VISAASM
;
; Test checks how we emit ResourceLoop

@ThreadGroupSize_X = constant i32 64
@ThreadGroupSize_Y = constant i32 1
@ThreadGroupSize_Z = constant i32 1

define spir_kernel void @test1(i32 %src1, i32 %val, i32 addrspace(1)* %dst) {
; CHECK-LL-LABEL: @test1(
; CHECK-LL:    [[SVN:%.*]] = call i16 @llvm.genx.GenISA.DCL.SystemValue.i16(i32 17)
; CHECK-LL-NEXT:    [[NONUNIFORM:%.*]] = zext i16 [[SVN]] to i32
; CHECK-LL-NEXT:    [[NONUNIFORMRESOURCE:%.*]] = inttoptr i32 [[NONUNIFORM]] to <4 x float> addrspace(2621440)*
; CHECK-LL-NEXT:    [[OFFSET:%.*]] = add i32 [[SRC1:%.*]], %nonuniform
; CHECK-LL-NEXT:    br label [[PARTIAL_CHECK5:%.*]]
; CHECK-LL:       partial_check5:
; CHECK-LL-NEXT:    [[TMP1:%.*]] = call i32 @llvm.genx.GenISA.WaveBallot(i1 true, i32 0)
; CHECK-LL-NEXT:    [[TMP2:%.*]] = call i32 @llvm.genx.GenISA.firstbitLo(i32 [[TMP1]])
; CHECK-LL-NEXT:    [[FIRSTACTIVERES6:%.*]] = call <4 x float> addrspace(2621440)* @llvm.genx.GenISA.WaveShuffleIndex.p2621440v4f32(<4 x float> addrspace(2621440)* [[NONUNIFORMRESOURCE]], i32 [[TMP2]], i32 0)
; CHECK-LL-NEXT:    [[TMP3:%.*]] = icmp eq <4 x float> addrspace(2621440)* [[NONUNIFORMRESOURCE]], [[FIRSTACTIVERES6]]
; CHECK-LL-NEXT:    [[TMP4:%.*]] = call <3 x i32> @llvm.genx.GenISA.ldrawvector.indexed.v3i32.p2621440v4f32(<4 x float> addrspace(2621440)* [[FIRSTACTIVERES6]], i32 [[OFFSET]], i32 4, i1 false)
; CHECK-LL-NEXT:    br i1 [[TMP3]], label [[UNROLL_MERGE:%.*]], label [[PARTIAL_CHECK3:%.*]]
; CHECK-LL:       partial_check3:
; CHECK-LL-NEXT:    [[TMP5:%.*]] = call i32 @llvm.genx.GenISA.WaveBallot(i1 true, i32 0)
; CHECK-LL-NEXT:    [[TMP6:%.*]] = call i32 @llvm.genx.GenISA.firstbitLo(i32 [[TMP5]])
; CHECK-LL-NEXT:    [[FIRSTACTIVERES4:%.*]] = call <4 x float> addrspace(2621440)* @llvm.genx.GenISA.WaveShuffleIndex.p2621440v4f32(<4 x float> addrspace(2621440)* [[NONUNIFORMRESOURCE]], i32 [[TMP6]], i32 0)
; CHECK-LL-NEXT:    [[TMP7:%.*]] = icmp eq <4 x float> addrspace(2621440)* [[NONUNIFORMRESOURCE]], [[FIRSTACTIVERES4]]
; CHECK-LL-NEXT:    [[TMP8:%.*]] = call <3 x i32> @llvm.genx.GenISA.ldrawvector.indexed.v3i32.p2621440v4f32(<4 x float> addrspace(2621440)* [[FIRSTACTIVERES4]], i32 [[OFFSET]], i32 4, i1 false)
; CHECK-LL-NEXT:    br i1 [[TMP7]], label [[UNROLL_MERGE:%.*]], label [[PARTIAL_CHECK1:%.*]]
; CHECK-LL:       partial_check1:
; CHECK-LL-NEXT:    [[TMP9:%.*]] = call i32 @llvm.genx.GenISA.WaveBallot(i1 true, i32 0)
; CHECK-LL-NEXT:    [[TMP10:%.*]] = call i32 @llvm.genx.GenISA.firstbitLo(i32 [[TMP9]])
; CHECK-LL-NEXT:    [[FIRSTACTIVERES2:%.*]] = call <4 x float> addrspace(2621440)* @llvm.genx.GenISA.WaveShuffleIndex.p2621440v4f32(<4 x float> addrspace(2621440)* [[NONUNIFORMRESOURCE]], i32 [[TMP10]], i32 0)
; CHECK-LL-NEXT:    [[TMP11:%.*]] = icmp eq <4 x float> addrspace(2621440)* [[NONUNIFORMRESOURCE]], [[FIRSTACTIVERES2]]
; CHECK-LL-NEXT:    [[TMP12:%.*]] = call <3 x i32> @llvm.genx.GenISA.ldrawvector.indexed.v3i32.p2621440v4f32(<4 x float> addrspace(2621440)* [[FIRSTACTIVERES2]], i32 [[OFFSET]], i32 4, i1 false)
; CHECK-LL-NEXT:    br i1 [[TMP11]], label [[UNROLL_MERGE:%.*]], label [[PARTIAL_CHECK:%.*]]
; CHECK-LL:       partial_check:
; CHECK-LL-NEXT:    [[TMP13:%.*]] = call i32 @llvm.genx.GenISA.WaveBallot(i1 true, i32 0)
; CHECK-LL-NEXT:    [[TMP14:%.*]] = call i32 @llvm.genx.GenISA.firstbitLo(i32 [[TMP13]])
; CHECK-LL-NEXT:    [[FIRSTACTIVERES:%.*]] = call <4 x float> addrspace(2621440)* @llvm.genx.GenISA.WaveShuffleIndex.p2621440v4f32(<4 x float> addrspace(2621440)* [[NONUNIFORMRESOURCE]], i32 [[TMP14]], i32 0)
; CHECK-LL-NEXT:    [[TMP15:%.*]] = icmp eq <4 x float> addrspace(2621440)* [[NONUNIFORMRESOURCE]], [[FIRSTACTIVERES]]
; CHECK-LL-NEXT:    [[TMP16:%.*]] = call <3 x i32> @llvm.genx.GenISA.ldrawvector.indexed.v3i32.p2621440v4f32(<4 x float> addrspace(2621440)* [[FIRSTACTIVERES]], i32 [[OFFSET]], i32 4, i1 false)
; CHECK-LL-NEXT:    br i1 [[TMP15]], label [[UNROLL_MERGE]], label [[LATCH:%.*]]
; CHECK-LL:       latch:
; CHECK-LL-NEXT:    br label [[PARTIAL_CHECK5]]
; CHECK-LL:       unroll-merge:
; CHECK-LL-NEXT:    [[TMP17:%.*]] = phi <3 x i32> [ [[TMP16]], [[PARTIAL_CHECK]] ], [ [[TMP12]], [[PARTIAL_CHECK1]] ], [ [[TMP8]], [[PARTIAL_CHECK3]] ], [ [[TMP4]], [[PARTIAL_CHECK5]] ], !MyUniqueExclusiveLoadMetadata !24
; CHECK-LL-NEXT:    [[OUT:%.*]] = extractelement <3 x i32> [[TMP17]], i32 [[VAL:%.*]]
; CHECK-LL-NEXT:    store i32 [[OUT]], i32 addrspace(1)* [[DST:%.*]], align 1
; CHECK-LL-NEXT:    ret void
;
; COM: check predicate load and lifetime.start
; CHECK-VISAASM:  _main_0:
; CHECK-VISAASM-NEXT:  mov (M1, 16) svn(0,0)<1> threadIdInGroupX(0,0)<1;1,0>
; CHECK-VISAASM-NEXT:  mov (M1, 16) nonuniform(0,0)<1> svn_0(0,0)<1;1,0>
; CHECK-VISAASM-NEXT:  add (M1, 16) offset(0,0)<1> src1(0,0)<0;1,0> nonuniform(0,0)<1;1,0>
; CHECK-VISAASM-NEXT:  lifetime.start V0032
;
; CHECK-VISAASM:  _test1_001_partial_check5:
; CHECK-VISAASM-NEXT:  setp (M1_NM, 16) P1 0x0:ud
; CHECK-VISAASM-NEXT:  cmp.eq (M1, 16) P1 V0035(0,0)<0;1,0> V0035(0,0)<0;1,0>
; CHECK-VISAASM-NEXT:  mov (M1_NM, 1) V0036(0,0)<1> P1
; CHECK-VISAASM-NEXT:  mov (M1_NM, 1) V0034(0,0)<1> V0036(0,0)<0;1,0>
; CHECK-VISAASM-NEXT:  fbl (M1_NM, 1) V0038(0,0)<1> V0034(0,0)<0;1,0>
; CHECK-VISAASM-NEXT:  shl (M1_NM, 1) ShuffleTmp(0,0)<1> V0039(0,0)<0;1,0> 0x2:uw
; CHECK-VISAASM-NEXT:  addr_add (M1_NM, 1) A0(0)<1> &nonuniform_0 ShuffleTmp(0,0)<0;1,0>
; CHECK-VISAASM-NEXT:  mov (M1_NM, 1) firstActiveRes6(0,0)<1> r[A0(0),0]<0;1,0>:ud
; CHECK-VISAASM-NEXT:  cmp.eq (M1, 16) P2 nonuniform_0(0,0)<1;1,0> firstActiveRes6(0,0)<0;1,0>
; CHECK-VISAASM-NEXT:  (P2) lsc_load.ugm.ca.ca (M1, 16)  V0032:d32x3  bss(firstActiveRes6)[offset]:a32
; CHECK-VISAASM-NEXT:  (P2) goto (M1, 16) _test1_006_unroll_merge
;
; CHECK-VISAASM:  _test1_002_partial_check3:
; CHECK-VISAASM-NEXT:  setp (M1_NM, 16) P3 0x0:ud
; CHECK-VISAASM-NEXT:  cmp.eq (M1, 16) P3 V0042(0,0)<0;1,0> V0042(0,0)<0;1,0>
; CHECK-VISAASM-NEXT:  mov (M1_NM, 1) V0043(0,0)<1> P3
; CHECK-VISAASM-NEXT:  mov (M1_NM, 1) V0041(0,0)<1> V0043(0,0)<0;1,0>
; CHECK-VISAASM-NEXT:  fbl (M1_NM, 1) V0045(0,0)<1> V0041(0,0)<0;1,0>
; CHECK-VISAASM-NEXT:  shl (M1_NM, 1) ShuffleTmp_0(0,0)<1> V0046(0,0)<0;1,0> 0x2:uw
; CHECK-VISAASM-NEXT:  addr_add (M1_NM, 1) A1(0)<1> &nonuniform_0 ShuffleTmp_0(0,0)<0;1,0>
; CHECK-VISAASM-NEXT:  mov (M1_NM, 1) firstActiveRes4(0,0)<1> r[A1(0),0]<0;1,0>:ud
; CHECK-VISAASM-NEXT:  cmp.eq (M1, 16) P4 nonuniform_0(0,0)<1;1,0> firstActiveRes4(0,0)<0;1,0>
; CHECK-VISAASM-NEXT:  (P4) lsc_load.ugm.ca.ca (M1, 16)  V0032:d32x3  bss(firstActiveRes4)[offset]:a32
; CHECK-VISAASM-NEXT:  (P4) goto (M1, 16) _test1_006_unroll_merge
;
; CHECK-VISAASM:  _test1_003_partial_check1:
; CHECK-VISAASM-NEXT:  setp (M1_NM, 16) P5 0x0:ud
; CHECK-VISAASM-NEXT:  cmp.eq (M1, 16) P5 V0049(0,0)<0;1,0> V0049(0,0)<0;1,0>
; CHECK-VISAASM-NEXT:  mov (M1_NM, 1) V0050(0,0)<1> P5
; CHECK-VISAASM-NEXT:  mov (M1_NM, 1) V0048(0,0)<1> V0050(0,0)<0;1,0>
; CHECK-VISAASM-NEXT:  fbl (M1_NM, 1) V0052(0,0)<1> V0048(0,0)<0;1,0>
; CHECK-VISAASM-NEXT:  shl (M1_NM, 1) ShuffleTmp_1(0,0)<1> V0053(0,0)<0;1,0> 0x2:uw
; CHECK-VISAASM-NEXT:  addr_add (M1_NM, 1) A2(0)<1> &nonuniform_0 ShuffleTmp_1(0,0)<0;1,0>
; CHECK-VISAASM-NEXT:  mov (M1_NM, 1) firstActiveRes2(0,0)<1> r[A2(0),0]<0;1,0>:ud
; CHECK-VISAASM-NEXT:  cmp.eq (M1, 16) P6 nonuniform_0(0,0)<1;1,0> firstActiveRes2(0,0)<0;1,0>
; CHECK-VISAASM-NEXT:  (P6) lsc_load.ugm.ca.ca (M1, 16)  V0032:d32x3  bss(firstActiveRes2)[offset]:a32
; CHECK-VISAASM-NEXT:  (P6) goto (M1, 16) _test1_006_unroll_merge
;
; CHECK-VISAASM:  _test1_004_partial_check:
; CHECK-VISAASM-NEXT:  setp (M1_NM, 16) P7 0x0:ud
; CHECK-VISAASM-NEXT:  cmp.eq (M1, 16) P7 V0056(0,0)<0;1,0> V0056(0,0)<0;1,0>
; CHECK-VISAASM-NEXT:  mov (M1_NM, 1) V0057(0,0)<1> P7
; CHECK-VISAASM-NEXT:  mov (M1_NM, 1) V0055(0,0)<1> V0057(0,0)<0;1,0>
; CHECK-VISAASM-NEXT:  fbl (M1_NM, 1) V0059(0,0)<1> V0055(0,0)<0;1,0>
; CHECK-VISAASM-NEXT:  shl (M1_NM, 1) ShuffleTmp_2(0,0)<1> V0060(0,0)<0;1,0> 0x2:uw
; CHECK-VISAASM-NEXT:  addr_add (M1_NM, 1) A3(0)<1> &nonuniform_0 ShuffleTmp_2(0,0)<0;1,0>
; CHECK-VISAASM-NEXT:  mov (M1_NM, 1) firstActiveRes(0,0)<1> r[A3(0),0]<0;1,0>:ud
; CHECK-VISAASM-NEXT:  cmp.eq (M1, 16) P8 nonuniform_0(0,0)<1;1,0> firstActiveRes(0,0)<0;1,0>
; CHECK-VISAASM-NEXT:  (P8) lsc_load.ugm.ca.ca (M1, 16)  V0032:d32x3  bss(firstActiveRes)[offset]:a32
; CHECK-VISAASM-NEXT:  (!P8) goto (M1, 16) _test1_001_partial_check5
;
; CHECK-VISAASM:  _test1_006_unroll_merge:
; CHECK-VISAASM-NEXT:  mul (M1_NM, 1) V0061(0,0)<1> val_0(0,0)<0;1,0> 0x40:uw
; CHECK-VISAASM-NEXT:  addr_add (M1_NM, 1) A4(0)<1> &V0032 V0061(0,0)<0;1,0>
; CHECK-VISAASM-NEXT:  mov (M1, 16) out(0,0)<1> r[A4(0),0]<8;8,1>:d
; CHECK-VISAASM-NEXT:  mov (M1_NM, 1) dst_0(0,0)<1> dst(0,0)<0;1,0>
; CHECK-VISAASM-NEXT:  mov (M1, 16) dstBroadcast_0(0,0)<2> dst_1(0,0)<0;1,0>
; CHECK-VISAASM-NEXT:  mov (M1, 16) dstBroadcast_0(0,1)<2> dst_1(0,1)<0;1,0>
; CHECK-VISAASM-NEXT:  lsc_store.ugm.wb.wb (M1, 16)  flat[dstBroadcast]:a64  out:d32
; CHECK-VISAASM-NEXT:  ret (M1, 1)

  %svn = call i16 @llvm.genx.GenISA.DCL.SystemValue.i16(i32 17)
  %nonuniform = zext i16 %svn to i32
  %NonUniformResource = inttoptr i32 %nonuniform to <4 x float> addrspace(2621440)*
  %offset = add i32 %src1, %nonuniform

  %call = call <3 x i32> @llvm.genx.GenISA.ldrawvector.indexed.v3i32.p2621440v4f32(<4 x float> addrspace(2621440)* %NonUniformResource, i32 %offset, i32 4, i1 false)

  %out = extractelement <3 x i32> %call, i32 %val
  store i32 %out, i32 addrspace(1)* %dst, align 1
  ret void
}

declare <3 x i32> @llvm.genx.GenISA.ldrawvector.indexed.v3i32.p2621440v4f32(<4 x float> addrspace(2621440)*, i32, i32, i1) #4

declare i16 @llvm.genx.GenISA.DCL.SystemValue.i16(i32) #1
declare i32 @llvm.genx.GenISA.WaveShuffleIndex.i32(i32, i32, i32) #6

declare float @llvm.genx.GenISA.WaveAll.f32(float, i8, i32) #0
declare i32 @llvm.genx.GenISA.WaveBallot(i1, i32)
declare i32 @llvm.genx.GenISA.firstbitLo(i32)

attributes #4 = { argmemonly nounwind readonly }

!IGCMetadata = !{!0}
!igc.functions = !{!21}

!0 = !{!"ModuleMD", !1}
!1 = !{!"FuncMD", !2, !3}
!2 = !{!"FuncMDMap[0]", void (i32, i32, i32 addrspace(1)*)* @test1}
!3 = !{!"FuncMDValue[0]", !4, !17}
!4 = !{!"resAllocMD", !5}
!5 = !{!"argAllocMDList", !6, !10, !11, !14, !15, !16}
!6 = !{!"argAllocMDListVec[0]", !7, !8, !9}
!7 = !{!"type", i32 0}
!8 = !{!"extensionType", i32 -1}
!9 = !{!"indexType", i32 -1}
!10 = !{!"argAllocMDListVec[1]", !7, !8, !9}
!11 = !{!"argAllocMDListVec[2]", !12, !8, !13}
!12 = !{!"type", i32 1}
!13 = !{!"indexType", i32 0}
!14 = !{!"argAllocMDListVec[3]", !7, !8, !9}
!15 = !{!"argAllocMDListVec[4]", !7, !8, !9}
!16 = !{!"argAllocMDListVec[5]", !7, !8, !9}
!17 = !{!"m_OpenCLArgTypeQualifiers", !18, !19, !20}
!18 = !{!"m_OpenCLArgTypeQualifiersVec[0]", !""}
!19 = !{!"m_OpenCLArgTypeQualifiersVec[1]", !""}
!20 = !{!"m_OpenCLArgTypeQualifiersVec[2]", !""}
!21 = !{void (i32, i32, i32 addrspace(1)*)* @test1, !22}
!22 = !{!23}
!23 = !{!"function_type", i32 0}
