//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armnotificationhubs

import "time"

// AdmCredential - Description of a NotificationHub AdmCredential.
type AdmCredential struct {
	// Properties of NotificationHub AdmCredential.
	Properties *AdmCredentialProperties
}

// AdmCredentialProperties - Description of a NotificationHub AdmCredential.
type AdmCredentialProperties struct {
	// The URL of the authorization token.
	AuthTokenURL *string

	// The client identifier.
	ClientID *string

	// The credential secret access key.
	ClientSecret *string
}

// ApnsCredential - Description of a NotificationHub ApnsCredential.
type ApnsCredential struct {
	// Properties of NotificationHub ApnsCredential.
	Properties *ApnsCredentialProperties
}

// ApnsCredentialProperties - Description of a NotificationHub ApnsCredential. Note that there is no explicit switch between
// Certificate and Token Authentication Modes. The mode is determined based on the properties passed in.
type ApnsCredentialProperties struct {
	// The APNS certificate. Specify if using Certificate Authentication Mode.
	ApnsCertificate *string

	// The issuer (iss) registered claim key. The value is a 10-character TeamId, obtained from your developer account. Specify
	// if using Token Authentication Mode.
	AppID *string

	// The name of the application or BundleId. Specify if using Token Authentication Mode.
	AppName *string

	// The APNS certificate password if it exists.
	CertificateKey *string

	// The APNS endpoint of this credential. If using Certificate Authentication Mode and Sandbox specify 'gateway.sandbox.push.apple.com'.
	// If using Certificate Authentication Mode and Production specify
	// 'gateway.push.apple.com'. If using Token Authentication Mode and Sandbox specify 'https://api.development.push.apple.com:443/3/device'.
	// If using Token Authentication Mode and Production specify
	// 'https://api.push.apple.com:443/3/device'.
	Endpoint *string

	// A 10-character key identifier (kid) key, obtained from your developer account. Specify if using Token Authentication Mode.
	KeyID *string

	// The APNS certificate thumbprint. Specify if using Certificate Authentication Mode.
	Thumbprint *string

	// Provider Authentication Token, obtained through your developer account. Specify if using Token Authentication Mode.
	Token *string
}

// BaiduCredential - Description of a NotificationHub BaiduCredential.
type BaiduCredential struct {
	// Properties of NotificationHub BaiduCredential.
	Properties *BaiduCredentialProperties
}

// BaiduCredentialProperties - Description of a NotificationHub BaiduCredential.
type BaiduCredentialProperties struct {
	// Baidu Api Key.
	BaiduAPIKey *string

	// Baidu Endpoint.
	BaiduEndPoint *string

	// Baidu Secret Key
	BaiduSecretKey *string
}

// CheckAvailabilityParameters - Parameters supplied to the Check Name Availability for Namespace and NotificationHubs.
type CheckAvailabilityParameters struct {
	// REQUIRED; Resource name
	Name *string

	// True if the name is available and can be used to create new Namespace/NotificationHub. Otherwise false.
	IsAvailiable *bool

	// Resource location
	Location *string

	// The sku of the created namespace
	SKU *SKU

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource type
	Type *string
}

// CheckAvailabilityResult - Description of a CheckAvailability resource.
type CheckAvailabilityResult struct {
	// True if the name is available and can be used to create new Namespace/NotificationHub. Otherwise false.
	IsAvailiable *bool

	// Resource location
	Location *string

	// The sku of the created namespace
	SKU *SKU

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// DebugSendResponse - Description of a NotificationHub Resource.
type DebugSendResponse struct {
	// Resource location
	Location *string

	// Properties of the NotificationHub.
	Properties *DebugSendResult

	// The sku of the created namespace
	SKU *SKU

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

type DebugSendResult struct {
	// send failure
	Failure *float32

	// actual failure description
	Results any

	// successful send
	Success *float32
}

// ErrorResponse - Error response indicates NotificationHubs service is not able to process the incoming request. The reason
// is provided in the error message.
type ErrorResponse struct {
	// Error code.
	Code *string

	// Error message indicating why the operation failed.
	Message *string
}

// GCMCredential - Description of a NotificationHub GcmCredential.
type GCMCredential struct {
	// Properties of NotificationHub GcmCredential.
	Properties *GCMCredentialProperties
}

// GCMCredentialProperties - Description of a NotificationHub GcmCredential.
type GCMCredentialProperties struct {
	// The FCM legacy endpoint. Default value is 'https://fcm.googleapis.com/fcm/send'
	GCMEndpoint *string

	// The Google API key.
	GoogleAPIKey *string
}

// MpnsCredential - Description of a NotificationHub MpnsCredential.
type MpnsCredential struct {
	// Properties of NotificationHub MpnsCredential.
	Properties *MpnsCredentialProperties
}

// MpnsCredentialProperties - Description of a NotificationHub MpnsCredential.
type MpnsCredentialProperties struct {
	// The certificate key for this credential.
	CertificateKey *string

	// The MPNS certificate.
	MpnsCertificate *string

	// The MPNS certificate Thumbprint
	Thumbprint *string
}

// NamespaceCreateOrUpdateParameters - Parameters supplied to the CreateOrUpdate Namespace operation.
type NamespaceCreateOrUpdateParameters struct {
	// Resource location
	Location *string

	// Properties of the Namespace.
	Properties *NamespaceProperties

	// The sku of the created namespace
	SKU *SKU

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// NamespaceListResult - The response of the List Namespace operation.
type NamespaceListResult struct {
	// Link to the next set of results. Not empty if Value contains incomplete list of Namespaces
	NextLink *string

	// Result of the List Namespace operation.
	Value []*NamespaceResource
}

// NamespacePatchParameters - Parameters supplied to the Patch Namespace operation.
type NamespacePatchParameters struct {
	// The sku of the created namespace
	SKU *SKU

	// Resource tags
	Tags map[string]*string
}

// NamespaceProperties - Namespace properties.
type NamespaceProperties struct {
	// The time the namespace was created.
	CreatedAt *time.Time

	// Whether or not the namespace is set as Critical.
	Critical *bool

	// Data center for the namespace
	DataCenter *string

	// Whether or not the namespace is currently enabled.
	Enabled *bool

	// The name of the namespace.
	Name *string

	// The namespace type.
	NamespaceType *NamespaceType

	// Provisioning state of the Namespace.
	ProvisioningState *string

	// Specifies the targeted region in which the namespace should be created. It can be any of the following values: Australia
	// East, Australia Southeast, Central US, East US, East US 2, West US, North
	// Central US, South Central US, East Asia, Southeast Asia, Brazil South, Japan East, Japan West, North Europe, West Europe
	Region *string

	// ScaleUnit where the namespace gets created
	ScaleUnit *string

	// Endpoint you can use to perform NotificationHub operations.
	ServiceBusEndpoint *string

	// Status of the namespace. It can be any of these values:1 = Created/Active2 = Creating3 = Suspended4 = Deleting
	Status *string

	// The Id of the Azure subscription associated with the namespace.
	SubscriptionID *string

	// The time the namespace was updated.
	UpdatedAt *time.Time

	// READ-ONLY; Identifier for Azure Insights metrics
	MetricID *string
}

// NamespaceResource - Description of a Namespace resource.
type NamespaceResource struct {
	// Resource location
	Location *string

	// Properties of the Namespace.
	Properties *NamespaceProperties

	// The sku of the created namespace
	SKU *SKU

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// NotificationHubCreateOrUpdateParameters - Parameters supplied to the CreateOrUpdate NotificationHub operation.
type NotificationHubCreateOrUpdateParameters struct {
	// REQUIRED; Properties of the NotificationHub.
	Properties *NotificationHubProperties

	// Resource location
	Location *string

	// The sku of the created namespace
	SKU *SKU

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// NotificationHubListResult - The response of the List NotificationHub operation.
type NotificationHubListResult struct {
	// Link to the next set of results. Not empty if Value contains incomplete list of NotificationHub
	NextLink *string

	// Result of the List NotificationHub operation.
	Value []*NotificationHubResource
}

// NotificationHubPatchParameters - Parameters supplied to the patch NotificationHub operation.
type NotificationHubPatchParameters struct {
	// Resource location
	Location *string

	// Properties of the NotificationHub.
	Properties *NotificationHubProperties

	// The sku of the created namespace
	SKU *SKU

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// NotificationHubProperties - NotificationHub properties.
type NotificationHubProperties struct {
	// The AdmCredential of the created NotificationHub
	AdmCredential *AdmCredential

	// The ApnsCredential of the created NotificationHub
	ApnsCredential *ApnsCredential

	// The AuthorizationRules of the created NotificationHub
	AuthorizationRules []*SharedAccessAuthorizationRuleProperties

	// The BaiduCredential of the created NotificationHub
	BaiduCredential *BaiduCredential

	// The GcmCredential of the created NotificationHub
	GCMCredential *GCMCredential

	// The MpnsCredential of the created NotificationHub
	MpnsCredential *MpnsCredential

	// The NotificationHub name.
	Name *string

	// The RegistrationTtl of the created NotificationHub
	RegistrationTTL *string

	// The WnsCredential of the created NotificationHub
	WnsCredential *WnsCredential
}

// NotificationHubResource - Description of a NotificationHub Resource.
type NotificationHubResource struct {
	// Resource location
	Location *string

	// Properties of the NotificationHub.
	Properties *NotificationHubProperties

	// The sku of the created namespace
	SKU *SKU

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// Operation - A NotificationHubs REST API operation
type Operation struct {
	// The object that represents the operation.
	Display *OperationDisplay

	// READ-ONLY; Operation name: {provider}/{resource}/{operation}
	Name *string
}

// OperationDisplay - The object that represents the operation.
type OperationDisplay struct {
	// READ-ONLY; Operation type: Read, write, delete, etc.
	Operation *string

	// READ-ONLY; Service provider: Microsoft.NotificationHubs
	Provider *string

	// READ-ONLY; Resource on which the operation is performed: Invoice, etc.
	Resource *string
}

// OperationListResult - Result of the request to list NotificationHubs operations. It contains a list of operations and a
// URL link to get the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string

	// READ-ONLY; List of NotificationHubs operations supported by the Microsoft.NotificationHubs resource provider.
	Value []*Operation
}

// PnsCredentialsProperties - Description of a NotificationHub PNS Credentials.
type PnsCredentialsProperties struct {
	// The AdmCredential of the created NotificationHub
	AdmCredential *AdmCredential

	// The ApnsCredential of the created NotificationHub
	ApnsCredential *ApnsCredential

	// The BaiduCredential of the created NotificationHub
	BaiduCredential *BaiduCredential

	// The GcmCredential of the created NotificationHub
	GCMCredential *GCMCredential

	// The MpnsCredential of the created NotificationHub
	MpnsCredential *MpnsCredential

	// The WnsCredential of the created NotificationHub
	WnsCredential *WnsCredential
}

// PnsCredentialsResource - Description of a NotificationHub PNS Credentials.
type PnsCredentialsResource struct {
	// Resource location
	Location *string

	// NotificationHub PNS Credentials.
	Properties *PnsCredentialsProperties

	// The sku of the created namespace
	SKU *SKU

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// PolicykeyResource - Namespace/NotificationHub Regenerate Keys
type PolicykeyResource struct {
	// Name of the key that has to be regenerated for the Namespace/Notification Hub Authorization Rule. The value can be Primary
	// Key/Secondary Key.
	PolicyKey *string
}

type Resource struct {
	// Resource location
	Location *string

	// The sku of the created namespace
	SKU *SKU

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// ResourceListKeys - Namespace/NotificationHub Connection String
type ResourceListKeys struct {
	// KeyName of the created AuthorizationRule
	KeyName *string

	// PrimaryConnectionString of the AuthorizationRule.
	PrimaryConnectionString *string

	// PrimaryKey of the created AuthorizationRule.
	PrimaryKey *string

	// SecondaryConnectionString of the created AuthorizationRule
	SecondaryConnectionString *string

	// SecondaryKey of the created AuthorizationRule
	SecondaryKey *string
}

// SKU - The Sku description for a namespace
type SKU struct {
	// REQUIRED; Name of the notification hub sku
	Name *SKUName

	// The capacity of the resource
	Capacity *int32

	// The Sku Family
	Family *string

	// The Sku size
	Size *string

	// The tier of particular sku
	Tier *string
}

// SharedAccessAuthorizationRuleCreateOrUpdateParameters - Parameters supplied to the CreateOrUpdate Namespace AuthorizationRules.
type SharedAccessAuthorizationRuleCreateOrUpdateParameters struct {
	// REQUIRED; Properties of the Namespace AuthorizationRules.
	Properties *SharedAccessAuthorizationRuleProperties
}

// SharedAccessAuthorizationRuleListResult - The response of the List Namespace operation.
type SharedAccessAuthorizationRuleListResult struct {
	// Link to the next set of results. Not empty if Value contains incomplete list of AuthorizationRules
	NextLink *string

	// Result of the List AuthorizationRules operation.
	Value []*SharedAccessAuthorizationRuleResource
}

// SharedAccessAuthorizationRuleProperties - SharedAccessAuthorizationRule properties.
type SharedAccessAuthorizationRuleProperties struct {
	// The rights associated with the rule.
	Rights []*AccessRights

	// READ-ONLY; A string that describes the claim type
	ClaimType *string

	// READ-ONLY; A string that describes the claim value
	ClaimValue *string

	// READ-ONLY; The created time for this rule
	CreatedTime *string

	// READ-ONLY; A string that describes the authorization rule.
	KeyName *string

	// READ-ONLY; The last modified time for this rule
	ModifiedTime *string

	// READ-ONLY; A base64-encoded 256-bit primary key for signing and validating the SAS token.
	PrimaryKey *string

	// READ-ONLY; The revision number for the rule
	Revision *int32

	// READ-ONLY; A base64-encoded 256-bit primary key for signing and validating the SAS token.
	SecondaryKey *string
}

// SharedAccessAuthorizationRuleResource - Description of a Namespace AuthorizationRules.
type SharedAccessAuthorizationRuleResource struct {
	// Resource location
	Location *string

	// Properties of the Namespace AuthorizationRule.
	Properties *SharedAccessAuthorizationRuleProperties

	// The sku of the created namespace
	SKU *SKU

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

type SubResource struct {
	// Resource Id
	ID *string
}

// WnsCredential - Description of a NotificationHub WnsCredential.
type WnsCredential struct {
	// Properties of NotificationHub WnsCredential.
	Properties *WnsCredentialProperties
}

// WnsCredentialProperties - Description of a NotificationHub WnsCredential.
type WnsCredentialProperties struct {
	// The package ID for this credential.
	PackageSid *string

	// The secret key.
	SecretKey *string

	// The Windows Live endpoint.
	WindowsLiveEndpoint *string
}
