<!--
%CopyrightBegin%

SPDX-License-Identifier: Apache-2.0

Copyright Ericsson AB 2023-2025. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

%CopyrightEnd%
-->
# Standards Compliance

## Purpose

This section describes the current state of standards compliance of the ssl
application.

## Common (prior to TLS 1.3)

- For security reasons RSA key exchange cipher suites are no longer supported by
  default, but can be configured. (OTP 21)
- For security reasons DES cipher suites are no longer supported by default, but
  can be configured. (OTP 20)
- For security reasons 3DES cipher suites are no longer supported by default,
  but can be configured. (OTP 21)
- Renegotiation Indication Extension
  [RFC 5746](http://www.ietf.org/rfc/rfc5746.txt) is supported
- Ephemeral Diffie-Hellman cipher suites are supported, but not Diffie Hellman
  Certificates cipher suites.
- Elliptic Curve cipher suites are supported if the Crypto application supports
  it and named curves are used.
- Export cipher suites are not supported as the U.S. lifted its export
  restrictions in early 2000.
- IDEA cipher suites are not supported as they have become deprecated by the TLS
  1.2 specification so it is not motivated to implement them.
- Compression is not supported.
- It is possible to use Pre-Shared Key (PSK) and Secure Remote Password (SRP)
  cipher suites, but they are not enabled by default and need addition configuration.
 
## Common

- CRL validation is supported.
- Policy certificate extensions are supported. (OTP 27)
- 'Server Name Indication' extension
  ([RFC 6066](http://www.ietf.org/rfc/rfc6066.txt)) is supported.
- Application Layer Protocol Negotiation (ALPN) and its successor Next Protocol
  Negotiation (NPN) are supported.

## SSL 2.0

For security reasons SSL-2.0 is not supported. Interoperability with SSL-2.0
enabled clients dropped. (OTP 21)

## SSL 3.0

For security reasons SSL-3.0 is no longer supported at all. (OTP 23)

For security reasons SSL-3.0 is no longer supported by default, but can be
configured. (OTP 19)

## TLS 1.0

For security reasons TLS-1.0 is no longer supported by default, but can be
configured. (OTP 22)

## TLS 1.1

For security reasons TLS-1.1 is no longer supported by default, but can be
configured. (OTP 22)

## TLS 1.2

Supported

## DTLS 1.0

For security reasons DTLS-1.0 (based on TLS 1.1) is no longer supported by
default, but can be configured. (OTP 22)

## DTLS 1.2

Supported (based on TLS 1.2)

## DTLS 1.3

Not yet supported

## TLS 1.3

OTP-22 introduces support for TLS 1.3. The current implementation supports a
selective set of cryptographic algorithms:

- Key Exchange: ECDHE groups supported by default
- Groups: all standard groups supported for the Diffie-Hellman key exchange
- Groups: Support brainpool groups from RFC 8734
- Ciphers: all mandatory cipher suites are supported
- Signature Algorithms: All algorithms form RFC 8446
- Certificates: RSA, ECDSA and EDDSA keys

Other notable features:

- PSK and session resumption is supported (stateful and stateless tickets)
- Anti-replay protection using Bloom-filters with stateless tickets
- Early data and 0-RTT is supported
- Key and Initialization Vector Update is supported

For more detailed information see the
[Standards Compliance](standards_compliance.md#soc_table) below.

The following table describes the current state of standards compliance for TLS
1.3.

(_C_ = Compliant, _NC_ = Non-Compliant, _PC_ = Partially-Compliant, _NA_ = Not
Applicable)

[](){: #soc_table }

| Section                                                                                                         | Feature                                                                                                                                                                                                                                                                                                   | State | Since |
| --------------------------------------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ----- | ----- |
| [1\.3. Updates Affecting TLS 1.2](https://tools.ietf.org/html/rfc8446#section-1.2)                              |                                                                                                                                                                                                                                                                                                           | C     | 24\.1 |
|                                                                                                                 | Version downgrade protection mechanism                                                                                                                                                                                                                                                                    | C     | 22    |
|                                                                                                                 | RSASSA-PSS signature schemes                                                                                                                                                                                                                                                                              | C     | 24\.1 |
|                                                                                                                 | supported_versions (ClientHello) extension                                                                                                                                                                                                                                                                | C     | 22    |
|                                                                                                                 | signature_algorithms_cert extension                                                                                                                                                                                                                                                                       | C     | 24\.1 |
| [2\. Protocol Overview](https://tools.ietf.org/html/rfc8446#section/2)                                          |                                                                                                                                                                                                                                                                                                           | PC    | 22    |
|                                                                                                                 | (EC)DHE                                                                                                                                                                                                                                                                                                   | C     | 22    |
|                                                                                                                 | PSK-only                                                                                                                                                                                                                                                                                                  | NC    |       |
|                                                                                                                 | PSK with (EC)DHE                                                                                                                                                                                                                                                                                          | C     | 22\.2 |
| [2\.1. Incorrect DHE share](https://tools.ietf.org/html/rfc8446#section-2.1)                                    | HelloRetryRequest                                                                                                                                                                                                                                                                                         | C     | 22    |
| [2\.2. Resumption and Pre-Shared Key (PSK)](https://tools.ietf.org/html/rfc8446#section-2.2)                    |                                                                                                                                                                                                                                                                                                           | C     | 22\.2 |
| [2\.3. 0-RTT Data](https://tools.ietf.org/html/rfc8446#section-2.3)                                             |                                                                                                                                                                                                                                                                                                           | PC    | 23\.3 |
| [4\.1.1. Cryptographic Negotiation](https://tools.ietf.org/html/rfc8446#section-4.1.1)                          |                                                                                                                                                                                                                                                                                                           | C     | 22\.2 |
|                                                                                                                 | supported_groups extension                                                                                                                                                                                                                                                                                | C     | 22    |
|                                                                                                                 | signature_algorithms extension                                                                                                                                                                                                                                                                            | C     | 22    |
|                                                                                                                 | pre_shared_key extension                                                                                                                                                                                                                                                                                  | C     | 22\.2 |
| [4\.1.2. Client Hello](https://tools.ietf.org/html/rfc8446#section-4.1.2)                                       | **Client**                                                                                                                                                                                                                                                                                                | PC    | 22\.1 |
|                                                                                                                 | server_name (RFC6066)                                                                                                                                                                                                                                                                                     | C     | 23\.2 |
|                                                                                                                 | max_fragment_length (RFC6066)                                                                                                                                                                                                                                                                             | C     | 23\.0 |
|                                                                                                                 | status_request (RFC6066)                                                                                                                                                                                                                                                                                  | C     | 27\.0 |
|                                                                                                                 | supported_groups (RFC7919)                                                                                                                                                                                                                                                                                | C     | 22\.1 |
|                                                                                                                 | signature_algorithms (RFC8446)                                                                                                                                                                                                                                                                            | C     | 22\.1 |
|                                                                                                                 | use_srtp (RFC5764)                                                                                                                                                                                                                                                                                        | C     | 26\.0 |
|                                                                                                                 | heartbeat (RFC6520)                                                                                                                                                                                                                                                                                       | NC    |       |
|                                                                                                                 | application_layer_protocol_negotiation (RFC7301)                                                                                                                                                                                                                                                          | C     | 22\.1 |
|                                                                                                                 | signed_certificate_timestamp (RFC6962)                                                                                                                                                                                                                                                                    | NC    |       |
|                                                                                                                 | client_certificate_type (RFC7250)                                                                                                                                                                                                                                                                         | NC    |       |
|                                                                                                                 | server_certificate_type (RFC7250)                                                                                                                                                                                                                                                                         | NC    |       |
|                                                                                                                 | padding (RFC7685)                                                                                                                                                                                                                                                                                         | NC    |       |
|                                                                                                                 | key_share (RFC8446)                                                                                                                                                                                                                                                                                       | C     | 22\.1 |
|                                                                                                                 | pre_shared_key (RFC8446)                                                                                                                                                                                                                                                                                  | C     | 22\.2 |
|                                                                                                                 | psk_key_exchange_modes (RFC8446)                                                                                                                                                                                                                                                                          | C     | 22\.2 |
|                                                                                                                 | early_data (RFC8446)                                                                                                                                                                                                                                                                                      | C     | 23\.3 |
|                                                                                                                 | cookie (RFC8446)                                                                                                                                                                                                                                                                                          | C     | 23\.1 |
|                                                                                                                 | supported_versions (RFC8446)                                                                                                                                                                                                                                                                              | C     | 22\.1 |
|                                                                                                                 | certificate_authorities (RFC8446)                                                                                                                                                                                                                                                                         | C     | 24\.3 |
|                                                                                                                 | oid_filters (RFC8446)                                                                                                                                                                                                                                                                                     | NC    |       |
|                                                                                                                 | post_handshake_auth (RFC8446)                                                                                                                                                                                                                                                                             | NC    |       |
|                                                                                                                 | signature_algorithms_cert (RFC8446)                                                                                                                                                                                                                                                                       | C     | 22\.1 |
|                                                                                                                 | **Server**                                                                                                                                                                                                                                                                                                | PC    | 22    |
|                                                                                                                 | server_name (RFC6066)                                                                                                                                                                                                                                                                                     | C     | 23\.2 |
|                                                                                                                 | max_fragment_length (RFC6066)                                                                                                                                                                                                                                                                             | C     | 23\.0 |
|                                                                                                                 | status_request (RFC6066)                                                                                                                                                                                                                                                                                  | NC    |       |
|                                                                                                                 | supported_groups (RFC7919)                                                                                                                                                                                                                                                                                | C     | 22    |
|                                                                                                                 | signature_algorithms (RFC8446)                                                                                                                                                                                                                                                                            | C     | 22    |
|                                                                                                                 | use_srtp (RFC5764)                                                                                                                                                                                                                                                                                        | C     | 26\.0 |
|                                                                                                                 | heartbeat (RFC6520)                                                                                                                                                                                                                                                                                       | NC    |       |
|                                                                                                                 | application_layer_protocol_negotiation (RFC7301)                                                                                                                                                                                                                                                          | C     | 22\.1 |
|                                                                                                                 | signed_certificate_timestamp (RFC6962)                                                                                                                                                                                                                                                                    | NC    |       |
|                                                                                                                 | client_certificate_type (RFC7250)                                                                                                                                                                                                                                                                         | NC    |       |
|                                                                                                                 | server_certificate_type (RFC7250)                                                                                                                                                                                                                                                                         | NC    |       |
|                                                                                                                 | padding (RFC7685)                                                                                                                                                                                                                                                                                         | NC    |       |
|                                                                                                                 | key_share (RFC8446)                                                                                                                                                                                                                                                                                       | C     | 22    |
|                                                                                                                 | pre_shared_key (RFC8446)                                                                                                                                                                                                                                                                                  | C     | 22\.2 |
|                                                                                                                 | psk_key_exchange_modes (RFC8446)                                                                                                                                                                                                                                                                          | C     | 22\.2 |
|                                                                                                                 | early_data (RFC8446)                                                                                                                                                                                                                                                                                      | C     | 23\.3 |
|                                                                                                                 | cookie (RFC8446)                                                                                                                                                                                                                                                                                          | C     | 23\.1 |
|                                                                                                                 | supported_versions (RFC8446)                                                                                                                                                                                                                                                                              | C     | 22    |
|                                                                                                                 | oid_filters (RFC8446)                                                                                                                                                                                                                                                                                     | NC    |       |
|                                                                                                                 | post_handshake_auth (RFC8446)                                                                                                                                                                                                                                                                             | NC    |       |
|                                                                                                                 | signature_algorithms_cert (RFC8446)                                                                                                                                                                                                                                                                       | C     | 22    |
| [4\.1.3. Server Hello](https://tools.ietf.org/html/rfc8446#section-4.1.3)                                       | **Client**                                                                                                                                                                                                                                                                                                | C     | 22\.2 |
|                                                                                                                 | Version downgrade protection                                                                                                                                                                                                                                                                              | C     | 22\.1 |
|                                                                                                                 | key_share (RFC8446)                                                                                                                                                                                                                                                                                       | C     | 22\.1 |
|                                                                                                                 | pre_shared_key (RFC8446)                                                                                                                                                                                                                                                                                  | C     | 22\.2 |
|                                                                                                                 | supported_versions (RFC8446)                                                                                                                                                                                                                                                                              | C     | 22\.1 |
|                                                                                                                 | use_srtp (RFC5764)                                                                                                                                                                                                                                                                                        | C     | 26\.0 |
|                                                                                                                 | **Server**                                                                                                                                                                                                                                                                                                | C     | 22\.2 |
|                                                                                                                 | Version downgrade protection                                                                                                                                                                                                                                                                              | C     | 22    |
|                                                                                                                 | key_share (RFC8446)                                                                                                                                                                                                                                                                                       | C     | 22    |
|                                                                                                                 | pre_shared_key (RFC8446)                                                                                                                                                                                                                                                                                  | C     | 22\.2 |
|                                                                                                                 | supported_versions (RFC8446)                                                                                                                                                                                                                                                                              | C     | 22    |
|                                                                                                                 | use_srtp (RFC5764)                                                                                                                                                                                                                                                                                        | C     | 26\.0 |
| [4\.1.4. Hello Retry Request](https://tools.ietf.org/html/rfc8446#section-4.1.4)                                | **Server**                                                                                                                                                                                                                                                                                                | C     | 22    |
|                                                                                                                 | key_share (RFC8446)                                                                                                                                                                                                                                                                                       | C     | 22    |
|                                                                                                                 | cookie (RFC8446)                                                                                                                                                                                                                                                                                          | C     | 23\.1 |
|                                                                                                                 | supported_versions (RFC8446)                                                                                                                                                                                                                                                                              | C     | 22    |
| [4\.2.1. Supported Versions](https://tools.ietf.org/html/rfc8446#section-4.2.1)                                 | **Client**                                                                                                                                                                                                                                                                                                | C     | 22\.1 |
|                                                                                                                 | **Server**                                                                                                                                                                                                                                                                                                | C     | 22    |
| [4\.2.2. Cookie](https://tools.ietf.org/html/rfc8446#section-4.2.2)                                             | **Client**                                                                                                                                                                                                                                                                                                | C     | 23\.1 |
|                                                                                                                 | **Server**                                                                                                                                                                                                                                                                                                | C     | 23\.1 |
| [4\.2.3. Signature Algorithms](https://tools.ietf.org/html/rfc8446#section-4.2.3)                               | **Client**                                                                                                                                                                                                                                                                                                | C     | 24    |
|                                                                                                                 | rsa_pkcs1_sha256                                                                                                                                                                                                                                                                                          | C     | 22\.1 |
|                                                                                                                 | rsa_pkcs1_sha384                                                                                                                                                                                                                                                                                          | C     | 22\.1 |
|                                                                                                                 | rsa_pkcs1_sha512                                                                                                                                                                                                                                                                                          | C     | 22\.1 |
|                                                                                                                 | ecdsa_secp256r1_sha256                                                                                                                                                                                                                                                                                    | C     | 22\.1 |
|                                                                                                                 | ecdsa_secp384r1_sha384                                                                                                                                                                                                                                                                                    | C     | 22\.1 |
|                                                                                                                 | ecdsa_secp521r1_sha512                                                                                                                                                                                                                                                                                    | C     | 22\.1 |
|                                                                                                                 | rsa_pss_rsae_sha256                                                                                                                                                                                                                                                                                       | C     | 22\.1 |
|                                                                                                                 | rsa_pss_rsae_sha384                                                                                                                                                                                                                                                                                       | C     | 22\.1 |
|                                                                                                                 | rsa_pss_rsae_sha512                                                                                                                                                                                                                                                                                       | C     | 22\.1 |
|                                                                                                                 | ed25519                                                                                                                                                                                                                                                                                                   | C     | 24    |
|                                                                                                                 | ed448                                                                                                                                                                                                                                                                                                     | C     | 24    |
|                                                                                                                 | rsa_pss_pss_sha256                                                                                                                                                                                                                                                                                        | C     | 23    |
|                                                                                                                 | rsa_pss_pss_sha384                                                                                                                                                                                                                                                                                        | C     | 23    |
|                                                                                                                 | rsa_pss_pss_sha512                                                                                                                                                                                                                                                                                        | C     | 23    |
|                                                                                                                 | rsa_pkcs1_sha1                                                                                                                                                                                                                                                                                            | C     | 22\.1 |
|                                                                                                                 | ecdsa_sha1                                                                                                                                                                                                                                                                                                | C     | 22\.1 |
|                                                                                                                 | **Server**                                                                                                                                                                                                                                                                                                | C     | 24    |
|                                                                                                                 | rsa_pkcs1_sha256                                                                                                                                                                                                                                                                                          | C     | 22    |
|                                                                                                                 | rsa_pkcs1_sha384                                                                                                                                                                                                                                                                                          | C     | 22    |
|                                                                                                                 | rsa_pkcs1_sha512                                                                                                                                                                                                                                                                                          | C     | 22    |
|                                                                                                                 | ecdsa_secp256r1_sha256                                                                                                                                                                                                                                                                                    | C     | 22\.1 |
|                                                                                                                 | ecdsa_secp384r1_sha384                                                                                                                                                                                                                                                                                    | C     | 22\.1 |
|                                                                                                                 | ecdsa_secp521r1_sha512                                                                                                                                                                                                                                                                                    | C     | 22\.1 |
|                                                                                                                 | rsa_pss_rsae_sha256                                                                                                                                                                                                                                                                                       | C     | 22    |
|                                                                                                                 | rsa_pss_rsae_sha384                                                                                                                                                                                                                                                                                       | C     | 22    |
|                                                                                                                 | rsa_pss_rsae_sha512                                                                                                                                                                                                                                                                                       | C     | 22    |
|                                                                                                                 | ed25519                                                                                                                                                                                                                                                                                                   | C     | 24    |
|                                                                                                                 | ed448                                                                                                                                                                                                                                                                                                     | C     | 24    |
|                                                                                                                 | rsa_pss_pss_sha256                                                                                                                                                                                                                                                                                        | C     | 23    |
|                                                                                                                 | rsa_pss_pss_sha384                                                                                                                                                                                                                                                                                        | C     | 23    |
|                                                                                                                 | rsa_pss_pss_sha512                                                                                                                                                                                                                                                                                        | C     | 23    |
|                                                                                                                 | rsa_pkcs1_sha1                                                                                                                                                                                                                                                                                            | C     | 22    |
|                                                                                                                 | ecdsa_sha1                                                                                                                                                                                                                                                                                                | C     | 22    |
| [4\.2.4. Certificate Authorities](https://tools.ietf.org/html/rfc8446#section-4.2.4)                            | **Client**                                                                                                                                                                                                                                                                                                | C     | 24\.3 |
|                                                                                                                 | **Server**                                                                                                                                                                                                                                                                                                | C     | 24\.3 |
| [4\.2.5. OID Filters](https://tools.ietf.org/html/rfc8446#section-4.2.5)                                        | **Client**                                                                                                                                                                                                                                                                                                | NC    |       |
|                                                                                                                 | **Server**                                                                                                                                                                                                                                                                                                | NC    |       |
| [4\.2.6. Post-Handshake Client Authentication](https://tools.ietf.org/html/rfc8446#section-4.2.6)               | **Client**                                                                                                                                                                                                                                                                                                | NC    |       |
|                                                                                                                 | **Server**                                                                                                                                                                                                                                                                                                | NC    |       |
| [4\.2.7. Supported Groups](https://tools.ietf.org/html/rfc8446#section-4.2.7)                                   | **Client**                                                                                                                                                                                                                                                                                                | C     | 22\.1 |
|                                                                                                                 | secp256r1                                                                                                                                                                                                                                                                                                 | C     | 22\.1 |
|                                                                                                                 | secp384r1                                                                                                                                                                                                                                                                                                 | C     | 22\.1 |
|                                                                                                                 | secp521r1                                                                                                                                                                                                                                                                                                 | C     | 22\.1 |
|                                                                                                                 | x25519                                                                                                                                                                                                                                                                                                    | C     | 22\.1 |
|                                                                                                                 | x448                                                                                                                                                                                                                                                                                                      | C     | 22\.1 |
|                                                                                                                 | ffdhe2048                                                                                                                                                                                                                                                                                                 | C     | 22\.1 |
|                                                                                                                 | ffdhe3072                                                                                                                                                                                                                                                                                                 | C     | 22\.1 |
|                                                                                                                 | ffdhe4096                                                                                                                                                                                                                                                                                                 | C     | 22\.1 |
|                                                                                                                 | ffdhe6144                                                                                                                                                                                                                                                                                                 | C     | 22\.1 |
|                                                                                                                 | ffdhe8192                                                                                                                                                                                                                                                                                                 | C     | 22\.1 |
|                                                                                                                 | **Server**                                                                                                                                                                                                                                                                                                | C     | 22    |
|                                                                                                                 | secp256r1                                                                                                                                                                                                                                                                                                 | C     | 22    |
|                                                                                                                 | secp384r1                                                                                                                                                                                                                                                                                                 | C     | 22    |
|                                                                                                                 | secp521r1                                                                                                                                                                                                                                                                                                 | C     | 22    |
|                                                                                                                 | x25519                                                                                                                                                                                                                                                                                                    | C     | 22    |
|                                                                                                                 | x448                                                                                                                                                                                                                                                                                                      | C     | 22    |
|                                                                                                                 | ffdhe2048                                                                                                                                                                                                                                                                                                 | C     | 22    |
|                                                                                                                 | ffdhe3072                                                                                                                                                                                                                                                                                                 | C     | 22    |
|                                                                                                                 | ffdhe4096                                                                                                                                                                                                                                                                                                 | C     | 22    |
|                                                                                                                 | ffdhe6144                                                                                                                                                                                                                                                                                                 | C     | 22    |
|                                                                                                                 | ffdhe8192                                                                                                                                                                                                                                                                                                 | C     | 22    |
| [4\.2.8. Key Share](https://tools.ietf.org/html/rfc8446#section-4.2.8)                                          | **Client**                                                                                                                                                                                                                                                                                                | C     | 22\.1 |
|                                                                                                                 | **Server**                                                                                                                                                                                                                                                                                                | C     | 22    |
| [4\.2.9. Pre-Shared Key Exchange Modes](https://tools.ietf.org/html/rfc8446#section-4.2.9)                      | **Client**                                                                                                                                                                                                                                                                                                | C     | 22\.2 |
|                                                                                                                 | **Server**                                                                                                                                                                                                                                                                                                | C     | 22\.2 |
| [4\.2.10. Early Data Indication](https://tools.ietf.org/html/rfc8446#section-4.2.10)                            | **Client**                                                                                                                                                                                                                                                                                                | C     | 23\.3 |
|                                                                                                                 | **Server**                                                                                                                                                                                                                                                                                                | C     | 23\.3 |
| [4\.2.11. Pre-Shared Key Extension](https://tools.ietf.org/html/rfc8446#section-4.2.11)                         | **Client**                                                                                                                                                                                                                                                                                                | C     | 22\.2 |
|                                                                                                                 | **Server**                                                                                                                                                                                                                                                                                                | C     | 22\.2 |
| [4\.2.11.1. Ticket Age](https://tools.ietf.org/html/rfc8446#section-4.2.11.1)                                   | **Client**                                                                                                                                                                                                                                                                                                | C     | 22\.2 |
|                                                                                                                 | **Server**                                                                                                                                                                                                                                                                                                | C     | 22\.2 |
| [4\.2.11.2. PSK Binder](https://tools.ietf.org/html/rfc8446#section-4.2.11.2)                                   | **Client**                                                                                                                                                                                                                                                                                                | C     | 22\.2 |
|                                                                                                                 | **Server**                                                                                                                                                                                                                                                                                                | C     | 22\.2 |
| [4\.2.11.3. Processing Order](https://tools.ietf.org/html/rfc8446#section-4.2.11.3)                             | **Client**                                                                                                                                                                                                                                                                                                | NC    |       |
|                                                                                                                 | **Server**                                                                                                                                                                                                                                                                                                | NC    |       |
| [4\.3.1. Encrypted Extensions](https://tools.ietf.org/html/rfc8446#section-4.3.1)                               | **Client**                                                                                                                                                                                                                                                                                                | PC    | 22\.1 |
|                                                                                                                 | server_name (RFC6066)                                                                                                                                                                                                                                                                                     | C     | 23\.2 |
|                                                                                                                 | max_fragment_length (RFC6066)                                                                                                                                                                                                                                                                             | C     | 23\.0 |
|                                                                                                                 | supported_groups (RFC7919)                                                                                                                                                                                                                                                                                | NC    |       |
|                                                                                                                 | use_srtp (RFC5764)                                                                                                                                                                                                                                                                                        | NC    |       |
|                                                                                                                 | heartbeat (RFC6520)                                                                                                                                                                                                                                                                                       | NC    |       |
|                                                                                                                 | application_layer_protocol_negotiation (RFC7301)                                                                                                                                                                                                                                                          | C     | 23\.0 |
|                                                                                                                 | client_certificate_type (RFC7250)                                                                                                                                                                                                                                                                         | NC    |       |
|                                                                                                                 | server_certificate_type (RFC7250)                                                                                                                                                                                                                                                                         | NC    |       |
|                                                                                                                 | early_data (RFC8446)                                                                                                                                                                                                                                                                                      | C     | 23\.3 |
|                                                                                                                 | **Server**                                                                                                                                                                                                                                                                                                | PC    | 22    |
|                                                                                                                 | server_name (RFC6066)                                                                                                                                                                                                                                                                                     | C     | 23\.2 |
|                                                                                                                 | max_fragment_length (RFC6066)                                                                                                                                                                                                                                                                             | C     | 23\.0 |
|                                                                                                                 | supported_groups (RFC7919)                                                                                                                                                                                                                                                                                | NC    |       |
|                                                                                                                 | use_srtp (RFC5764)                                                                                                                                                                                                                                                                                        | NC    |       |
|                                                                                                                 | heartbeat (RFC6520)                                                                                                                                                                                                                                                                                       | NC    |       |
|                                                                                                                 | application_layer_protocol_negotiation (RFC7301)                                                                                                                                                                                                                                                          | C     | 23\.0 |
|                                                                                                                 | client_certificate_type (RFC7250)                                                                                                                                                                                                                                                                         | NC    |       |
|                                                                                                                 | server_certificate_type (RFC7250)                                                                                                                                                                                                                                                                         | NC    |       |
|                                                                                                                 | early_data (RFC8446)                                                                                                                                                                                                                                                                                      | C     | 23\.3 |
| [4\.3.2. Certificate Request](https://tools.ietf.org/html/rfc8446#section-4.3.2)                                | **Client**                                                                                                                                                                                                                                                                                                | PC    | 22\.1 |
|                                                                                                                 | status_request (RFC6066)                                                                                                                                                                                                                                                                                  | NC    |       |
|                                                                                                                 | signature_algorithms (RFC8446)                                                                                                                                                                                                                                                                            | C     | 22\.1 |
|                                                                                                                 | signed_certificate_timestamp (RFC6962)                                                                                                                                                                                                                                                                    | NC    |       |
|                                                                                                                 | certificate_authorities (RFC8446)                                                                                                                                                                                                                                                                         | C     | 24\.3 |
|                                                                                                                 | oid_filters (RFC8446)                                                                                                                                                                                                                                                                                     | NC    |       |
|                                                                                                                 | signature_algorithms_cert (RFC8446)                                                                                                                                                                                                                                                                       | C     | 22\.1 |
|                                                                                                                 | **Server**                                                                                                                                                                                                                                                                                                | PC    | 22    |
|                                                                                                                 | status_request (RFC6066)                                                                                                                                                                                                                                                                                  | NC    |       |
|                                                                                                                 | signature_algorithms (RFC8446)                                                                                                                                                                                                                                                                            | C     | 22    |
|                                                                                                                 | signed_certificate_timestamp (RFC6962)                                                                                                                                                                                                                                                                    | NC    |       |
|                                                                                                                 | certificate_authorities (RFC8446)                                                                                                                                                                                                                                                                         | C     | 24\.3 |
|                                                                                                                 | oid_filters (RFC8446)                                                                                                                                                                                                                                                                                     | NC    |       |
|                                                                                                                 | signature_algorithms_cert (RFC8446)                                                                                                                                                                                                                                                                       | C     | 22    |
| [4\.4.1. The Transcript Hash](https://tools.ietf.org/html/rfc8446#section-4.4.1)                                |                                                                                                                                                                                                                                                                                                           | C     | 22    |
| [4\.4.2. Certificate](https://tools.ietf.org/html/rfc8446#section-4.4.2)                                        | **Client**                                                                                                                                                                                                                                                                                                | PC    | 22\.1 |
|                                                                                                                 | Arbitrary certificate chain orderings                                                                                                                                                                                                                                                                     | C     | 22\.2 |
|                                                                                                                 | Extraneous certificates in chain                                                                                                                                                                                                                                                                          | C     | 23\.2 |
|                                                                                                                 | status_request (RFC6066)                                                                                                                                                                                                                                                                                  | C     | 27\.0 |
|                                                                                                                 | signed_certificate_timestamp (RFC6962)                                                                                                                                                                                                                                                                    | NC    |       |
|                                                                                                                 | **Server**                                                                                                                                                                                                                                                                                                    | PC    | 22    |
|                                                                                                                 | status_request (RFC6066)                                                                                                                                                                                                                                                                                  | NC    |       |
|                                                                                                                 | signed_certificate_timestamp (RFC6962)                                                                                                                                                                                                                                                                    | NC    |       |
| [4\.4.2.1. OCSP Status and SCT Extensions](https://tools.ietf.org/html/rfc8446#section-4.4.2.1)                 | **Client**                                                                                                                                                                                                                                                                                                | PC    | 27\.0 |
|                                                                                                                 | **Server**                                                                                                                                                                                                                                                                                                | NC    |       |
| [4\.4.2.2. Server Certificate Selection](https://tools.ietf.org/html/rfc8446#section-4.4.2.2)                   |                                                                                                                                                                                                                                                                                                           | C     | 24\.3 |
|                                                                                                                 | The certificate type MUST be X.509v3, unless explicitly negotiated otherwise                                                                                                                                                                                                                              | C     | 22    |
|                                                                                                                 | The server's end-entity certificate's public key (and associated restrictions) MUST be compatible with the selected authentication algorithm from the client's "signature_algorithms" extension (currently RSA, ECDSA, or EdDSA).                                                                         | C     | 22    |
|                                                                                                                 | The certificate MUST allow the key to be used for signing with a signature scheme indicated in the client's "signature_algorithms"/"signature_algorithms_cert" extensions                                                                                                                                 | C     | 22    |
|                                                                                                                 | The "server_name" and "certificate_authorities" extensions are used to guide certificate selection. As servers MAY require the presence of the "server_name" extension, clients SHOULD send this extension, when applicable.                                                                              | C     | 24\.3 |
| [4\.4.2.3. Client Certificate Selection](https://tools.ietf.org/html/rfc8446#section-4.4.2.3)                   |                                                                                                                                                                                                                                                                                                           | PC    | 22\.1 |
|                                                                                                                 | The certificate type MUST be X.509v3, unless explicitly negotiated otherwise                                                                                                                                                                                                                              | C     | 22\.1 |
|                                                                                                                 | If the "certificate_authorities" extension in the CertificateRequest message was present, at least one of the certificates in the certificate chain SHOULD be issued by one of the listed CAs.                                                                                                            | C     | 24\.3 |
|                                                                                                                 | The certificates MUST be signed using an acceptable signature algorithm                                                                                                                                                                                                                                   | C     | 22\.1 |
|                                                                                                                 | If the CertificateRequest message contained a non-empty "oid_filters" extension, the end-entity certificate MUST match the extension OIDs that are recognized by the client                                                                                                                               | NC    |       |
| [4\.4.2.4. Receiving a Certificate Message](https://tools.ietf.org/html/rfc8446#section-4.4.2.4)                | **Client**                                                                                                                                                                                                                                                                                                | C     | 22\.1 |
|                                                                                                                 | **Server**                                                                                                                                                                                                                                                                                                | C     | 22    |
| [4\.4.3. Certificate Verify](https://tools.ietf.org/html/rfc8446#section-4.4.3)                                 | **Client**                                                                                                                                                                                                                                                                                                | C     | 22\.1 |
|                                                                                                                 | **Server**                                                                                                                                                                                                                                                                                                | C     | 22    |
| [4\.4.4. Finished](https://tools.ietf.org/html/rfc8446#section-4.4.4)                                           | **Client**                                                                                                                                                                                                                                                                                                | C     | 22\.1 |
|                                                                                                                 | **Server**                                                                                                                                                                                                                                                                                                | C     | 22    |
| [4\.5. End of Early Data](https://tools.ietf.org/html/rfc8446#section-4.5)                                      | **Client**                                                                                                                                                                                                                                                                                                | C     | 23\.3 |
|                                                                                                                 | **Server**                                                                                                                                                                                                                                                                                                | C     | 23\.3 |
| [4\.6.1. New Session Ticket Message](https://tools.ietf.org/html/rfc8446#section-4.6.1)                         | **Client**                                                                                                                                                                                                                                                                                                | C     | 23\.3 |
|                                                                                                                 | early_data (RFC8446)                                                                                                                                                                                                                                                                                      | C     | 23\.3 |
|                                                                                                                 | **Server**                                                                                                                                                                                                                                                                                                | C     | 23\.3 |
|                                                                                                                 | early_data (RFC8446)                                                                                                                                                                                                                                                                                      | C     | 23\.3 |
| [4\.6.2. Post-Handshake Authentication](https://tools.ietf.org/html/rfc8446#section-4.6.2)                      | **Client**                                                                                                                                                                                                                                                                                                | NC    |       |
|                                                                                                                 | **Server**                                                                                                                                                                                                                                                                                                | NC    |       |
| [4\.6.3. Key and Initialization Vector Update](https://tools.ietf.org/html/rfc8446#section-4.6.3)               | **Client**                                                                                                                                                                                                                                                                                                | C     | 22\.3 |
|                                                                                                                 | **Server**                                                                                                                                                                                                                                                                                                | C     | 22\.3 |
| [5\.1. Record Layer](https://tools.ietf.org/html/rfc8446#section-5.1)                                           |                                                                                                                                                                                                                                                                                                           | C     | 22    |
|                                                                                                                 | MUST NOT be interleaved with other record types                                                                                                                                                                                                                                                           | C     | 22    |
|                                                                                                                 | MUST NOT span key changes                                                                                                                                                                                                                                                                                 | C     | 22    |
|                                                                                                                 | MUST NOT send zero-length fragments                                                                                                                                                                                                                                                                       | C     | 22    |
|                                                                                                                 | Alert messages MUST NOT be fragmented                                                                                                                                                                                                                                                                     | C     | 22    |
| [5\.2. Record Payload Protection](https://tools.ietf.org/html/rfc8446#section-5.2)                              |                                                                                                                                                                                                                                                                                                           | C     | 22    |
| [5\.3. Per-Record Nonce](https://tools.ietf.org/html/rfc8446#section-5.3)                                       |                                                                                                                                                                                                                                                                                                           | C     | 22    |
| [5\.4. Record Padding](https://tools.ietf.org/html/rfc8446#section-5.4)                                         |                                                                                                                                                                                                                                                                                                           | PC    | 22    |
|                                                                                                                 | MAY choose to pad                                                                                                                                                                                                                                                                                         | NC    |       |
|                                                                                                                 | MUST NOT send Handshake and Alert records that have a zero-length TLSInnerPlaintext.content                                                                                                                                                                                                               | NC    |       |
|                                                                                                                 | The padding sent is automatically verified                                                                                                                                                                                                                                                                | C     | 22    |
| [5\.5. Limits on Key Usage](https://tools.ietf.org/html/rfc8446#section-5.5)                                    |                                                                                                                                                                                                                                                                                                           | C     | 22\.3 |
| [6\.1. Closure Alerts](https://tools.ietf.org/html/rfc8446#section-6.1)                                         |                                                                                                                                                                                                                                                                                                           | 22    |       |
|                                                                                                                 | close_notify                                                                                                                                                                                                                                                                                              | C     | 22    |  |
|                                                                                                                 | user_cancelled                                                                                                                                                                                                                                                                                            | C     | 22    |  |
| [6\.2. Error Alerts](https://tools.ietf.org/html/rfc8446#section-6.2)                                           |                                                                                                                                                                                                                                                                                                           | PC    | 22    |
| [7\.1. Key Schedule](https://tools.ietf.org/html/rfc8446#section-7.1)                                           |                                                                                                                                                                                                                                                                                                           | C     | 22    |
| [7\.2. Updating Traffic Secrets](https://tools.ietf.org/html/rfc8446#section-7.2)                               |                                                                                                                                                                                                                                                                                                           | C     | 22    |
| [7\.3. Traffic Key Calculation](https://tools.ietf.org/html/rfc8446#section-7.3)                                |                                                                                                                                                                                                                                                                                                           | C     | 22    |
| [7\.5. Exporters](https://tools.ietf.org/html/rfc8446#section-7.5)                                              |                                                                                                                                                                                                                                                                                                           | PC    | 26\.3 |
| [8\. 0-RTT and Anti-Replay](https://tools.ietf.org/html/rfc8446#section/8)                                      |                                                                                                                                                                                                                                                                                                           | C     | 22\.2 |
| [8\.1. Single-Use Tickets](https://tools.ietf.org/html/rfc8446#section-8.1)                                     |                                                                                                                                                                                                                                                                                                           | C     | 22\.2 |
| [8\.2. Client Hello Recording](https://tools.ietf.org/html/rfc8446#section-8.2)                                 |                                                                                                                                                                                                                                                                                                           | C     | 22\.2 |
| [8\.3. Freshness Checks](https://tools.ietf.org/html/rfc8446#section-8.3)                                       |                                                                                                                                                                                                                                                                                                           | C     | 22\.2 |
| [9\.1. Mandatory-to-Implement Cipher Suites](https://tools.ietf.org/html/rfc8446#section-9.1)                   |                                                                                                                                                                                                                                                                                                           | C     | 22\.1 |
|                                                                                                                 | MUST implement the TLS_AES_128_GCM_SHA256                                                                                                                                                                                                                                                                 | C     | 22    |
|                                                                                                                 | SHOULD implement the TLS_AES_256_GCM_SHA384                                                                                                                                                                                                                                                               | C     | 22    |
|                                                                                                                 | SHOULD implement the TLS_CHACHA20_POLY1305_SHA256                                                                                                                                                                                                                                                         | C     | 22    |
|                                                                                                                 | **Digital signatures**                                                                                                                                                                                                                                                                                    | C     | 22\.1 |
|                                                                                                                 | MUST support rsa_pkcs1_sha256 (for certificates)                                                                                                                                                                                                                                                          | C     | 22    |
|                                                                                                                 | MUST support rsa_pss_rsae_sha256 (for CertificateVerify and certificates)                                                                                                                                                                                                                                 | C     | 22    |
|                                                                                                                 | MUST support ecdsa_secp256r1_sha256                                                                                                                                                                                                                                                                       | C     | 22\.1 |
|                                                                                                                 | **Key Exchange**                                                                                                                                                                                                                                                                                          | C     | 22    |
|                                                                                                                 | MUST support key exchange with secp256r1                                                                                                                                                                                                                                                                  | C     | 22    |
|                                                                                                                 | SHOULD support key exchange with X25519                                                                                                                                                                                                                                                                   | C     | 22    |
| [9\.2. Mandatory-to-Implement Extensions](https://tools.ietf.org/html/rfc8446#section-9.2)                      |                                                                                                                                                                                                                                                                                                           | C     | 23\.2 |
|                                                                                                                 | Supported Versions                                                                                                                                                                                                                                                                                        | C     | 22    |
|                                                                                                                 | Cookie                                                                                                                                                                                                                                                                                                    | C     | 23\.1 |
|                                                                                                                 | Signature Algorithms                                                                                                                                                                                                                                                                                      | C     | 22    |
|                                                                                                                 | Signature Algorithms Certificate                                                                                                                                                                                                                                                                          | C     | 22    |
|                                                                                                                 | Negotiated Groups                                                                                                                                                                                                                                                                                         | C     | 22    |
|                                                                                                                 | Key Share                                                                                                                                                                                                                                                                                                 | C     | 22    |
|                                                                                                                 | Server Name Indication                                                                                                                                                                                                                                                                                    | C     | 23\.2 |
|                                                                                                                 | **MUST send and use these extensions**                                                                                                                                                                                                                                                                    | C     | 22\.2 |
|                                                                                                                 | "supported_versions" is REQUIRED for ClientHello, ServerHello and HelloRetryRequest                                                                                                                                                                                                                       | C     | 22\.1 |
|                                                                                                                 | "signature_algorithms" is REQUIRED for certificate authentication                                                                                                                                                                                                                                         | C     | 22    |
|                                                                                                                 | "supported_groups" is REQUIRED for ClientHello messages using (EC)DHE key exchange                                                                                                                                                                                                                        | C     | 22    |
|                                                                                                                 | "key_share" is REQUIRED for (EC)DHE key exchange                                                                                                                                                                                                                                                          | C     | 22    |
|                                                                                                                 | "pre_shared_key" is REQUIRED for PSK key agreement                                                                                                                                                                                                                                                        | C     | 22\.2 |
|                                                                                                                 | "psk_key_exchange_modes" is REQUIRED for PSK key agreement                                                                                                                                                                                                                                                | C     | 22\.2 |
|                                                                                                                 | **TLS 1.3 ClientHello**                                                                                                                                                                                                                                                                                   | C     | 22\.1 |
|                                                                                                                 | If not containing a "pre_shared_key" extension, it MUST contain both a "signature_algorithms" extension and a "supported_groups" extension.                                                                                                                                                               | C     | 22\.1 |
|                                                                                                                 | If containing a "supported_groups" extension, it MUST also contain a "key_share" extension, and vice versa. An empty KeyShare.client_shares vector is permitted.                                                                                                                                          | C     | 22\.1 |
|                                                                                                                 | **TLS 1.3 ServerHello**                                                                                                                                                                                                                                                                                   | C     | 23\.2 |
|                                                                                                                 | MUST support the use of the "server_name" extension                                                                                                                                                                                                                                                       | C     | 23\.2 |
| [9\.3. Protocol Invariants](https://tools.ietf.org/html/rfc8446#section-9.3)                                    |                                                                                                                                                                                                                                                                                                           | C     | 22\.1 |
|                                                                                                                 | **MUST correctly handle extensible fields**                                                                                                                                                                                                                                                               | C     | 22\.1 |
|                                                                                                                 | A client sending a ClientHello MUST support all parameters advertised in it. Otherwise, the server may fail to interoperate by selecting one of those parameters.                                                                                                                                         | C     | 22\.1 |
|                                                                                                                 | A server receiving a ClientHello MUST correctly ignore all unrecognized cipher suites, extensions, and other parameters. Otherwise, it may fail to interoperate with newer clients. In TLS 1.3, a client receiving a CertificateRequest or NewSessionTicket MUST also ignore all unrecognized extensions. | C     | 22\.1 |
|                                                                                                                 | A middlebox which terminates a TLS connection MUST behave as a compliant TLS server                                                                                                                                                                                                                       | NA    |       |
|                                                                                                                 | A middlebox which forwards ClientHello parameters it does not understand MUST NOT process any messages beyond that ClientHello. It MUST forward all subsequent traffic unmodified. Otherwise, it may fail to interoperate with newer clients and servers.                                                 | NA    |       |
| [B.4. Cipher Suites](https://tools.ietf.org/html/rfc8446#section-B.4)                                           |                                                                                                                                                                                                                                                                                                           | C     | 23    |
|                                                                                                                 | TLS_AES_128_GCM_SHA256                                                                                                                                                                                                                                                                                    | C     | 22    |
|                                                                                                                 | TLS_AES_256_GCM_SHA384                                                                                                                                                                                                                                                                                    | C     | 22    |
|                                                                                                                 | TLS_CHACHA20_POLY1305_SHA256                                                                                                                                                                                                                                                                              | C     | 22    |
|                                                                                                                 | TLS_AES_128_CCM_SHA256                                                                                                                                                                                                                                                                                    | C     | 22    |
|                                                                                                                 | TLS_AES_128_CCM_8_SHA256                                                                                                                                                                                                                                                                                  | C     | 23    |
| [C.1. Random Number Generation and Seeding](https://tools.ietf.org/html/rfc8446#section-C.1)                    |                                                                                                                                                                                                                                                                                                           | C     | 22    |
| [C.2. Certificates and Authentication](https://tools.ietf.org/html/rfc8446#section-C.2)                         |                                                                                                                                                                                                                                                                                                           | C     | 22    |
| [C.3. Implementation Pitfalls](https://tools.ietf.org/html/rfc8446#section-C.3)                                 |                                                                                                                                                                                                                                                                                                           | PC    | 22    |
| [C.4. Client Tracking Prevention](https://tools.ietf.org/html/rfc8446#section-C.4)                              |                                                                                                                                                                                                                                                                                                           | C     | 22\.2 |
| [C.5. Unauthenticated Operation](https://tools.ietf.org/html/rfc8446#section-C.5)                               |                                                                                                                                                                                                                                                                                                           | C     | 22    |
| [D.1. Negotiating with an Older Server](https://tools.ietf.org/html/rfc8446#section-D.1)                        |                                                                                                                                                                                                                                                                                                           | C     | 22\.2 |
| [D.2. Negotiating with an Older Client](https://tools.ietf.org/html/rfc8446#section-D.2)                        |                                                                                                                                                                                                                                                                                                           | C     | 22    |
| [D.3. 0-RTT Backward Compatibility](https://tools.ietf.org/html/rfc8446#section-D.3)                            |                                                                                                                                                                                                                                                                                                           | NC    |       |
| [D.4. Middlebox Compatibility Mode](https://tools.ietf.org/html/rfc8446#section-D.4)                            |                                                                                                                                                                                                                                                                                                           | C     | 23    |
| [D.5. Security Restrictions Related to Backward Compatibility](https://tools.ietf.org/html/rfc8446#section-D.5) |                                                                                                                                                                                                                                                                                                           | C     | 22    |

_Table: Standards Compliance_
