# Generated by Django 4.2.25 on 2025-10-14 04:17

import django.db.models.deletion
import django.utils.timezone
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("contenttypes", "0002_remove_content_type_name"),
    ]

    operations = [
        migrations.CreateModel(
            name="CustomLogEntryModel",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "object_pk",
                    models.CharField(
                        db_index=True, max_length=255, verbose_name="object pk"
                    ),
                ),
                (
                    "object_id",
                    models.BigIntegerField(
                        blank=True, db_index=True, null=True, verbose_name="object id"
                    ),
                ),
                ("object_repr", models.TextField(verbose_name="object representation")),
                ("serialized_data", models.JSONField(null=True)),
                (
                    "action",
                    models.PositiveSmallIntegerField(
                        choices=[
                            (0, "create"),
                            (1, "update"),
                            (2, "delete"),
                            (3, "access"),
                        ],
                        db_index=True,
                        verbose_name="action",
                    ),
                ),
                (
                    "changes_text",
                    models.TextField(blank=True, verbose_name="change message"),
                ),
                ("changes", models.JSONField(null=True, verbose_name="change message")),
                (
                    "cid",
                    models.CharField(
                        blank=True,
                        db_index=True,
                        max_length=255,
                        null=True,
                        verbose_name="Correlation ID",
                    ),
                ),
                (
                    "remote_addr",
                    models.GenericIPAddressField(
                        blank=True, null=True, verbose_name="remote address"
                    ),
                ),
                (
                    "remote_port",
                    models.PositiveIntegerField(
                        blank=True, null=True, verbose_name="remote port"
                    ),
                ),
                (
                    "timestamp",
                    models.DateTimeField(
                        db_index=True,
                        default=django.utils.timezone.now,
                        verbose_name="timestamp",
                    ),
                ),
                (
                    "additional_data",
                    models.JSONField(
                        blank=True, null=True, verbose_name="additional data"
                    ),
                ),
                (
                    "actor_email",
                    models.CharField(
                        blank=True,
                        max_length=254,
                        null=True,
                        verbose_name="actor email",
                    ),
                ),
                ("role", models.CharField(blank=True, max_length=100, null=True)),
                (
                    "actor",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="actor",
                    ),
                ),
                (
                    "content_type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="contenttypes.contenttype",
                        verbose_name="content type",
                    ),
                ),
            ],
            options={
                "verbose_name": "log entry",
                "verbose_name_plural": "log entries",
                "ordering": ["-timestamp"],
                "get_latest_by": "timestamp",
                "abstract": False,
            },
        ),
    ]
